/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.DseTestFixtures;
import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.DefaultConsistencyLevelRegistry;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.cql.RequestHandlerTestHarness;
import com.datastax.oss.driver.internal.core.servererrors.DefaultWriteTypeRegistry;
import com.datastax.oss.driver.internal.core.session.throttling.PassThroughRequestThrottler;
import com.datastax.oss.driver.internal.core.tracker.NoopRequestTracker;
import com.datastax.oss.protocol.internal.Frame;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.netty.channel.EventLoop;
import java.time.Duration;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;

public class GraphRequestHandlerTestHarness
extends RequestHandlerTestHarness {
    @Mock
    DriverExecutionProfile testProfile;
    @Mock
    DriverExecutionProfile systemQueryExecutionProfile;
    @Mock
    DefaultDriverContext dseDriverContext;
    @Mock
    EventLoop eventLoop;

    protected GraphRequestHandlerTestHarness(Builder builder, @Nullable GraphProtocol graphProtocolForTestConfig, Duration graphTimeout, @Nullable Version dseVersionForTestMetadata) {
        super(builder);
        Mockito.when((Object)this.eventLoopGroup.next()).thenReturn((Object)this.eventLoop);
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DseDriverOption.GRAPH_TRAVERSAL_SOURCE, null)).thenReturn((Object)"g");
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DseDriverOption.GRAPH_SUB_PROTOCOL)).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.defaultProfile.getBoolean((DriverOption)DseDriverOption.GRAPH_IS_SYSTEM_QUERY, false)).thenReturn((Object)false);
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DseDriverOption.GRAPH_NAME, null)).thenReturn((Object)"mockGraph");
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DseDriverOption.GRAPH_TIMEOUT, Duration.ZERO)).thenReturn((Object)graphTimeout);
        Mockito.when((Object)this.testProfile.getName()).thenReturn((Object)"test-graph");
        Mockito.when((Object)this.testProfile.getDuration((DriverOption)DseDriverOption.GRAPH_TIMEOUT, Duration.ZERO)).thenReturn((Object)Duration.ofMillis(2L));
        Mockito.when((Object)this.testProfile.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).thenReturn((Object)DefaultConsistencyLevel.LOCAL_ONE.name());
        Mockito.when((Object)this.testProfile.getInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE)).thenReturn((Object)5000);
        Mockito.when((Object)this.testProfile.getString((DriverOption)DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY)).thenReturn((Object)DefaultConsistencyLevel.SERIAL.name());
        Mockito.when((Object)this.testProfile.getBoolean((DriverOption)DefaultDriverOption.REQUEST_DEFAULT_IDEMPOTENCE)).thenReturn((Object)false);
        Mockito.when((Object)this.testProfile.getBoolean((DriverOption)DefaultDriverOption.PREPARE_ON_ALL_NODES)).thenReturn((Object)true);
        Mockito.when((Object)this.testProfile.getString((DriverOption)DseDriverOption.GRAPH_TRAVERSAL_SOURCE, null)).thenReturn((Object)"a");
        Mockito.when((Object)this.testProfile.isDefined((DriverOption)DseDriverOption.GRAPH_SUB_PROTOCOL)).thenReturn((Object)(graphProtocolForTestConfig != null ? 1 : 0));
        if (graphProtocolForTestConfig != null) {
            Mockito.when((Object)this.testProfile.getString((DriverOption)DseDriverOption.GRAPH_SUB_PROTOCOL)).thenReturn((Object)graphProtocolForTestConfig.toInternalCode());
        }
        Mockito.when((Object)this.testProfile.getBoolean((DriverOption)DseDriverOption.GRAPH_IS_SYSTEM_QUERY, false)).thenReturn((Object)false);
        Mockito.when((Object)this.testProfile.getString((DriverOption)DseDriverOption.GRAPH_NAME, null)).thenReturn((Object)"mockGraph");
        Mockito.when((Object)this.testProfile.getString((DriverOption)DseDriverOption.GRAPH_READ_CONSISTENCY_LEVEL, null)).thenReturn((Object)"LOCAL_TWO");
        Mockito.when((Object)this.testProfile.getString((DriverOption)DseDriverOption.GRAPH_WRITE_CONSISTENCY_LEVEL, null)).thenReturn((Object)"LOCAL_THREE");
        Mockito.when((Object)this.config.getProfile("test-graph")).thenReturn((Object)this.testProfile);
        Mockito.when((Object)this.systemQueryExecutionProfile.getName()).thenReturn((Object)"graph-system-query");
        Mockito.when((Object)this.systemQueryExecutionProfile.getDuration((DriverOption)DseDriverOption.GRAPH_TIMEOUT, Duration.ZERO)).thenReturn((Object)Duration.ZERO);
        Mockito.when((Object)this.systemQueryExecutionProfile.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).thenReturn((Object)DefaultConsistencyLevel.LOCAL_ONE.name());
        Mockito.when((Object)this.systemQueryExecutionProfile.getInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE)).thenReturn((Object)5000);
        Mockito.when((Object)this.systemQueryExecutionProfile.getString((DriverOption)DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY)).thenReturn((Object)DefaultConsistencyLevel.SERIAL.name());
        Mockito.when((Object)this.systemQueryExecutionProfile.getBoolean((DriverOption)DefaultDriverOption.REQUEST_DEFAULT_IDEMPOTENCE)).thenReturn((Object)false);
        Mockito.when((Object)this.systemQueryExecutionProfile.getBoolean((DriverOption)DefaultDriverOption.PREPARE_ON_ALL_NODES)).thenReturn((Object)true);
        Mockito.when((Object)this.systemQueryExecutionProfile.getName()).thenReturn((Object)"graph-system-query");
        Mockito.when((Object)this.systemQueryExecutionProfile.getDuration((DriverOption)DseDriverOption.GRAPH_TIMEOUT, Duration.ZERO)).thenReturn((Object)Duration.ofMillis(2L));
        Mockito.when((Object)this.systemQueryExecutionProfile.getBoolean((DriverOption)DseDriverOption.GRAPH_IS_SYSTEM_QUERY, false)).thenReturn((Object)true);
        Mockito.when((Object)this.systemQueryExecutionProfile.getString((DriverOption)DseDriverOption.GRAPH_READ_CONSISTENCY_LEVEL, null)).thenReturn((Object)"LOCAL_TWO");
        Mockito.when((Object)this.systemQueryExecutionProfile.getString((DriverOption)DseDriverOption.GRAPH_WRITE_CONSISTENCY_LEVEL, null)).thenReturn((Object)"LOCAL_THREE");
        Mockito.when((Object)this.config.getProfile("graph-system-query")).thenReturn((Object)this.systemQueryExecutionProfile);
        Mockito.when((Object)this.dseDriverContext.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.dseDriverContext.getNettyOptions()).thenReturn((Object)this.nettyOptions);
        Mockito.when((Object)this.dseDriverContext.getLoadBalancingPolicyWrapper()).thenReturn((Object)this.loadBalancingPolicyWrapper);
        Mockito.when((Object)this.dseDriverContext.getRetryPolicy(ArgumentMatchers.anyString())).thenReturn((Object)this.retryPolicy);
        Mockito.when((Object)this.dseDriverContext.getSpeculativeExecutionPolicy(ArgumentMatchers.anyString())).thenReturn((Object)this.speculativeExecutionPolicy);
        Mockito.when((Object)this.dseDriverContext.getCodecRegistry()).thenReturn((Object)CodecRegistry.DEFAULT);
        Mockito.when((Object)this.dseDriverContext.getTimestampGenerator()).thenReturn((Object)this.timestampGenerator);
        Mockito.when((Object)this.dseDriverContext.getProtocolVersion()).thenReturn((Object)DseProtocolVersion.DSE_V2);
        Mockito.when((Object)this.dseDriverContext.getProtocolVersionRegistry()).thenReturn((Object)this.protocolVersionRegistry);
        Mockito.when((Object)this.dseDriverContext.getConsistencyLevelRegistry()).thenReturn((Object)new DefaultConsistencyLevelRegistry());
        Mockito.when((Object)this.dseDriverContext.getWriteTypeRegistry()).thenReturn((Object)new DefaultWriteTypeRegistry());
        Mockito.when((Object)this.dseDriverContext.getRequestThrottler()).thenReturn((Object)new PassThroughRequestThrottler((DriverContext)this.dseDriverContext));
        Mockito.when((Object)this.dseDriverContext.getRequestTracker()).thenReturn((Object)new NoopRequestTracker((DriverContext)this.dseDriverContext));
        if (dseVersionForTestMetadata != null) {
            DseTestFixtures.mockNodesInMetadataWithVersions(this.dseDriverContext, true, dseVersionForTestMetadata);
        }
    }

    public DefaultDriverContext getContext() {
        return this.dseDriverContext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends RequestHandlerTestHarness.Builder {
        private GraphProtocol graphProtocolForTestConfig;
        private Duration graphTimeout = Duration.ZERO;
        private Version dseVersionForTestMetadata;

        public Builder withGraphProtocolForTestConfig(GraphProtocol protocol) {
            this.graphProtocolForTestConfig = protocol;
            return this;
        }

        public Builder withDseVersionInMetadata(Version dseVersion) {
            this.dseVersionForTestMetadata = dseVersion;
            return this;
        }

        public Builder withGraphTimeout(Duration globalTimeout) {
            this.graphTimeout = globalTimeout;
            return this;
        }

        @Override
        public Builder withEmptyPool(Node node) {
            super.withEmptyPool(node);
            return this;
        }

        @Override
        public Builder withWriteFailure(Node node, Throwable cause) {
            super.withWriteFailure(node, cause);
            return this;
        }

        @Override
        public Builder withResponseFailure(Node node, Throwable cause) {
            super.withResponseFailure(node, cause);
            return this;
        }

        @Override
        public Builder withResponse(Node node, Frame response) {
            super.withResponse(node, response);
            return this;
        }

        @Override
        public Builder withDefaultIdempotence(boolean defaultIdempotence) {
            super.withDefaultIdempotence(defaultIdempotence);
            return this;
        }

        @Override
        public Builder withProtocolVersion(ProtocolVersion protocolVersion) {
            super.withProtocolVersion(protocolVersion);
            return this;
        }

        @Override
        public GraphRequestHandlerTestHarness build() {
            return new GraphRequestHandlerTestHarness(this, this.graphProtocolForTestConfig, this.graphTimeout, this.dseVersionForTestMetadata);
        }
    }
}

