/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.GraphExecutionInfo;
import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.dse.driver.internal.core.graph.GraphExecutionInfoConverter;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.servererrors.ServerError;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Strict.class)
public class GraphExecutionInfoConverterTest {
    @Mock
    GraphStatement<?> request;
    @Mock
    Node node;
    private List<Map.Entry<Node, Throwable>> errors;
    private List<String> warnings;
    private ImmutableMap<String, ByteBuffer> payload;

    @Before
    public void setUp() {
        this.errors = Collections.singletonList(new AbstractMap.SimpleEntry<Node, ServerError>(this.node, new ServerError(this.node, "this is a server error")));
        this.warnings = Collections.singletonList("this is a warning");
        this.payload = ImmutableMap.of((Object)"key", (Object)Bytes.fromHexString((String)"0xcafebabe"));
    }

    @Test
    public void should_convert_to_graph_execution_info() {
        ExecutionInfo executionInfo = (ExecutionInfo)Mockito.mock(ExecutionInfo.class);
        Mockito.when((Object)executionInfo.getRequest()).thenReturn(this.request);
        Mockito.when((Object)executionInfo.getCoordinator()).thenReturn((Object)this.node);
        Mockito.when((Object)executionInfo.getSpeculativeExecutionCount()).thenReturn((Object)42);
        Mockito.when((Object)executionInfo.getSuccessfulExecutionIndex()).thenReturn((Object)10);
        Mockito.when((Object)executionInfo.getErrors()).thenReturn(this.errors);
        Mockito.when((Object)executionInfo.getWarnings()).thenReturn(this.warnings);
        Mockito.when((Object)executionInfo.getIncomingPayload()).thenReturn(this.payload);
        GraphExecutionInfo graphExecutionInfo = GraphExecutionInfoConverter.convert((ExecutionInfo)executionInfo);
        Assertions.assertThat((Object)graphExecutionInfo.getStatement()).isSameAs(this.request);
        Assertions.assertThat((Object)graphExecutionInfo.getCoordinator()).isSameAs((Object)this.node);
        Assertions.assertThat((int)graphExecutionInfo.getSpeculativeExecutionCount()).isEqualTo(42);
        Assertions.assertThat((int)graphExecutionInfo.getSuccessfulExecutionIndex()).isEqualTo(10);
        Assertions.assertThat((List)graphExecutionInfo.getErrors()).isEqualTo(this.errors);
        Assertions.assertThat((List)graphExecutionInfo.getWarnings()).isEqualTo(this.warnings);
        Assertions.assertThat((Map)graphExecutionInfo.getIncomingPayload()).isEqualTo(this.payload);
    }

    @Test
    public void should_convert_from_graph_execution_info() {
        GraphExecutionInfo graphExecutionInfo = (GraphExecutionInfo)Mockito.mock(GraphExecutionInfo.class);
        Mockito.when((Object)graphExecutionInfo.getStatement()).thenAnswer(args -> this.request);
        Mockito.when((Object)graphExecutionInfo.getCoordinator()).thenReturn((Object)this.node);
        Mockito.when((Object)graphExecutionInfo.getSpeculativeExecutionCount()).thenReturn((Object)42);
        Mockito.when((Object)graphExecutionInfo.getSuccessfulExecutionIndex()).thenReturn((Object)10);
        Mockito.when((Object)graphExecutionInfo.getErrors()).thenReturn(this.errors);
        Mockito.when((Object)graphExecutionInfo.getWarnings()).thenReturn(this.warnings);
        Mockito.when((Object)graphExecutionInfo.getIncomingPayload()).thenReturn(this.payload);
        ExecutionInfo executionInfo = GraphExecutionInfoConverter.convert((GraphExecutionInfo)graphExecutionInfo);
        Assertions.assertThat((Object)executionInfo.getRequest()).isSameAs(this.request);
        Assertions.assertThatThrownBy(() -> ((ExecutionInfo)executionInfo).getStatement()).isInstanceOf(ClassCastException.class);
        Assertions.assertThat((Object)executionInfo.getCoordinator()).isSameAs((Object)this.node);
        Assertions.assertThat((int)executionInfo.getSpeculativeExecutionCount()).isEqualTo(42);
        Assertions.assertThat((int)executionInfo.getSuccessfulExecutionIndex()).isEqualTo(10);
        Assertions.assertThat((List)executionInfo.getErrors()).isEqualTo(this.errors);
        Assertions.assertThat((List)executionInfo.getWarnings()).isEqualTo(this.warnings);
        Assertions.assertThat((Map)executionInfo.getIncomingPayload()).isEqualTo(this.payload);
        Assertions.assertThat((Comparable)executionInfo.getPagingState()).isNull();
        Assertions.assertThat((boolean)executionInfo.isSchemaInAgreement()).isTrue();
        Assertions.assertThat((CompletionStage)executionInfo.getQueryTraceAsync()).isCompletedExceptionally();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ExecutionInfo)executionInfo).getQueryTrace()).isInstanceOf(IllegalStateException.class)).hasMessage("Tracing was disabled for this request");
        Assertions.assertThat((int)executionInfo.getResponseSizeInBytes()).isEqualTo(-1L);
        Assertions.assertThat((int)executionInfo.getCompressedResponseSizeInBytes()).isEqualTo(-1L);
    }
}

