/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.reactive;

import com.datastax.dse.driver.internal.core.cql.reactive.MockAsyncResultSet;
import com.datastax.dse.driver.internal.core.cql.reactive.ReactiveResultSetSubscription;
import com.datastax.dse.driver.internal.core.cql.reactive.TestSubscriber;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.servererrors.UnavailableException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.reactivestreams.Subscription;

public class ReactiveResultSetSubscriptionTest {
    @Test
    public void should_retrieve_entire_result_set() {
        CompletableFuture<MockAsyncResultSet> future1 = new CompletableFuture<MockAsyncResultSet>();
        CompletableFuture<AsyncResultSet> future2 = new CompletableFuture<AsyncResultSet>();
        CompletableFuture<AsyncResultSet> future3 = new CompletableFuture<AsyncResultSet>();
        MockAsyncResultSet page1 = new MockAsyncResultSet(3, future2);
        MockAsyncResultSet page2 = new MockAsyncResultSet(3, future3);
        MockAsyncResultSet page3 = new MockAsyncResultSet(3, null);
        TestSubscriber mainSubscriber = new TestSubscriber();
        TestSubscriber colDefsSubscriber = new TestSubscriber();
        TestSubscriber execInfosSubscriber = new TestSubscriber();
        TestSubscriber wasAppliedSubscriber = new TestSubscriber();
        ReactiveResultSetSubscription subscription = new ReactiveResultSetSubscription(mainSubscriber, colDefsSubscriber, execInfosSubscriber, wasAppliedSubscriber);
        mainSubscriber.onSubscribe((Subscription)subscription);
        subscription.start(() -> future1);
        future1.complete(page1);
        future2.complete(page2);
        future3.complete(page3);
        mainSubscriber.awaitTermination();
        ArrayList expected = new ArrayList(page1.currentPage());
        expected.addAll(page2.currentPage());
        expected.addAll(page3.currentPage());
        Assertions.assertThat(mainSubscriber.getElements()).extracting("row").isEqualTo(expected);
        ((ListAssert)Assertions.assertThat(colDefsSubscriber.getElements()).hasSize(1)).containsExactly((Object[])new ColumnDefinitions[]{page1.getColumnDefinitions()});
        ((ListAssert)Assertions.assertThat(execInfosSubscriber.getElements()).hasSize(3)).containsExactly((Object[])new ExecutionInfo[]{page1.getExecutionInfo(), page2.getExecutionInfo(), page3.getExecutionInfo()});
        ((ListAssert)Assertions.assertThat(wasAppliedSubscriber.getElements()).hasSize(1)).containsExactly((Object[])new Boolean[]{true});
    }

    @Test
    public void should_report_error_on_first_page() {
        CompletableFuture future1 = new CompletableFuture();
        TestSubscriber mainSubscriber = new TestSubscriber();
        TestSubscriber colDefsSubscriber = new TestSubscriber();
        TestSubscriber execInfosSubscriber = new TestSubscriber();
        TestSubscriber wasAppliedSubscriber = new TestSubscriber();
        ReactiveResultSetSubscription subscription = new ReactiveResultSetSubscription(mainSubscriber, colDefsSubscriber, execInfosSubscriber, wasAppliedSubscriber);
        mainSubscriber.onSubscribe((Subscription)subscription);
        subscription.start(() -> future1);
        future1.completeExceptionally((Throwable)new UnavailableException(null, null, 0, 0));
        mainSubscriber.awaitTermination();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)mainSubscriber.getError()).isNotNull()).isInstanceOf(UnavailableException.class);
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)colDefsSubscriber.getError()).isNotNull()).isInstanceOf(UnavailableException.class);
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)execInfosSubscriber.getError()).isNotNull()).isInstanceOf(UnavailableException.class);
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)wasAppliedSubscriber.getError()).isNotNull()).isInstanceOf(UnavailableException.class);
    }

    @Test
    public void should_report_synchronous_failure_on_first_page() {
        TestSubscriber mainSubscriber = new TestSubscriber();
        TestSubscriber colDefsSubscriber = new TestSubscriber();
        TestSubscriber execInfosSubscriber = new TestSubscriber();
        TestSubscriber wasAppliedSubscriber = new TestSubscriber();
        ReactiveResultSetSubscription subscription = new ReactiveResultSetSubscription(mainSubscriber, colDefsSubscriber, execInfosSubscriber, wasAppliedSubscriber);
        mainSubscriber.onSubscribe((Subscription)subscription);
        subscription.start(() -> {
            throw new IllegalStateException();
        });
        mainSubscriber.awaitTermination();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)mainSubscriber.getError()).isNotNull()).isInstanceOf(IllegalStateException.class);
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)colDefsSubscriber.getError()).isNotNull()).isInstanceOf(IllegalStateException.class);
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)execInfosSubscriber.getError()).isNotNull()).isInstanceOf(IllegalStateException.class);
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)wasAppliedSubscriber.getError()).isNotNull()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void should_report_error_on_intermediary_page() {
        CompletableFuture<MockAsyncResultSet> future1 = new CompletableFuture<MockAsyncResultSet>();
        CompletableFuture<AsyncResultSet> future2 = new CompletableFuture<AsyncResultSet>();
        MockAsyncResultSet page1 = new MockAsyncResultSet(3, future2);
        TestSubscriber mainSubscriber = new TestSubscriber();
        TestSubscriber colDefsSubscriber = new TestSubscriber();
        TestSubscriber execInfosSubscriber = new TestSubscriber();
        TestSubscriber wasAppliedSubscriber = new TestSubscriber();
        ReactiveResultSetSubscription subscription = new ReactiveResultSetSubscription(mainSubscriber, colDefsSubscriber, execInfosSubscriber, wasAppliedSubscriber);
        mainSubscriber.onSubscribe((Subscription)subscription);
        subscription.start(() -> future1);
        future1.complete(page1);
        future2.completeExceptionally((Throwable)new UnavailableException(null, null, 0, 0));
        mainSubscriber.awaitTermination();
        Assertions.assertThat(mainSubscriber.getElements()).extracting("row").isEqualTo((Object)page1.currentPage());
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)mainSubscriber.getError()).isNotNull()).isInstanceOf(UnavailableException.class);
        Assertions.assertThat((Throwable)colDefsSubscriber.getError()).isNull();
        ((ListAssert)Assertions.assertThat(colDefsSubscriber.getElements()).hasSize(1)).containsExactly((Object[])new ColumnDefinitions[]{page1.getColumnDefinitions()});
        ((ListAssert)Assertions.assertThat(execInfosSubscriber.getElements()).hasSize(1)).containsExactly((Object[])new ExecutionInfo[]{page1.getExecutionInfo()});
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)execInfosSubscriber.getError()).isNotNull()).isInstanceOf(UnavailableException.class);
        ((ListAssert)Assertions.assertThat(wasAppliedSubscriber.getElements()).hasSize(1)).containsExactly((Object[])new Boolean[]{true});
        Assertions.assertThat((Throwable)wasAppliedSubscriber.getError()).isNull();
    }

    @Test
    public void should_handle_empty_non_final_pages() {
        CompletableFuture<MockAsyncResultSet> future1 = new CompletableFuture<MockAsyncResultSet>();
        CompletableFuture<AsyncResultSet> future2 = new CompletableFuture<AsyncResultSet>();
        CompletableFuture<AsyncResultSet> future3 = new CompletableFuture<AsyncResultSet>();
        MockAsyncResultSet page1 = new MockAsyncResultSet(10, future2);
        MockAsyncResultSet page2 = new MockAsyncResultSet(0, future3);
        MockAsyncResultSet page3 = new MockAsyncResultSet(10, null);
        TestSubscriber mainSubscriber = new TestSubscriber(1L);
        TestSubscriber colDefsSubscriber = new TestSubscriber();
        TestSubscriber execInfosSubscriber = new TestSubscriber();
        TestSubscriber wasAppliedSubscriber = new TestSubscriber();
        ReactiveResultSetSubscription subscription = new ReactiveResultSetSubscription(mainSubscriber, colDefsSubscriber, execInfosSubscriber, wasAppliedSubscriber);
        mainSubscriber.onSubscribe((Subscription)subscription);
        subscription.start(() -> future1);
        future1.complete(page1);
        future2.complete(page2);
        subscription.request(1L);
        future3.complete(page3);
        subscription.request(Long.MAX_VALUE);
        mainSubscriber.awaitTermination();
        Assertions.assertThat((Throwable)mainSubscriber.getError()).isNull();
        ArrayList expected = new ArrayList(page1.currentPage());
        expected.addAll(page3.currentPage());
        ((ListAssert)Assertions.assertThat(mainSubscriber.getElements()).hasSize(20)).extracting("row").isEqualTo(expected);
    }
}

