/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.reactive;

import com.datastax.dse.driver.internal.core.cql.reactive.MockRow;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.util.Lists;
import org.mockito.Mockito;

public class MockAsyncResultSet
implements AsyncResultSet {
    private final List<Row> rows;
    private final Iterator<Row> iterator;
    private final CompletionStage<AsyncResultSet> nextPage;
    private final ExecutionInfo executionInfo = (ExecutionInfo)Mockito.mock(ExecutionInfo.class);
    private final ColumnDefinitions columnDefinitions = (ColumnDefinitions)Mockito.mock(ColumnDefinitions.class);
    private int remaining;

    public MockAsyncResultSet(int size, CompletionStage<AsyncResultSet> nextPage) {
        this(IntStream.range(0, size).boxed().map(MockRow::new).collect(Collectors.toList()), nextPage);
    }

    public MockAsyncResultSet(List<Row> rows, CompletionStage<AsyncResultSet> nextPage) {
        this.rows = rows;
        this.iterator = rows.iterator();
        this.remaining = rows.size();
        this.nextPage = nextPage;
    }

    public Row one() {
        Row next = this.iterator.next();
        --this.remaining;
        return next;
    }

    public int remaining() {
        return this.remaining;
    }

    @NonNull
    public List<Row> currentPage() {
        return Lists.newArrayList(this.rows);
    }

    public boolean hasMorePages() {
        return this.nextPage != null;
    }

    @NonNull
    public CompletionStage<AsyncResultSet> fetchNextPage() throws IllegalStateException {
        return this.nextPage;
    }

    @NonNull
    public ColumnDefinitions getColumnDefinitions() {
        return this.columnDefinitions;
    }

    @NonNull
    public ExecutionInfo getExecutionInfo() {
        return this.executionInfo;
    }

    public boolean wasApplied() {
        return true;
    }
}

