/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.graph.predicates;

import com.datastax.dse.driver.api.core.graph.predicates.CqlCollection;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class CqlCollectionTest {
    @Test
    public void should_evaluate_contains() {
        P contains = CqlCollection.contains((Object)"foo");
        Assertions.assertThat((boolean)contains.test(new HashSet())).isFalse();
        Assertions.assertThat((boolean)contains.test(new ArrayList())).isFalse();
        Assertions.assertThat((boolean)contains.test((Object)Sets.newHashSet((Object[])new String[]{"foo"}))).isTrue();
        Assertions.assertThat((boolean)contains.test((Object)Lists.newArrayList((Object[])new String[]{"foo"}))).isTrue();
        Assertions.assertThat((boolean)contains.test((Object)Sets.newHashSet((Object[])new String[]{"bar"}))).isFalse();
        Assertions.assertThat((boolean)contains.test((Object)Lists.newArrayList((Object[])new String[]{"bar"}))).isFalse();
        Assertions.assertThatThrownBy(() -> contains.test(null)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> CqlCollection.contains(null).test((Object)Sets.newHashSet((Object[])new Object[]{"foo"}))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void should_evaluate_containsKey() {
        P containsKey = CqlCollection.containsKey((Object)"foo");
        Assertions.assertThat((boolean)containsKey.test(new HashMap())).isFalse();
        Assertions.assertThat((boolean)containsKey.test(new LinkedHashMap())).isFalse();
        Assertions.assertThat((boolean)containsKey.test((Object)ImmutableMap.of((Object)"foo", (Object)"bar"))).isTrue();
        Assertions.assertThat((boolean)containsKey.test((Object)ImmutableMap.of((Object)"bar", (Object)"foo"))).isFalse();
        Assertions.assertThatThrownBy(() -> containsKey.test(null)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> CqlCollection.containsKey(null).test((Object)ImmutableMap.of((Object)"foo", (Object)"bar"))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void should_evaluate_containsValue() {
        P containsValue = CqlCollection.containsValue((Object)"foo");
        Assertions.assertThat((boolean)containsValue.test(new HashMap())).isFalse();
        Assertions.assertThat((boolean)containsValue.test(new LinkedHashMap())).isFalse();
        Assertions.assertThat((boolean)containsValue.test((Object)ImmutableMap.of((Object)"bar", (Object)"foo"))).isTrue();
        Assertions.assertThat((boolean)containsValue.test((Object)ImmutableMap.of((Object)"foo", (Object)"bar"))).isFalse();
        Assertions.assertThatThrownBy(() -> containsValue.test(null)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> CqlCollection.containsValue(null).test((Object)ImmutableMap.of((Object)"foo", (Object)"bar"))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void should_evaluate_entryEq() {
        P entryEq = CqlCollection.entryEq((Object)"foo", (Object)"bar");
        Assertions.assertThat((boolean)entryEq.test(new HashMap())).isFalse();
        Assertions.assertThat((boolean)entryEq.test(new LinkedHashMap())).isFalse();
        Assertions.assertThat((boolean)entryEq.test((Object)ImmutableMap.of((Object)"foo", (Object)"bar"))).isTrue();
        Assertions.assertThat((boolean)entryEq.test((Object)ImmutableMap.of((Object)"bar", (Object)"foo"))).isFalse();
        Assertions.assertThatThrownBy(() -> entryEq.test(null)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> CqlCollection.entryEq(null, (Object)"foo").test((Object)ImmutableMap.of((Object)"foo", (Object)"bar"))).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> CqlCollection.entryEq((Object)"foo", null).test((Object)ImmutableMap.of((Object)"foo", (Object)"bar"))).isInstanceOf(IllegalArgumentException.class);
    }
}

