/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver;

import com.datastax.dse.protocol.internal.response.result.DseRowsMetadata;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import com.datastax.oss.protocol.internal.response.result.DefaultRows;
import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.protocol.internal.response.result.Rows;
import com.datastax.oss.protocol.internal.response.result.RowsMetadata;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.mockito.Mockito;

public class DseTestFixtures {
    public static Rows singleDseRow() {
        DseRowsMetadata metadata = new DseRowsMetadata((List)ImmutableList.of((Object)new ColumnSpec("ks", "table", "message", 0, (RawType)RawType.PRIMITIVES.get(13))), null, new int[0], null, 1, true);
        ArrayDeque<ImmutableList> data = new ArrayDeque<ImmutableList>();
        data.add(ImmutableList.of((Object)Bytes.fromHexString((String)"0x68656C6C6F2C20776F726C64")));
        return new DefaultRows((RowsMetadata)metadata, data);
    }

    public static Rows tenDseRows(int page, boolean last) {
        DseRowsMetadata metadata = new DseRowsMetadata((List)ImmutableList.of((Object)new ColumnSpec("ks", "table", "message", 0, (RawType)RawType.PRIMITIVES.get(13))), last ? null : ByteBuffer.wrap(new byte[]{(byte)page}), new int[0], null, page, last);
        ArrayDeque<ImmutableList> data = new ArrayDeque<ImmutableList>();
        for (int i = 0; i < 10; ++i) {
            data.add(ImmutableList.of((Object)Bytes.fromHexString((String)"0x68656C6C6F2C20776F726C64")));
        }
        return new DefaultRows((RowsMetadata)metadata, data);
    }

    public static DefaultDriverContext mockNodesInMetadataWithVersions(DefaultDriverContext mockContext, boolean treatNullAsMissing, Version ... dseVersions) {
        MetadataManager metadataManager = (MetadataManager)Mockito.mock(MetadataManager.class);
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        HashMap<UUID, Node> nodeMap = new HashMap<UUID, Node>(dseVersions != null ? dseVersions.length : 1);
        if (dseVersions == null) {
            Node node = (Node)Mockito.mock(Node.class);
            HashMap<String, Object> nodeExtras = new HashMap<String, Object>(1);
            if (!treatNullAsMissing) {
                nodeExtras.put("DSE_VERSION", null);
            }
            nodeMap.put(UUID.randomUUID(), node);
            Mockito.when((Object)node.getExtras()).thenReturn(nodeExtras);
        } else {
            for (Version dseVersion : dseVersions) {
                Node node = (Node)Mockito.mock(Node.class);
                HashMap<String, Version> nodeExtras = new HashMap<String, Version>(1);
                if (dseVersion != null || !treatNullAsMissing) {
                    nodeExtras.put("DSE_VERSION", dseVersion);
                }
                nodeMap.put(UUID.randomUUID(), node);
                Mockito.when((Object)node.getExtras()).thenReturn(nodeExtras);
            }
        }
        Mockito.when((Object)metadata.getNodes()).thenReturn(nodeMap);
        Mockito.when((Object)metadataManager.getMetadata()).thenReturn((Object)metadata);
        Mockito.when((Object)mockContext.getMetadataManager()).thenReturn((Object)metadataManager);
        return mockContext;
    }
}

