/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token;

import com.sap.cloud.security.token.AccessToken;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.x509.Certificate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityContext.class);
    private static final ThreadLocal<Token> tokenStorage = new ThreadLocal();
    private static final ThreadLocal<Certificate> certificateStorage = new ThreadLocal();

    private SecurityContext() {
    }

    @Nullable
    public static Certificate getClientCertificate() {
        return certificateStorage.get();
    }

    public static void setClientCertificate(Certificate certificate) {
        LOGGER.info("Sets certificate to SecurityContext (thread-locally). {}", (Object)certificate);
        certificateStorage.set(certificate);
    }

    private static void clearCertificate() {
        Certificate certificate = certificateStorage.get();
        if (certificate != null) {
            LOGGER.debug("Certificate removed from SecurityContext (thread-locally).");
            certificateStorage.remove();
        }
    }

    public static void setToken(Token token) {
        LOGGER.info("Sets token of service {} to SecurityContext (thread-locally).", token != null ? token.getService() : "null");
        tokenStorage.set(token);
    }

    @Nullable
    public static Token getToken() {
        return tokenStorage.get();
    }

    @Nullable
    public static AccessToken getAccessToken() {
        return tokenStorage.get() instanceof AccessToken ? (AccessToken)tokenStorage.get() : null;
    }

    public static void clearToken() {
        Token token = tokenStorage.get();
        if (token != null) {
            LOGGER.debug("Token of service {} removed from SecurityContext (thread-locally).", (Object)token.getService());
            tokenStorage.remove();
        }
    }

    public static void clear() {
        SecurityContext.clearCertificate();
        SecurityContext.clearToken();
    }
}

