/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.kafka.test.junit5;

import com.salesforce.kafka.test.AbstractKafkaTestResource;
import com.salesforce.kafka.test.KafkaCluster;
import com.salesforce.kafka.test.KafkaTestCluster;
import java.util.Collections;
import java.util.Properties;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedKafkaTestResource
extends AbstractKafkaTestResource<SharedKafkaTestResource>
implements BeforeAllCallback,
AfterAllCallback {
    private static final Logger logger = LoggerFactory.getLogger(SharedKafkaTestResource.class);

    public SharedKafkaTestResource() {
    }

    public SharedKafkaTestResource(Properties brokerProperties) {
        super(brokerProperties);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        logger.info("Starting kafka test server");
        this.validateState(false, "Unknown State! Kafka Test Server already exists!");
        this.setKafkaCluster((KafkaCluster)new KafkaTestCluster(this.getNumberOfBrokers(), this.getBrokerProperties(), Collections.singletonList(this.getRegisteredListener())));
        this.getKafkaCluster().start();
    }

    public void afterAll(ExtensionContext context) {
        logger.info("Shutting down kafka test server");
        if (this.getKafkaCluster() == null) {
            return;
        }
        try {
            this.getKafkaCluster().close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setKafkaCluster(null);
    }
}

