/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Supplier;

public class UtilQueue<T> {
    Deque<T> queue;
    private final Supplier<T> supplier;

    UtilQueue(int initialSize, Supplier<T> supplier) {
        this.queue = new ArrayDeque<T>(initialSize);
        this.supplier = supplier;
    }

    public T get() {
        T element = this.queue.poll();
        if (element == null) {
            return this.supplier.get();
        }
        return element;
    }

    public void add(T element) {
        this.queue.add(element);
    }

    public int size() {
        return this.queue.size();
    }

    public void growPool(int numOfObjects) {
        for (int i = 0; i < numOfObjects; ++i) {
            this.queue.add(this.supplier.get());
        }
    }
}

