/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Vector;
import com.refinitiv.eta.codec.VectorEntry;
import com.refinitiv.eta.json.converter.AbstractContainerTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;
import java.util.Iterator;

class JsonVectorConverter
extends AbstractContainerTypeConverter {
    JsonVectorConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{136};
    }

    @Override
    Object getContainerObject() {
        return JsonFactory.createVector();
    }

    @Override
    Object getEntryObject() {
        return JsonFactory.createVectorEntry();
    }

    @Override
    void releaseContainer(Object container) {
        JsonFactory.releaseVector((Vector)container);
    }

    @Override
    void releaseEntry(Object entry) {
        JsonFactory.releaseVectorEntry((VectorEntry)entry);
    }

    @Override
    boolean hasEntries(Object container) {
        return ((Vector)container).encodedEntries() != null && ((Vector)container).encodedEntries().data() != null && ((Vector)container).encodedEntries().length() != 0;
    }

    @Override
    protected int decodeEntry(DecodeIterator decIter, Object entryObj) {
        VectorEntry entry = (VectorEntry)entryObj;
        entry.clear();
        return entry.decode(decIter);
    }

    @Override
    protected boolean writeContent(DecodeIterator decIter, JsonBuffer outBuffer, JsonConverterError error, Object container) {
        Object localSetDb = null;
        boolean comma = false;
        BufferHelper.beginObject(outBuffer, error);
        Vector vector = (Vector)container;
        if (vector.checkHasSetDefs()) {
            localSetDb = this.getLocalSetDb(decIter, vector.containerType(), error);
        }
        if (vector.checkHasSummaryData() && vector.containerType() > 128) {
            if (!this.writeSummaryData(decIter, vector.containerType(), outBuffer, localSetDb, error)) {
                return false;
            }
            comma = true;
        }
        if (vector.checkHasTotalCountHint()) {
            BufferHelper.writeArrayAndColon("CountHint", outBuffer, comma, error);
            BasicPrimitiveConverter.writeLong(vector.totalCountHint(), outBuffer, error);
            comma = true;
        }
        if (vector.checkSupportsSorting()) {
            BufferHelper.writeArrayAndColon("SupportSorting", outBuffer, comma, error);
            BufferHelper.writeArray("true", outBuffer, false, error);
            comma = true;
        }
        if (vector.encodedEntries().length() == 0) {
            return BufferHelper.endObject(outBuffer, error);
        }
        return this.writeEntries(decIter, outBuffer, true, localSetDb, error, comma, container) && BufferHelper.endObject(outBuffer, error);
    }

    @Override
    protected int decodeContainer(DecodeIterator decIter, Object setDb, Object container) {
        Vector vector = (Vector)container;
        vector.clear();
        return vector.decode(decIter);
    }

    @Override
    protected boolean writeEntry(DecodeIterator decIter, JsonBuffer outBuffer, Object localSetDb, JsonConverterError error, Object entryObj, Object container) {
        int containerType;
        Vector vector = (Vector)container;
        VectorEntry vectorEntry = (VectorEntry)entryObj;
        BufferHelper.beginObject(outBuffer, error);
        BufferHelper.writeArrayAndColon("Index", outBuffer, false, error);
        BasicPrimitiveConverter.writeLong(vectorEntry.index(), outBuffer, error);
        BufferHelper.writeArrayAndColon("Action", outBuffer, true, error);
        BufferHelper.writeArray(this.getVectorEntryAction(vectorEntry.action()), outBuffer, true, error);
        if (vectorEntry.checkHasPermData()) {
            BufferHelper.writeArrayAndColon("PermData", outBuffer, true, error);
            if (!this.converter.getPrimitiveHandler(16).encodeJson(vectorEntry.permData(), outBuffer, error)) {
                return false;
            }
        }
        if ((containerType = vector.containerType()) > 128 && vectorEntry.encodedData().length() > 0) {
            BufferHelper.comma(outBuffer, error);
            if (!this.converter.getContainerHandler(containerType).encodeJson(decIter, outBuffer, true, localSetDb, error)) {
                return false;
            }
        }
        return BufferHelper.endObject(outBuffer, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encodeRWF(JsonNode node, String stringKey, EncodeIterator iter, JsonConverterError error) {
        Vector vector = JsonFactory.createVector();
        VectorEntry vectorEntry = JsonFactory.createVectorEntry();
        int ret = 0;
        JsonNode summary = null;
        JsonNode entries = null;
        JsonNode entryData = null;
        int summaryType = 0;
        int containerType = 0;
        vector.clear();
        if (!node.isObject()) {
            error.setError(4, "Expected object type, found " + node.getNodeType().toString());
            return;
        }
        try {
            Iterator it = node.fieldNames();
            block39: while (it.hasNext()) {
                String key = (String)it.next();
                JsonNode currentNode = node.path(key);
                switch (key) {
                    case "Summary": {
                        if (!currentNode.isObject()) {
                            error.setError(4, "Expected object type, found " + currentNode.getNodeType().toString(), "Summary");
                            return;
                        }
                        if (currentNode.size() != 1) {
                            error.setError(4, "Unexpected keys present", "Summary");
                            return;
                        }
                        Iterator curr = currentNode.fieldNames();
                        String containerName = (String)curr.next();
                        summaryType = this.converter.getContainerType(containerName);
                        if (summaryType == 128) {
                            if (!this.converter.catchUnexpectedKeys()) continue block39;
                            error.setError(14, "Unexpected key: " + containerName, "Summary");
                            return;
                        }
                        summary = currentNode.get(containerName);
                        break;
                    }
                    case "SupportSorting": {
                        if (!currentNode.isBoolean()) {
                            error.setError(4, "Expected boolean value, found " + currentNode.getNodeType().toString(), "SupportSorting");
                            return;
                        }
                        if (!currentNode.asBoolean()) break;
                        vector.applySupportsSorting();
                        break;
                    }
                    case "CountHint": {
                        if (!currentNode.isInt()) {
                            error.setError(4, "Expected integer value, found " + currentNode.getNodeType().toString(), "CountHint");
                            return;
                        }
                        vector.applyHasTotalCountHint();
                        vector.totalCountHint(currentNode.asInt());
                        break;
                    }
                    case "Entries": {
                        if (!currentNode.isArray()) {
                            error.setError(4, "Expected array type, found " + currentNode.getNodeType().toString(), "Entries");
                            return;
                        }
                        entries = currentNode;
                        containerType = this.converter.getPayloadType(currentNode);
                        break;
                    }
                    default: {
                        if (!this.converter.catchUnexpectedKeys()) break;
                        error.setError(14, "Unexpected key: " + key, stringKey);
                        return;
                    }
                }
            }
            if (summary != null) {
                this.encodeVectorSummary(iter, vector, summary, summaryType, error);
                if (error.isFailed()) {
                    return;
                }
            }
            if (entries != null) {
                for (int i = 0; i < entries.size(); ++i) {
                    boolean[] foundEntryElements = new boolean[2];
                    vectorEntry.clear();
                    JsonNode curr = entries.get(i);
                    if (!curr.isObject()) {
                        error.setError(4, "Expected object type, found " + curr.getNodeType().toString());
                        return;
                    }
                    entryData = null;
                    Iterator it2 = curr.fieldNames();
                    while (it2.hasNext()) {
                        JsonNode child;
                        String name = (String)it2.next();
                        boolean foundValidToken = this.findValidVectorEntryToken(name, child = curr.get(name), vectorEntry, error, i, foundEntryElements);
                        if (foundValidToken) continue;
                        if (error.isFailed()) {
                            return;
                        }
                        containerType = this.converter.getContainerType(name);
                        if (containerType == 128) {
                            if (!this.converter.catchUnexpectedKeys()) continue;
                            error.setError(14, "Encountered unexpected key in Vector Entry: " + name, "Vector entry[" + i + "]");
                            return;
                        }
                        if (summary != null) {
                            if (containerType != 128 && containerType != summaryType) {
                                error.setError(8, "Failed to encode Vector: entry container type mismatch with Vector container type, found containerType = " + summaryType + " for Summary and containerType = " + containerType + " for VectorEntry", "Vector entry[" + i + "]");
                                return;
                            }
                        } else if (vector.containerType() == 128) {
                            vector.containerType(containerType);
                            ret = vector.encodeInit(iter, 0, 0);
                            if (ret < 0) {
                                error.setError(8, "Failed encoding Vector, code: " + ret, stringKey);
                                return;
                            }
                        } else if (vector.containerType() != containerType) {
                            error.setError(8, "Failed encoding Vector: container types mismatch, found vector.containerType() = " + vector.containerType() + " and VectorEntry containerType = " + containerType, stringKey);
                            return;
                        }
                        entryData = child;
                    }
                    if (!foundEntryElements[0]) {
                        error.setError(12, "Failed encoding VectorEntry, entry action not found", "Vector entry[" + i + "]");
                        return;
                    }
                    if (!foundEntryElements[1]) {
                        error.setError(12, "Failed encoding VectorEntry, entry Index not found", "Vector entry[" + i + "]");
                        return;
                    }
                    if (entryData != null) {
                        ret = vectorEntry.encodeInit(iter, 0);
                        if (ret < 0) {
                            error.setError(8, "Failed encoding VectorEntry, code: " + ret, "Vector entry[" + i + "]");
                            return;
                        }
                        this.converter.getContainerHandler(vector.containerType()).encodeRWF(entryData, this.converter.getDataType(vector.containerType()), iter, error);
                        if (error.isFailed()) {
                            return;
                        }
                        ret = vectorEntry.encodeComplete(iter, true);
                        if (ret >= 0) continue;
                        error.setError(8, "Failed encoding VectorEntry, code: " + ret, "Vector entry[" + i + "]");
                        return;
                    }
                    if (summary == null && vector.containerType() == 128) {
                        vector.containerType(containerType);
                        ret = vector.encodeInit(iter, 0, 0);
                        if (ret < 0) {
                            error.setError(8, "Failed encoding VectorEntry, code: " + ret, "Vector entry[" + i + "]");
                            return;
                        }
                    }
                    if ((ret = vectorEntry.encode(iter)) >= 0) continue;
                    error.setError(8, "Failed encoding VectorEntry, code: " + ret, "Vector entry[" + i + "]");
                    return;
                }
            }
            if (summary == null && vector.containerType() == 128 && (ret = vector.encodeInit(iter, 0, 0)) < 0) {
                error.setError(8, "Failed encoding Vector, code: " + ret, stringKey);
                return;
            }
            ret = vector.encodeComplete(iter, true);
            if (ret < 0) {
                error.setError(8, "Failed encoding Vector, code: " + ret, stringKey);
                return;
            }
            return;
        }
        catch (Exception ex) {
            error.setError(8, "Failed encoding Vector, exception: " + ex.getMessage(), "Vector");
            return;
        }
        finally {
            JsonFactory.releaseVector(vector);
            JsonFactory.releaseVectorEntry(vectorEntry);
        }
    }

    private void encodeVectorSummary(EncodeIterator iter, Vector vector, JsonNode summary, int summaryType, JsonConverterError error) {
        vector.applyHasSummaryData();
        vector.containerType(summaryType);
        int ret = vector.encodeInit(iter, 0, 0);
        if (ret < 0) {
            error.setError(8, "Failed encoding Vector, code: " + ret);
            return;
        }
        this.converter.getContainerHandler(summaryType).encodeRWF(summary, "Summary", iter, error);
        if (error.isFailed()) {
            return;
        }
        ret = vector.encodeSummaryDataComplete(iter, true);
        if (ret < 0) {
            error.setError(8, "Failed encoding Vector, code: " + ret, "Summary");
            return;
        }
    }

    private boolean findValidVectorEntryToken(String name, JsonNode child, VectorEntry vectorEntry, JsonConverterError error, int position, boolean[] foundElements) {
        switch (name) {
            case "Action": {
                if (!child.isTextual()) {
                    error.setError(4, "Expected string type for Vector entry action, found " + child.getNodeType().toString(), "Vector entry[" + position + "]." + name);
                    return false;
                }
                int action = this.getVectorAction(child.asText());
                if (action == -1) {
                    error.setError(4, "Unexpected parameter for for Vector entry action: " + child.get(name).asText(), "Vector entry[" + position + "]." + name);
                    return false;
                }
                vectorEntry.action(action);
                foundElements[0] = true;
                return true;
            }
            case "Index": {
                if (!child.isInt() && !child.isLong()) {
                    error.setError(4, "Expected long type, found " + child.getNodeType().toString(), "Vector entry[" + position + "]." + name);
                    return false;
                }
                vectorEntry.index(child.asLong());
                foundElements[1] = true;
                return true;
            }
            case "PermData": {
                if (!child.isTextual()) {
                    error.setError(4, "Expected string type, found " + child.getNodeType().toString(), "Vector entry[" + position + "]." + name);
                    return false;
                }
                vectorEntry.applyHasPermData();
                this.converter.getPrimitiveHandler(16).decodeJson(child, vectorEntry.permData(), error);
                return !error.isFailed();
            }
        }
        return false;
    }

    private String getVectorEntryAction(int entryAction) {
        if (entryAction >= 1 && entryAction <= 5) {
            return ConstCharArrays.entryActionStrings[entryAction - 1];
        }
        return null;
    }

    private int getVectorAction(String action) {
        switch (action) {
            case "Update": {
                return 1;
            }
            case "Set": {
                return 2;
            }
            case "Insert": {
                return 4;
            }
            case "Delete": {
                return 5;
            }
            case "Clear": {
                return 3;
            }
        }
        return -1;
    }
}

