/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Time;
import com.refinitiv.eta.json.converter.AbstractPrimitiveTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;

class JsonTimeConverter
extends AbstractPrimitiveTypeConverter {
    JsonTimeConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{10, 77, 78, 83, 84};
    }

    @Override
    Object getPrimitiveType() {
        return JsonFactory.createTime();
    }

    @Override
    void releasePrimitiveType(Object type) {
        JsonFactory.releaseTime((Time)type);
    }

    @Override
    int decode(DecodeIterator decIter, Object type) {
        Time time = (Time)type;
        time.clear();
        return time.decode(decIter);
    }

    @Override
    boolean writeToJson(JsonBuffer outBuffer, Object type, JsonConverterError error) {
        return BasicPrimitiveConverter.writeTime((Time)type, outBuffer, error);
    }

    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        Time time = (Time)msg;
        time.clear();
        if (node.isNull()) {
            time.blank();
            return;
        }
        int ret = time.value(node.textValue());
        if (ret < 0) {
            error.setError(4, "Invalid time value: " + node.textValue() + ", code = " + ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encodeRWF(JsonNode dataNode, String key, EncodeIterator iter, JsonConverterError error) {
        if (dataNode.isNull()) {
            return;
        }
        Time time = JsonFactory.createTime();
        try {
            time.clear();
            this.decodeJson(dataNode, time, error);
            int result = time.encode(iter);
            if (result != 0) {
                error.setEncodeError(result, key);
                return;
            }
        }
        finally {
            JsonFactory.releaseTime(time);
        }
    }
}

