/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.json.converter.AbstractPrimitiveTypeConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;
import java.util.Iterator;

class JsonStateConverter
extends AbstractPrimitiveTypeConverter {
    JsonStateConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{13};
    }

    @Override
    Object getPrimitiveType() {
        return JsonFactory.createState();
    }

    @Override
    void releasePrimitiveType(Object type) {
        JsonFactory.releaseState((State)type);
    }

    @Override
    int decode(DecodeIterator decIter, Object type) {
        State state = (State)type;
        state.clear();
        return state.decode(decIter);
    }

    @Override
    boolean writeToJson(JsonBuffer outBuffer, Object type, JsonConverterError error) {
        return this.writeToJson((State)type, outBuffer, error);
    }

    boolean writeToJson(State state, JsonBuffer outBuffer, JsonConverterError error) {
        BufferHelper.beginObject(outBuffer, error);
        BufferHelper.writeArrayAndColon("Stream", outBuffer, false, error);
        BufferHelper.writeArray(JsonStateConverter.getStreamState(state.streamState()), outBuffer, true, error);
        BufferHelper.writeArrayAndColon("Data", outBuffer, true, error);
        BufferHelper.writeArray(JsonStateConverter.getDataState(state.dataState()), outBuffer, true, error);
        if (state.code() > 0) {
            BufferHelper.writeArrayAndColon("Code", outBuffer, true, error);
            BufferHelper.writeArray(JsonStateConverter.getStateCode(state.code()), outBuffer, true, error);
        }
        if (!state.text().isBlank()) {
            BufferHelper.comma(outBuffer, error);
            BufferHelper.writeArrayAndColon("Text", outBuffer, false, error);
            BufferHelper.doubleQuote(outBuffer, error);
            block4: for (int i = state.text().position(); i < state.text().length() + state.text().position(); ++i) {
                switch (state.text().data().get(i)) {
                    case 34: {
                        BufferHelper.writeArray(ConstCharArrays.safeQuote, outBuffer, false, error);
                        continue block4;
                    }
                    case 92: {
                        BufferHelper.writeArray(ConstCharArrays.safeBackslash, outBuffer, false, error);
                        continue block4;
                    }
                    default: {
                        if (state.text().data().get(i) < 32 || state.text().data().get(i) == 127) {
                            BufferHelper.writeCharAsHex0(state.text().data().get(i), outBuffer, error);
                            continue block4;
                        }
                        BufferHelper.writeByte(outBuffer, state.text().data().get(i), error);
                    }
                }
            }
            BufferHelper.doubleQuote(outBuffer, error);
        }
        return BufferHelper.endObject(outBuffer, error);
    }

    private static String getStateCode(int stateCode) {
        if (0 <= stateCode && stateCode <= 16 || 19 <= stateCode && stateCode <= 23 || 26 <= stateCode && stateCode <= 32 || stateCode == 34 || stateCode == 35) {
            return ConstCharArrays.stateCodesString[stateCode];
        }
        return null;
    }

    private static String getDataState(int dataState) {
        if (0 <= dataState && dataState <= 2) {
            return ConstCharArrays.dataStateStrings[dataState];
        }
        return null;
    }

    private static String getStreamState(int streamState) {
        if (0 <= streamState && streamState <= 5) {
            return ConstCharArrays.streamStateStrings[streamState];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        this.checkObject(node, "State", error);
        if (error.isFailed()) {
            return;
        }
        State state = (State)msg;
        Buffer textBuffer = JsonFactory.createBuffer();
        try {
            Iterator it = node.fieldNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                JsonNode currentNode = node.path(key);
                int result = 0;
                switch (key) {
                    case "Code": {
                        result = this.decodeStateCode(currentNode, key, state, error);
                        break;
                    }
                    case "Data": {
                        result = this.decodeDataState(currentNode, key, state, error);
                        break;
                    }
                    case "Stream": {
                        result = this.decodeStreamState(currentNode, key, state, error);
                        break;
                    }
                    case "Text": {
                        textBuffer.data(this.getText(currentNode, key, error));
                        state.text(textBuffer);
                        break;
                    }
                    default: {
                        this.processUnexpectedKey(key, error);
                    }
                }
                if (error.isFailed()) {
                    return;
                }
                if (result == 0) continue;
                error.setError(4, key + "=" + currentNode.asText());
            }
        }
        finally {
            JsonFactory.releaseBuffer(textBuffer);
        }
    }

    private int decodeStreamState(JsonNode currentNode, String key, State state, JsonConverterError error) {
        this.checkStringOrInt(currentNode, key, error);
        if (error.isFailed()) {
            return -1;
        }
        if (currentNode.isTextual()) {
            return state.streamState(ConstCharArrays.JsonStreamState.ofValue(this.getText(currentNode, key, error), error));
        }
        return state.streamState(this.getInt(currentNode, key, error));
    }

    private int decodeDataState(JsonNode currentNode, String key, State state, JsonConverterError error) {
        this.checkStringOrInt(currentNode, key, error);
        if (error.isFailed()) {
            return -1;
        }
        if (currentNode.isTextual()) {
            return state.dataState(ConstCharArrays.JsonDataState.ofValue(this.getText(currentNode, key, error), error));
        }
        return state.dataState(this.getInt(currentNode, key, error));
    }

    private int decodeStateCode(JsonNode currentNode, String key, State state, JsonConverterError error) {
        this.checkStringOrInt(currentNode, key, error);
        if (error.isFailed()) {
            return -1;
        }
        if (currentNode.isTextual()) {
            return state.code(ConstCharArrays.JsonStateCode.ofValue(this.getText(currentNode, key, error), error));
        }
        return state.code(this.getInt(currentNode, key, error));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encodeRWF(JsonNode dataNode, String key, EncodeIterator iter, JsonConverterError error) {
        State encStateValue;
        Buffer encodeTextBuffer;
        block9: {
            block10: {
                if (dataNode.isNull()) {
                    return;
                }
                encodeTextBuffer = null;
                encStateValue = JsonFactory.createState();
                try {
                    int result;
                    encStateValue.clear();
                    if (!dataNode.path("Code").isMissingNode()) {
                        this.decodeStateCode(dataNode.path("Code"), "Code", encStateValue, error);
                    }
                    if (!dataNode.path("Data").isMissingNode()) {
                        this.decodeDataState(dataNode.path("Data"), "Data", encStateValue, error);
                    }
                    if (!dataNode.path("Stream").isMissingNode()) {
                        this.decodeStreamState(dataNode.path("Stream"), "Stream", encStateValue, error);
                    }
                    if (!dataNode.path("Text").isMissingNode()) {
                        encodeTextBuffer = JsonFactory.createBuffer();
                        encodeTextBuffer.data(dataNode.path("Text").textValue());
                        encStateValue.text(encodeTextBuffer);
                    }
                    if ((result = encStateValue.encode(iter)) == 0) break block9;
                    error.setEncodeError(result, key);
                    if (encodeTextBuffer == null) break block10;
                }
                catch (Throwable throwable) {
                    if (encodeTextBuffer != null) {
                        JsonFactory.releaseBuffer(encodeTextBuffer);
                    }
                    JsonFactory.releaseState(encStateValue);
                    throw throwable;
                }
                JsonFactory.releaseBuffer(encodeTextBuffer);
            }
            JsonFactory.releaseState(encStateValue);
            return;
        }
        if (encodeTextBuffer != null) {
            JsonFactory.releaseBuffer(encodeTextBuffer);
        }
        JsonFactory.releaseState(encStateValue);
    }
}

