/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Series;
import com.refinitiv.eta.codec.SeriesEntry;
import com.refinitiv.eta.json.converter.AbstractContainerTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;
import java.util.Iterator;

class JsonSeriesConverter
extends AbstractContainerTypeConverter {
    JsonSeriesConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{138};
    }

    @Override
    Object getContainerObject() {
        return JsonFactory.createSeries();
    }

    @Override
    Object getEntryObject() {
        return JsonFactory.createSeriesEntry();
    }

    @Override
    void releaseContainer(Object container) {
        JsonFactory.releaseSeries((Series)container);
    }

    @Override
    void releaseEntry(Object entry) {
        JsonFactory.releaseSeriesEntry((SeriesEntry)entry);
    }

    @Override
    boolean hasEntries(Object container) {
        return ((Series)container).encodedEntries() != null && ((Series)container).encodedEntries().data() != null && ((Series)container).encodedEntries().length() != 0;
    }

    @Override
    protected int decodeEntry(DecodeIterator decIter, Object entryObj) {
        SeriesEntry seriesEntry = (SeriesEntry)entryObj;
        seriesEntry.clear();
        return seriesEntry.decode(decIter);
    }

    @Override
    protected int decodeContainer(DecodeIterator decIter, Object setDb, Object container) {
        Series series = (Series)container;
        series.clear();
        return series.decode(decIter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean writeContent(DecodeIterator decIter, JsonBuffer outBuffer, JsonConverterError error, Object container) {
        boolean bl;
        block9: {
            Series series;
            boolean comma;
            Object localSetDb;
            block7: {
                boolean bl2;
                block8: {
                    BufferHelper.beginObject(outBuffer, error);
                    localSetDb = null;
                    comma = false;
                    series = (Series)container;
                    try {
                        if (series.checkHasSetDefs()) {
                            localSetDb = this.getLocalSetDb(decIter, series.containerType(), error);
                        }
                        if (series.checkHasSummaryData()) {
                            this.writeSummaryData(decIter, series.containerType(), outBuffer, localSetDb, error);
                            comma = true;
                        }
                        if (series.checkHasTotalCountHint()) {
                            BufferHelper.writeArrayAndColon("CountHint", outBuffer, comma, error);
                            BasicPrimitiveConverter.writeLong(series.totalCountHint(), outBuffer, error);
                            comma = true;
                        }
                        if (series.encodedEntries().length() != 0) break block7;
                        bl2 = BufferHelper.endObject(outBuffer, error);
                        if (localSetDb == null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (localSetDb != null) {
                            this.returnLocalSetDb(series.containerType(), localSetDb);
                        }
                        throw throwable;
                    }
                    this.returnLocalSetDb(series.containerType(), localSetDb);
                }
                return bl2;
            }
            this.writeEntries(decIter, outBuffer, true, localSetDb, error, comma, container);
            BufferHelper.endObject(outBuffer, error);
            bl = true;
            if (localSetDb == null) break block9;
            this.returnLocalSetDb(series.containerType(), localSetDb);
        }
        return bl;
    }

    @Override
    protected boolean writeEntry(DecodeIterator decIter, JsonBuffer outBuffer, Object localSetDb, JsonConverterError error, Object entryObj, Object container) {
        int type = ((Series)container).containerType();
        BufferHelper.beginObject(outBuffer, error);
        this.converter.getContainerHandler(type).encodeJson(decIter, outBuffer, true, localSetDb, error);
        BufferHelper.endObject(outBuffer, error);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encodeRWF(JsonNode node, String stringKey, EncodeIterator iter, JsonConverterError error) {
        Series series = JsonFactory.createSeries();
        SeriesEntry seriesEntry = JsonFactory.createSeriesEntry();
        int summaryType = 0;
        int entryContainerType = 0;
        JsonNode summary = null;
        JsonNode entryData = null;
        JsonNode entries = null;
        int ret = 0;
        series.clear();
        if (!node.isObject()) {
            error.setError(4, "Expected object type, found " + node.getNodeType().toString(), stringKey);
            return;
        }
        try {
            Iterator it = node.fieldNames();
            block33: while (it.hasNext()) {
                String key = (String)it.next();
                JsonNode seriesNode = node.path(key);
                switch (key) {
                    case "Entries": {
                        if (!seriesNode.isArray()) {
                            error.setError(4, "Expected array type, found " + seriesNode.getNodeType(), "Series " + key);
                            return;
                        }
                        entries = seriesNode;
                        break;
                    }
                    case "Summary": {
                        if (!seriesNode.isObject()) {
                            error.setError(4, "Expected object type, found " + seriesNode.getNodeType(), "Series " + key);
                            return;
                        }
                        if (seriesNode.size() != 1) {
                            error.setError(14, "Unexpected keys present", "Series " + key);
                            return;
                        }
                        Iterator curr = seriesNode.fieldNames();
                        String containerName = (String)curr.next();
                        summaryType = this.converter.getContainerType(containerName);
                        if (summaryType == 128) {
                            if (!this.converter.catchUnexpectedKeys()) continue block33;
                            error.setError(14, "Unexpected key: " + containerName);
                            return;
                        }
                        summary = seriesNode.get(containerName);
                        break;
                    }
                    case "CountHint": {
                        if (!seriesNode.isInt()) {
                            error.setError(4, "Expected integer value, found " + seriesNode.getNodeType(), "Series " + key);
                            return;
                        }
                        series.applyHasTotalCountHint();
                        series.totalCountHint(seriesNode.asInt());
                        break;
                    }
                    default: {
                        if (!this.converter.catchUnexpectedKeys()) break;
                        error.setError(14, "Unexpected key: " + key, "Series");
                        return;
                    }
                }
            }
            if (summary != null) {
                this.encodeSeriesSummary(series, summary, summaryType, iter, error);
            }
            if (error.isFailed()) {
                return;
            }
            if (entries != null) {
                for (int i = 0; i < entries.size(); ++i) {
                    JsonNode seriesEntryNode = entries.get(i);
                    if (!seriesEntryNode.isObject()) {
                        error.setError(4, "Expected object type, found " + seriesEntryNode.getNodeType().toString(), "Series.entry[" + i + "]");
                        return;
                    }
                    seriesEntry.clear();
                    if (seriesEntryNode.isEmpty() || seriesEntryNode.isNull()) {
                        ret = seriesEntry.encode(iter);
                        if (ret == 0) continue;
                        error.setError(8, "Failed to encode SeriesEntry entry[" + i + "]");
                        return;
                    }
                    String name = (String)seriesEntryNode.fieldNames().next();
                    entryContainerType = this.converter.getContainerType(name);
                    if (entryContainerType == 128) {
                        if (!this.converter.catchUnexpectedKeys()) continue;
                        error.setError(14, "Unexpected key: " + name, "Series.entry[" + i + "]");
                        return;
                    }
                    if (summary != null) {
                        if (entryContainerType != summaryType) {
                            error.setError(8, "Failed to encode Series: container types mismatch, found " + entryContainerType + " and " + summaryType, "Series.entry[" + i + "]");
                            return;
                        }
                    } else if (series.containerType() == 128) {
                        series.containerType(entryContainerType);
                        ret = series.encodeInit(iter, 0, 0);
                        if (ret < 0) {
                            error.setError(8, "Failed encoding Series, code: " + ret, "Series");
                            return;
                        }
                    } else if (series.containerType() != entryContainerType) {
                        error.setError(8, "Failed encoding Series: container types mismatch", "Series.entry[" + i + "]");
                        return;
                    }
                    if ((entryData = seriesEntryNode.get(name)) != null) {
                        ret = seriesEntry.encodeInit(iter, 0);
                        if (ret < 0) {
                            error.setError(8, "Failed encoding SeriesEntry, code: " + ret, "Series.entry[" + i + "]");
                            return;
                        }
                        this.converter.getContainerHandler(series.containerType()).encodeRWF(entryData, "Series.entry[" + i + "]", iter, error);
                        if (error.isFailed()) {
                            return;
                        }
                        ret = seriesEntry.encodeComplete(iter, true);
                        if (ret >= 0) continue;
                        error.setError(8, "Failed encoding Series entry, code: " + ret, "Series.entry[" + i + "]");
                        return;
                    }
                    ret = seriesEntry.encode(iter);
                    if (ret >= 0) continue;
                    error.setError(8, "Failed encoding Series entry, code: " + ret, "Series.entry[" + i + "]");
                    return;
                }
            }
            if (summary == null && (entries == null || entries.size() == 0) && (ret = series.encodeInit(iter, 0, 0)) < 0) {
                error.setError(8, "Failed encoding Series, code: " + ret, "Series");
                return;
            }
            ret = series.encodeComplete(iter, true);
            if (ret < 0) {
                error.setError(8, "Failed encoding Series, code: " + ret, "Series");
                return;
            }
            return;
        }
        catch (Exception ex) {
            error.setError(8, "Failed encoding Series, exception: " + ex.getMessage(), "Series");
            return;
        }
        finally {
            JsonFactory.releaseSeries(series);
            JsonFactory.releaseSeriesEntry(seriesEntry);
        }
    }

    private void encodeSeriesSummary(Series series, JsonNode summary, int summaryType, EncodeIterator iter, JsonConverterError error) {
        series.applyHasSummaryData();
        series.containerType(summaryType);
        int ret = series.encodeInit(iter, 0, 0);
        if (ret < 0) {
            error.setError(8, "Failed encoding Series, code: " + ret, "Series");
            return;
        }
        this.converter.getContainerHandler(summaryType).encodeRWF(summary, "Summary", iter, error);
        if (error.isFailed()) {
            return;
        }
        ret = series.encodeSummaryDataComplete(iter, true);
        if (ret < 0) {
            error.setError(8, "Failed encoding Series, code: " + ret, "Series");
            return;
        }
    }
}

