/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.Array;
import com.refinitiv.eta.codec.ArrayEntry;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.Codec;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.ElementEntry;
import com.refinitiv.eta.codec.ElementList;
import com.refinitiv.eta.codec.Int;
import com.refinitiv.eta.codec.RequestMsg;
import com.refinitiv.eta.codec.UInt;
import com.refinitiv.eta.json.converter.AbstractRsslMessageTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.BufferConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.converter.JsonQosConverter;
import com.refinitiv.eta.json.converter.RsslMsgChunkType;
import com.refinitiv.eta.json.util.JsonFactory;
import com.refinitiv.eta.rdm.ElementNames;
import java.util.Objects;

class JsonRequestMsgConverter
extends AbstractRsslMessageTypeConverter {
    JsonRequestMsgConverter(JsonAbstractConverter converter) {
        super(converter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        block55: {
            requestMsg = (RequestMsg)msg;
            requestMsg.msgClass(1);
            requestMsg.domainType(6);
            keyInUpdates = true;
            isStreaming = true;
            hasId = false;
            hasKey = false;
            extendedHeaderBuffer = null;
            try {
                it = node.fieldNames();
                while (it.hasNext()) {
                    key = (String)it.next();
                    currentNode = node.path(key);
                    var13_13 = key;
                    var14_14 = -1;
                    switch (var13_13.hashCode()) {
                        case 1434968563: {
                            if (!var13_13.equals("ConfInfoInUpdates")) break;
                            var14_14 = 0;
                            break;
                        }
                        case 2331: {
                            if (!var13_13.equals("ID")) break;
                            var14_14 = 1;
                            break;
                        }
                        case 2622298: {
                            if (!var13_13.equals("Type")) break;
                            var14_14 = 2;
                            break;
                        }
                        case 2052636900: {
                            if (!var13_13.equals("Domain")) break;
                            var14_14 = 3;
                            break;
                        }
                        case 2089762101: {
                            if (!var13_13.equals("ExtHdr")) break;
                            var14_14 = 4;
                            break;
                        }
                        case 56304919: {
                            if (!var13_13.equals("Elements")) break;
                            var14_14 = 5;
                            break;
                        }
                        case 2104126169: {
                            if (!var13_13.equals("Fields")) break;
                            var14_14 = 6;
                            break;
                        }
                        case 440160342: {
                            if (!var13_13.equals("FilterList")) break;
                            var14_14 = 7;
                            break;
                        }
                        case 77116: {
                            if (!var13_13.equals("Map")) break;
                            var14_14 = 8;
                            break;
                        }
                        case -1675388953: {
                            if (!var13_13.equals("Message")) break;
                            var14_14 = 9;
                            break;
                        }
                        case 2318600: {
                            if (!var13_13.equals("Json")) break;
                            var14_14 = 10;
                            break;
                        }
                        case 88055: {
                            if (!var13_13.equals("Xml")) break;
                            var14_14 = 11;
                            break;
                        }
                        case -1926827967: {
                            if (!var13_13.equals("Opaque")) break;
                            var14_14 = 12;
                            break;
                        }
                        case -1821971817: {
                            if (!var13_13.equals("Series")) break;
                            var14_14 = 13;
                            break;
                        }
                        case 75327: {
                            if (!var13_13.equals("Key")) break;
                            var14_14 = 14;
                            break;
                        }
                        case -1249847194: {
                            if (!var13_13.equals("KeyInUpdates")) break;
                            var14_14 = 15;
                            break;
                        }
                        case 2666181: {
                            if (!var13_13.equals("View")) break;
                            var14_14 = 16;
                            break;
                        }
                        case 1688352834: {
                            if (!var13_13.equals("Streaming")) break;
                            var14_14 = 17;
                            break;
                        }
                        case -1544869189: {
                            if (!var13_13.equals("Refresh")) break;
                            var14_14 = 18;
                            break;
                        }
                        case 1350155619: {
                            if (!var13_13.equals("Private")) break;
                            var14_14 = 19;
                            break;
                        }
                        case 76887510: {
                            if (!var13_13.equals("Pause")) break;
                            var14_14 = 20;
                            break;
                        }
                        case -1100816956: {
                            if (!var13_13.equals("Priority")) break;
                            var14_14 = 21;
                            break;
                        }
                        case 81397: {
                            if (!var13_13.equals("Qos")) break;
                            var14_14 = 22;
                            break;
                        }
                        case 756027516: {
                            if (!var13_13.equals("Qualified")) break;
                            var14_14 = 23;
                            break;
                        }
                        case 107802554: {
                            if (!var13_13.equals("WorstQos")) break;
                            var14_14 = 24;
                            break;
                        }
                    }
                    switch (var14_14) {
                        case 0: {
                            if (!this.getBoolean(currentNode, key, error)) break;
                            requestMsg.applyConfInfoInUpdates();
                            break;
                        }
                        case 1: {
                            requestMsg.streamId(this.getInt(currentNode, key, error));
                            hasId = true;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            if (currentNode.isTextual()) {
                                requestMsg.domainType(ConstCharArrays.JsonDomain.ofValue(this.getText(currentNode, key, error), error));
                                break;
                            }
                            requestMsg.domainType(this.getInt(currentNode, key, error));
                            break;
                        }
                        case 4: {
                            requestMsg.applyHasExtendedHdr();
                            extendedHeaderBuffer = JsonFactory.createBuffer();
                            BufferConverter.decodeFromBase64(this.getText(currentNode, key, error), extendedHeaderBuffer, error);
                            if (error.isFailed()) break;
                            requestMsg.extendedHeader(extendedHeaderBuffer);
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: {
                            requestMsg.containerType(this.converter.getContainerDataType(key, currentNode, error));
                            break;
                        }
                        case 14: {
                            this.converter.decodeChunk(RsslMsgChunkType.MSG_KEY_CHUNK, currentNode, (Object)requestMsg, error);
                            hasKey = true;
                            break;
                        }
                        case 15: {
                            keyInUpdates = this.getBoolean(currentNode, key, error);
                            break;
                        }
                        case 16: {
                            requestMsg.applyHasView();
                            requestMsg.containerType(133);
                            break;
                        }
                        case 17: {
                            isStreaming = this.getBoolean(currentNode, key, error);
                            break;
                        }
                        case 18: {
                            if (this.getBoolean(currentNode, key, error)) break;
                            requestMsg.applyNoRefresh();
                            break;
                        }
                        case 19: {
                            if (!this.getBoolean(currentNode, key, error)) break;
                            requestMsg.applyPrivateStream();
                            break;
                        }
                        case 20: {
                            if (!this.getBoolean(currentNode, key, error)) break;
                            requestMsg.applyPause();
                            break;
                        }
                        case 21: {
                            requestMsg.applyHasPriority();
                            this.converter.decodeChunk(RsslMsgChunkType.PRIORITY_CHUNK, currentNode, (Object)requestMsg, error);
                            break;
                        }
                        case 22: {
                            requestMsg.applyHasQos();
                            this.converter.decodeChunk(12, currentNode, (Object)requestMsg.qos(), error);
                            break;
                        }
                        case 23: {
                            if (!this.getBoolean(currentNode, key, error)) break;
                            requestMsg.applyQualifiedStream();
                            break;
                        }
                        case 24: {
                            requestMsg.applyHasWorstQos();
                            this.converter.decodeChunk(12, currentNode, (Object)requestMsg.worstQos(), error);
                            break;
                        }
                        default: {
                            this.processUnexpectedKey(key, error);
                        }
                    }
                    if (!error.isFailed()) continue;
                    if (extendedHeaderBuffer == null) return;
                    break block55;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var15_15) {
                if (extendedHeaderBuffer == null) throw var15_15;
                JsonFactory.releaseBuffer(extendedHeaderBuffer);
                throw var15_15;
            }
        }
        JsonFactory.releaseBuffer(extendedHeaderBuffer);
        return;
lbl-1000:
        // 1 sources

        {
            if (keyInUpdates) {
                requestMsg.applyMsgKeyInUpdates();
            }
            if (isStreaming) {
                requestMsg.applyStreaming();
            }
            if (!hasKey) {
                error.setError(12, "Key");
            }
            if (!hasId) {
                error.setError(12, "ID");
            }
            this.setDeafultDynamicQoS(requestMsg);
            if (extendedHeaderBuffer == null) return;
        }
        JsonFactory.releaseBuffer(extendedHeaderBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean encodeJson(DecodeIterator decIter, Object msg, JsonBuffer outBuffer, JsonConverterError error) {
        boolean comma = false;
        RequestMsg reqMsg = (RequestMsg)msg;
        if (!reqMsg.checkStreaming()) {
            BufferHelper.writeArrayAndColon("Streaming", outBuffer, true, error);
            BufferHelper.writeArray("false", outBuffer, false, error);
        }
        if (reqMsg.flags() != 0) {
            if (reqMsg.checkHasPriority()) {
                BufferHelper.writeArrayAndColon("Priority", outBuffer, true, error);
                BufferHelper.beginObject(outBuffer, error);
                BufferHelper.writeArrayAndColon("Class", outBuffer, false, error);
                BasicPrimitiveConverter.writeLong(reqMsg.priority().priorityClass(), outBuffer, error);
                BufferHelper.writeArrayAndColon("Count", outBuffer, true, error);
                BasicPrimitiveConverter.writeLong(reqMsg.priority().count(), outBuffer, error);
                BufferHelper.endObject(outBuffer, error);
            }
            if (!reqMsg.checkMsgKeyInUpdates()) {
                BufferHelper.writeArrayAndColon("KeyInUpdates", outBuffer, true, error);
                BufferHelper.writeArray("false", outBuffer, false, error);
            }
            if (reqMsg.checkConfInfoInUpdates()) {
                BufferHelper.writeArrayAndColon("ConfInfoInUpdates", outBuffer, true, error);
                BufferHelper.writeArray("true", outBuffer, false, error);
            }
            if (reqMsg.checkNoRefresh()) {
                BufferHelper.writeArrayAndColon("Refresh", outBuffer, true, error);
                BufferHelper.writeArray("false", outBuffer, false, error);
            }
            if (reqMsg.checkHasQos()) {
                BufferHelper.writeArrayAndColon("Qos", outBuffer, true, error);
                if (!((JsonQosConverter)this.converter.getPrimitiveHandler(12)).writeToJson(reqMsg.qos(), outBuffer, error)) {
                    return false;
                }
            }
            if (reqMsg.checkHasWorstQos()) {
                BufferHelper.writeArrayAndColon("WorstQos", outBuffer, true, error);
                if (!((JsonQosConverter)this.converter.getPrimitiveHandler(12)).writeToJson(reqMsg.worstQos(), outBuffer, error)) {
                    return false;
                }
            }
            if (reqMsg.checkPrivateStream()) {
                BufferHelper.writeArrayAndColon("Private", outBuffer, true, error);
                BufferHelper.writeArray("true", outBuffer, false, error);
            }
            if (reqMsg.checkQualifiedStream()) {
                BufferHelper.writeArrayAndColon("Qualified", outBuffer, true, error);
                BufferHelper.writeArray("true", outBuffer, false, error);
            }
            if (reqMsg.checkPause()) {
                BufferHelper.writeArrayAndColon("Pause", outBuffer, true, error);
                BufferHelper.writeArray("true", outBuffer, false, error);
            }
            if (reqMsg.checkHasExtendedHdr()) {
                if (Objects.nonNull(reqMsg.extendedHeader()) && Objects.nonNull(reqMsg.extendedHeader().data())) {
                    BufferHelper.writeArrayAndColon("ExtHdr", outBuffer, true, error);
                    if (!this.converter.getPrimitiveHandler(16).encodeJson(reqMsg.extendedHeader(), outBuffer, error)) {
                        return false;
                    }
                } else {
                    error.setError(4, "Empty extended header found");
                    return false;
                }
            }
        }
        if (!reqMsg.checkHasBatch()) {
            BufferHelper.writeArrayAndColon("Key", outBuffer, true, error);
            if (!this.converter.processMsgKey(decIter, reqMsg.msgKey(), outBuffer, reqMsg.domainType(), true, error)) {
                return false;
            }
            if (!reqMsg.checkHasView()) {
                if (reqMsg.containerType() != 128) {
                    BufferHelper.comma(outBuffer, error);
                    if (!this.converter.getContainerHandler(reqMsg.containerType()).encodeJson(decIter, outBuffer, true, null, error)) {
                        return false;
                    }
                }
                return true;
            }
        }
        if (reqMsg.containerType() != 133 || reqMsg.encodedDataBody().length() == 0) {
            error.setError(4, "Batch/View request: expected nonempty ElementList data body, found: dataType = " + reqMsg.containerType() + ", length: " + reqMsg.encodedDataBody().length());
            return false;
        }
        ElementList elemList = JsonFactory.createElementList();
        ElementEntry elemEntry = JsonFactory.createElementEntry();
        UInt uInt = JsonFactory.createUInt();
        Int iv = JsonFactory.createInt();
        Array array = JsonFactory.createArray();
        ArrayEntry arrayElem = JsonFactory.createArrayEntry();
        DecodeIterator arrayIter = JsonFactory.createDecodeIterator();
        Buffer viewDataBuf = JsonFactory.createBuffer();
        Buffer itemListBuf = JsonFactory.createBuffer();
        Buffer viewTypeBuf = JsonFactory.createBuffer();
        itemListBuf.clear();
        viewDataBuf.clear();
        viewTypeBuf.clear();
        int ret = 0;
        elemList.clear();
        elemEntry.clear();
        try {
            ret = elemList.decode(decIter, null);
            if (ret < 0) {
                error.setError(15, "Failed decoding ElementList, code = " + ret);
                boolean bl = false;
                return bl;
            }
            ret = elemEntry.decode(decIter);
            while (ret != 14) {
                if (ret < 0) {
                    error.setError(15, "Failed decoding ElementEntry, code = " + ret);
                    boolean bl = false;
                    return bl;
                }
                if (ElementNames.VIEW_TYPE.equals(elemEntry.name())) {
                    uInt.decode(decIter);
                    viewTypeBuf.data(elemEntry.encodedData().data(), elemEntry.encodedData().position(), elemEntry.encodedData().length());
                } else if (ElementNames.VIEW_DATA.equals(elemEntry.name())) {
                    viewDataBuf.data(elemEntry.encodedData().data(), elemEntry.encodedData().position(), elemEntry.encodedData().length());
                } else if (ElementNames.BATCH_ITEM_LIST.equals(elemEntry.name())) {
                    itemListBuf.data(elemEntry.encodedData().data(), elemEntry.encodedData().position(), elemEntry.encodedData().length());
                }
                elemEntry.clear();
                ret = elemEntry.decode(decIter);
            }
            if (reqMsg.checkHasBatch()) {
                if (itemListBuf.length() == 0) {
                    error.setError(15, "Failed decoding Request message: batch data missing");
                    boolean bl = false;
                    return bl;
                }
                BufferHelper.writeArrayAndColon("Key", outBuffer, true, error);
                if (!this.converter.processMsgKey(decIter, reqMsg.msgKey(), outBuffer, reqMsg.domainType(), true, error)) {
                    boolean bl = false;
                    return bl;
                }
                --outBuffer.position;
                arrayIter.clear();
                arrayIter.setBufferAndRWFVersion(itemListBuf, Codec.majorVersion(), Codec.minorVersion());
                array.clear();
                ret = array.decode(arrayIter);
                if (ret < 0 || ret == 15 || ret == 16) {
                    error.setError(15, "Expected array data, return code = " + ret);
                    boolean bl = false;
                    return bl;
                }
                if (outBuffer.data[outBuffer.position - 1] != 123) {
                    BufferHelper.comma(outBuffer, error);
                }
                comma = false;
                BufferHelper.writeArrayAndColon("Name", outBuffer, false, error);
                BufferHelper.beginArray(outBuffer, error);
                arrayElem.clear();
                ret = arrayElem.decode(arrayIter);
                arrayIter.setBufferAndRWFVersion(itemListBuf, Codec.majorVersion(), Codec.minorVersion());
                while (ret != 14) {
                    if (ret < 0) {
                        error.setError(15, "Failed to decode array entry, return code = " + ret);
                        boolean bl = false;
                        return bl;
                    }
                    if (comma) {
                        BufferHelper.comma(outBuffer, error);
                    } else {
                        comma = true;
                    }
                    BasicPrimitiveConverter.writeAsciiString(arrayElem.encodedData(), outBuffer, error);
                    arrayElem.clear();
                    ret = arrayElem.decode(arrayIter);
                }
                BufferHelper.endArray(outBuffer, error);
                BufferHelper.endObject(outBuffer, error);
            }
            if (viewDataBuf.length() == 0) {
                boolean bl = true;
                return bl;
            }
            if (viewTypeBuf.length() == 0) {
                if (error.getCode() == 0) {
                    error.setError(15, "Missing view type entry");
                }
                boolean bl = false;
                return bl;
            }
            if (uInt.toLong() == 2L) {
                BufferHelper.writeArrayAndColon("ViewType", outBuffer, true, error);
                BufferHelper.writeArray("NameList", outBuffer, true, error);
            } else if (uInt.toLong() == 1L) {
                BufferHelper.writeArrayAndColon("ViewType", outBuffer, true, error);
                BufferHelper.writeArray("FidList", outBuffer, true, error);
            }
            comma = false;
            BufferHelper.writeArrayAndColon("View", outBuffer, true, error);
            BufferHelper.beginArray(outBuffer, error);
            arrayElem.clear();
            arrayIter.clear();
            arrayIter.setBufferAndRWFVersion(viewDataBuf, Codec.majorVersion(), Codec.minorVersion());
            array.clear();
            ret = array.decode(arrayIter);
            if (ret < 0 || ret == 15 || ret == 16) {
                error.setError(15, "Expected array data, return code = " + ret);
                boolean bl = false;
                return bl;
            }
            ret = arrayElem.decode(arrayIter);
            while (ret != 14) {
                if (ret < 0) {
                    error.setError(15, "Failed to decode array entry, return code = " + ret);
                    boolean bl = false;
                    return bl;
                }
                if (comma) {
                    BufferHelper.comma(outBuffer, error);
                } else {
                    comma = true;
                }
                if (uInt.toLong() == 2L) {
                    BasicPrimitiveConverter.writeAsciiString(arrayElem.encodedData(), outBuffer, error);
                } else {
                    iv.clear();
                    iv.decode(arrayIter);
                    BasicPrimitiveConverter.writeLong(iv.toLong(), outBuffer, error);
                }
                arrayElem.clear();
                ret = arrayElem.decode(arrayIter);
            }
            BufferHelper.endArray(outBuffer, error);
        }
        finally {
            JsonFactory.releaseBuffer(viewDataBuf);
            JsonFactory.releaseBuffer(itemListBuf);
            JsonFactory.releaseBuffer(viewTypeBuf);
            JsonFactory.releaseDecodeIterator(arrayIter);
            JsonFactory.releaseArray(array);
            JsonFactory.releaseArrayEntry(arrayElem);
        }
        return true;
    }
}

