/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.MsgKey;
import com.refinitiv.eta.codec.RefreshMsg;
import com.refinitiv.eta.json.converter.AbstractRsslMessageTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.BufferConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.converter.JsonQosConverter;
import com.refinitiv.eta.json.converter.JsonStateConverter;
import com.refinitiv.eta.json.converter.RsslMsgChunkType;
import com.refinitiv.eta.json.util.JsonFactory;
import java.util.Objects;

class JsonRefreshMsgConverter
extends AbstractRsslMessageTypeConverter {
    JsonRefreshMsgConverter(JsonAbstractConverter converter) {
        super(converter);
    }

    @Override
    boolean encodeJson(DecodeIterator decIter, Object msg, JsonBuffer outBuffer, JsonConverterError error) {
        RefreshMsg refMsg = (RefreshMsg)msg;
        MsgKey key = refMsg.msgKey();
        if (key != null) {
            BufferHelper.writeArrayAndColon("Key", outBuffer, true, error);
            if (!this.converter.processMsgKey(decIter, key, outBuffer, refMsg.domainType(), true, error)) {
                return false;
            }
        }
        BufferHelper.writeArrayAndColon("State", outBuffer, true, error);
        if (!((JsonStateConverter)this.converter.getPrimitiveHandler(13)).writeToJson(refMsg.state(), outBuffer, error)) {
            return false;
        }
        if (refMsg.flags() != 0) {
            if (refMsg.checkHasExtendedHdr()) {
                if (Objects.nonNull(refMsg.extendedHeader()) && Objects.nonNull(refMsg.extendedHeader().data())) {
                    BufferHelper.writeArrayAndColon("ExtHdr", outBuffer, true, error);
                    if (!this.converter.getPrimitiveHandler(16).encodeJson(refMsg.extendedHeader(), outBuffer, error)) {
                        return false;
                    }
                } else {
                    error.setError(4, "Empty extended header found");
                    return false;
                }
            }
            if (!refMsg.checkRefreshComplete()) {
                BufferHelper.writeArrayAndColon("Complete", outBuffer, true, error);
                BufferHelper.writeArray("false", outBuffer, false, error);
            }
            if (refMsg.checkHasQos()) {
                BufferHelper.writeArrayAndColon("Qos", outBuffer, true, error);
                if (!((JsonQosConverter)this.converter.getPrimitiveHandler(12)).writeToJson(refMsg.qos(), outBuffer, error)) {
                    return false;
                }
            }
            if (!refMsg.checkClearCache()) {
                BufferHelper.writeArrayAndColon("ClearCache", outBuffer, true, error);
                BufferHelper.writeArray("false", outBuffer, false, error);
            }
            if (refMsg.checkDoNotCache()) {
                BufferHelper.writeArrayAndColon("DoNotCache", outBuffer, true, error);
                BufferHelper.writeArray("true", outBuffer, false, error);
            }
            if (refMsg.checkPrivateStream()) {
                BufferHelper.writeArrayAndColon("Private", outBuffer, true, error);
                BufferHelper.writeArray("true", outBuffer, false, error);
            }
            if (refMsg.checkQualifiedStream()) {
                BufferHelper.writeArrayAndColon("Qualified", outBuffer, true, error);
                BufferHelper.writeArray("true", outBuffer, false, error);
            }
            if (refMsg.checkHasPostUserInfo()) {
                BufferHelper.writeArrayAndColon("PostUserInfo", outBuffer, true, error);
                if (!this.converter.processPostUserInfo(refMsg.postUserInfo(), outBuffer, error)) {
                    return false;
                }
            }
            if (refMsg.checkHasPartNum()) {
                BufferHelper.writeArrayAndColon("PartNumber", outBuffer, true, error);
                BasicPrimitiveConverter.writeLong(refMsg.partNum(), outBuffer, error);
            }
            if (refMsg.checkHasPermData()) {
                if (Objects.nonNull(refMsg.permData()) && Objects.nonNull(refMsg.permData().data())) {
                    BufferHelper.writeArrayAndColon("PermData", outBuffer, true, error);
                    if (!this.converter.getPrimitiveHandler(16).encodeJson(refMsg.permData(), outBuffer, error)) {
                        return false;
                    }
                } else {
                    error.setError(4, "Empty permission data found");
                    return false;
                }
            }
            if (refMsg.checkHasSeqNum()) {
                BufferHelper.writeArrayAndColon("SeqNumber", outBuffer, true, error);
                BasicPrimitiveConverter.writeLong(refMsg.seqNum(), outBuffer, error);
            }
            if (!refMsg.checkSolicited()) {
                BufferHelper.writeArrayAndColon("Solicited", outBuffer, true, error);
                BufferHelper.writeArray("false", outBuffer, false, error);
            }
        }
        if (refMsg.containerType() != 128) {
            BufferHelper.comma(outBuffer, error);
            if (!this.converter.getContainerHandler(refMsg.containerType()).encodeJson(decIter, outBuffer, true, null, error)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        block63: {
            block61: {
                block62: {
                    refreshMsg = (RefreshMsg)msg;
                    refreshMsg.msgClass(2);
                    refreshMsg.domainType(6);
                    hasId = false;
                    extendedHeaderBuffer = null;
                    permDataBuffer = null;
                    hasState = false;
                    isSolicited = true;
                    isComplete = true;
                    isClearCache = true;
                    try {
                        it = node.fieldNames();
                        while (it.hasNext()) {
                            key = (String)it.next();
                            currentNode = node.path(key);
                            var15_15 = key;
                            var16_16 = -1;
                            switch (var15_15.hashCode()) {
                                case 2331: {
                                    if (!var15_15.equals("ID")) break;
                                    var16_16 = 0;
                                    break;
                                }
                                case 2622298: {
                                    if (!var15_15.equals("Type")) break;
                                    var16_16 = 1;
                                    break;
                                }
                                case 2052636900: {
                                    if (!var15_15.equals("Domain")) break;
                                    var16_16 = 2;
                                    break;
                                }
                                case 56304919: {
                                    if (!var15_15.equals("Elements")) break;
                                    var16_16 = 3;
                                    break;
                                }
                                case 2104126169: {
                                    if (!var15_15.equals("Fields")) break;
                                    var16_16 = 4;
                                    break;
                                }
                                case 440160342: {
                                    if (!var15_15.equals("FilterList")) break;
                                    var16_16 = 5;
                                    break;
                                }
                                case 77116: {
                                    if (!var15_15.equals("Map")) break;
                                    var16_16 = 6;
                                    break;
                                }
                                case -1675388953: {
                                    if (!var15_15.equals("Message")) break;
                                    var16_16 = 7;
                                    break;
                                }
                                case -1736520349: {
                                    if (!var15_15.equals("Vector")) break;
                                    var16_16 = 8;
                                    break;
                                }
                                case 2318600: {
                                    if (!var15_15.equals("Json")) break;
                                    var16_16 = 9;
                                    break;
                                }
                                case 88055: {
                                    if (!var15_15.equals("Xml")) break;
                                    var16_16 = 10;
                                    break;
                                }
                                case -1926827967: {
                                    if (!var15_15.equals("Opaque")) break;
                                    var16_16 = 11;
                                    break;
                                }
                                case -1821971817: {
                                    if (!var15_15.equals("Series")) break;
                                    var16_16 = 12;
                                    break;
                                }
                                case 75327: {
                                    if (!var15_15.equals("Key")) break;
                                    var16_16 = 13;
                                    break;
                                }
                                case 2089762101: {
                                    if (!var15_15.equals("ExtHdr")) break;
                                    var16_16 = 14;
                                    break;
                                }
                                case -694118407: {
                                    if (!var15_15.equals("PostUserInfo")) break;
                                    var16_16 = 15;
                                    break;
                                }
                                case 500974298: {
                                    if (!var15_15.equals("PermData")) break;
                                    var16_16 = 16;
                                    break;
                                }
                                case 1350155619: {
                                    if (!var15_15.equals("Private")) break;
                                    var16_16 = 17;
                                    break;
                                }
                                case 1261962556: {
                                    if (!var15_15.equals("PartNumber")) break;
                                    var16_16 = 18;
                                    break;
                                }
                                case 80204913: {
                                    if (!var15_15.equals("State")) break;
                                    var16_16 = 19;
                                    break;
                                }
                                case -211509144: {
                                    if (!var15_15.equals("SeqNumber")) break;
                                    var16_16 = 20;
                                    break;
                                }
                                case 650435732: {
                                    if (!var15_15.equals("Solicited")) break;
                                    var16_16 = 21;
                                    break;
                                }
                                case -534801063: {
                                    if (!var15_15.equals("Complete")) break;
                                    var16_16 = 22;
                                    break;
                                }
                                case 1234226517: {
                                    if (!var15_15.equals("ClearCache")) break;
                                    var16_16 = 23;
                                    break;
                                }
                                case 81397: {
                                    if (!var15_15.equals("Qos")) break;
                                    var16_16 = 24;
                                    break;
                                }
                                case 756027516: {
                                    if (!var15_15.equals("Qualified")) break;
                                    var16_16 = 25;
                                    break;
                                }
                                case -1850659583: {
                                    if (!var15_15.equals("ReqKey")) break;
                                    var16_16 = 26;
                                    break;
                                }
                            }
                            switch (var16_16) {
                                case 0: {
                                    refreshMsg.streamId(this.getInt(currentNode, key, error));
                                    hasId = true;
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    this.checkStringOrInt(currentNode, key, error);
                                    if (error.isFailed()) break;
                                    if (currentNode.isTextual()) {
                                        refreshMsg.domainType(ConstCharArrays.JsonDomain.ofValue(this.getText(currentNode, key, error), error));
                                        break;
                                    }
                                    refreshMsg.domainType(this.getInt(currentNode, key, error));
                                    break;
                                }
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: {
                                    refreshMsg.containerType(this.converter.getContainerDataType(key, currentNode, error));
                                    break;
                                }
                                case 13: {
                                    refreshMsg.applyHasMsgKey();
                                    this.converter.decodeChunk(RsslMsgChunkType.MSG_KEY_CHUNK, currentNode, (Object)refreshMsg, error);
                                    break;
                                }
                                case 14: {
                                    refreshMsg.applyHasExtendedHdr();
                                    extendedHeaderBuffer = JsonFactory.createBuffer();
                                    BufferConverter.decodeFromBase64(this.getText(currentNode, key, error), extendedHeaderBuffer, error);
                                    if (error.isFailed()) break;
                                    refreshMsg.extendedHeader(extendedHeaderBuffer);
                                    break;
                                }
                                case 15: {
                                    refreshMsg.applyHasPostUserInfo();
                                    this.converter.decodeChunk(RsslMsgChunkType.POST_USER_INFO_CHUNK, currentNode, (Object)refreshMsg.postUserInfo(), error);
                                    break;
                                }
                                case 16: {
                                    refreshMsg.applyHasPermData();
                                    permDataBuffer = JsonFactory.createBuffer();
                                    BufferConverter.decodeFromBase64(this.getText(currentNode, key, error), permDataBuffer, error);
                                    if (error.isFailed()) break;
                                    refreshMsg.permData(permDataBuffer);
                                    break;
                                }
                                case 17: {
                                    if (!this.getBoolean(currentNode, key, error)) break;
                                    refreshMsg.applyPrivateStream();
                                    break;
                                }
                                case 18: {
                                    refreshMsg.applyHasPartNum();
                                    refreshMsg.partNum(this.getInt(currentNode, key, error));
                                    break;
                                }
                                case 19: {
                                    hasState = true;
                                    this.converter.decodeChunk(13, currentNode, (Object)refreshMsg.state(), error);
                                    break;
                                }
                                case 20: {
                                    refreshMsg.applyHasSeqNum();
                                    refreshMsg.seqNum(this.getLong(currentNode, key, error));
                                    break;
                                }
                                case 21: {
                                    isSolicited = this.getBoolean(currentNode, key, error);
                                    break;
                                }
                                case 22: {
                                    isComplete = this.getBoolean(currentNode, key, error);
                                    break;
                                }
                                case 23: {
                                    isClearCache = this.getBoolean(currentNode, key, error);
                                    break;
                                }
                                case 24: {
                                    refreshMsg.applyHasQos();
                                    this.converter.decodeChunk(12, currentNode, (Object)refreshMsg.qos(), error);
                                    break;
                                }
                                case 25: {
                                    if (!this.getBoolean(currentNode, key, error)) break;
                                    refreshMsg.applyQualifiedStream();
                                    break;
                                }
                                case 26: {
                                    break;
                                }
                                default: {
                                    this.processUnexpectedKey(key, error);
                                }
                            }
                            if (!error.isFailed()) continue;
                            if (extendedHeaderBuffer == null) break block61;
                            break block62;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var17_17) {
                        if (extendedHeaderBuffer != null) {
                            JsonFactory.releaseBuffer(extendedHeaderBuffer);
                        }
                        if (permDataBuffer == null) throw var17_17;
                        JsonFactory.releaseBuffer(permDataBuffer);
                        throw var17_17;
                    }
                }
                JsonFactory.releaseBuffer(extendedHeaderBuffer);
            }
            if (permDataBuffer == null) return;
            JsonFactory.releaseBuffer(permDataBuffer);
            return;
lbl-1000:
            // 1 sources

            {
                if (!hasId) {
                    error.setError(12, "ID");
                }
                if (isClearCache) {
                    refreshMsg.applyClearCache();
                }
                if (!hasState) {
                    refreshMsg.state().dataState(1);
                    refreshMsg.state().streamState(1);
                }
                if (isSolicited) {
                    refreshMsg.applySolicited();
                }
                if (isComplete) {
                    refreshMsg.applyRefreshComplete();
                }
                if (isClearCache) {
                    refreshMsg.applyClearCache();
                }
                if (extendedHeaderBuffer == null) break block63;
            }
            JsonFactory.releaseBuffer(extendedHeaderBuffer);
        }
        if (permDataBuffer == null) return;
        JsonFactory.releaseBuffer(permDataBuffer);
    }
}

