/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Real;
import com.refinitiv.eta.json.converter.AbstractPrimitiveTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;

class JsonRealConverter
extends AbstractPrimitiveTypeConverter {
    static int[] _posExponentTable = new int[]{14, 15, 16, 17, 18, 19, 20, 21};
    static int[] _negExponentTable = new int[]{0, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
    static final int POS_EXP_MIN = 0;
    static final int POS_EXP_MAX = 7;
    static final int NEG_EXP_MIN = 1;
    static final int NEG_EXP_MAX = 14;

    JsonRealConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{8, 74, 75};
    }

    @Override
    Object getPrimitiveType() {
        return JsonFactory.createReal();
    }

    @Override
    void releasePrimitiveType(Object type) {
        JsonFactory.releaseReal((Real)type);
    }

    @Override
    int decode(DecodeIterator decIter, Object type) {
        Real real = (Real)type;
        real.clear();
        return real.decode(decIter);
    }

    @Override
    boolean writeToJson(JsonBuffer outBuffer, Object type, JsonConverterError error) {
        return BasicPrimitiveConverter.writeReal((Real)type, outBuffer, false, error);
    }

    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        Real real = (Real)msg;
        real.clear();
        if (node.isNull()) {
            real.blank();
            return;
        }
        int result = 0;
        if (node.isDouble()) {
            result = JsonRealConverter.processReal(node.asText(), real);
        } else if (node.isInt()) {
            result = real.value((long)node.asInt(), 14);
        } else if (node.isLong()) {
            result = real.value(node.asLong(), 14);
        } else if (node.isFloat()) {
            result = JsonRealConverter.processReal(node.asText(), real);
        } else if (node.isTextual()) {
            switch (node.textValue()) {
                case "Inf": {
                    result = real.value(Double.POSITIVE_INFINITY, 1);
                    break;
                }
                case "-Inf": {
                    result = real.value(Double.NEGATIVE_INFINITY, 1);
                    break;
                }
                case "NaN": {
                    result = real.value(Double.NaN, 1);
                    break;
                }
                default: {
                    error.setError(2, "Invalid text '" + node.textValue() + "' expected Real");
                    return;
                }
            }
        }
        if (result != 0) {
            error.setError(4, "Failed to converter the JSON numeric '" + node.asText() + "' value to Real");
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int processReal(String strValue, Real realValue) {
        if (strValue.isEmpty()) {
            realValue.isBlank();
            return 0;
        }
        int decimalIndex = -1;
        int expoIndex = -1;
        int result = 0;
        int expVal = 0;
        int posExp = 0;
        boolean foundNegative = false;
        for (int index = 0; index < strValue.length(); ++index) {
            char ch = strValue.charAt(index);
            if (ch == '-') {
                if (expoIndex != -1) continue;
                foundNegative = true;
                continue;
            }
            if (ch == '.') {
                decimalIndex = index;
                continue;
            }
            if (ch != 'E' && ch != 'e') continue;
            expoIndex = index;
            break;
        }
        try {
            int hint;
            if (expoIndex == -1) return realValue.value(strValue);
            long value = Long.parseLong(strValue.substring(0, decimalIndex));
            if (decimalIndex != -1) {
                long orgValue = value;
                posExp = expoIndex - decimalIndex - 1;
                value *= (long)Math.pow(10.0, posExp);
                if (!foundNegative ? (value += Long.parseLong(strValue.substring(decimalIndex + 1, expoIndex))) < orgValue : (value -= Long.parseLong(strValue.substring(decimalIndex + 1, expoIndex))) > orgValue) {
                    return -1;
                }
            }
            if (strValue.charAt(expoIndex + 1) == '-') {
                expVal = Integer.parseInt(strValue.substring(expoIndex + 2, strValue.length()));
                if ((expVal += posExp) < 1) return -1;
                if (expVal > 14) return -1;
                hint = _negExponentTable[expVal];
                return realValue.value(value, hint);
            } else {
                expVal = Integer.parseInt(strValue.substring(expoIndex + 1, strValue.length()));
                if (decimalIndex != -1 && posExp > expVal) {
                    if ((expVal = posExp - expVal) < 1) return -1;
                    if (expVal > 14) return -1;
                    int hint2 = _negExponentTable[expVal];
                    return realValue.value(value, hint2);
                }
                if ((expVal -= posExp) < 0) return -1;
                if (expVal > 7) return -1;
                hint = _posExponentTable[expVal];
            }
            return realValue.value(value, hint);
        }
        catch (Exception exp) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encodeRWF(JsonNode dataNode, String key, EncodeIterator iter, JsonConverterError error) {
        Real real = JsonFactory.createReal();
        real.clear();
        int result = 0;
        try {
            if (dataNode.isNull()) {
                real.blank();
            } else if (dataNode.isDouble()) {
                result = JsonRealConverter.processReal(dataNode.asText(), real);
            } else if (dataNode.isInt()) {
                result = real.value((long)dataNode.asInt(), 14);
            } else if (dataNode.isLong()) {
                result = real.value(dataNode.asLong(), 14);
            } else if (dataNode.isBigInteger()) {
                result = real.value(dataNode.bigIntegerValue().longValueExact(), 14);
            } else if (dataNode.isFloat()) {
                result = JsonRealConverter.processReal(dataNode.asText(), real);
            } else if (dataNode.isTextual()) {
                switch (dataNode.textValue()) {
                    case "Inf": {
                        result = real.value(Double.POSITIVE_INFINITY, 1);
                        break;
                    }
                    case "-Inf": {
                        result = real.value(Double.NEGATIVE_INFINITY, 1);
                        break;
                    }
                    case "NaN": {
                        result = real.value(Double.NaN, 1);
                        break;
                    }
                    default: {
                        error.setError(2, "Invalid text '" + dataNode.textValue() + "' expected Real");
                        return;
                    }
                }
            }
            if (result != 0) {
                error.setEncodeError(result, key);
                return;
            }
            result = real.encode(iter);
            if (result != 0) {
                error.setEncodeError(result, key);
                return;
            }
        }
        catch (Exception exep) {
            error.setError(4, "Failed to converter the JSON numeric '" + dataNode.asText() + "' value to Real");
            return;
        }
        finally {
            JsonFactory.releaseReal(real);
        }
    }
}

