/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.RequestMsg;
import com.refinitiv.eta.json.converter.AbstractRsslMessageChunkTypeConverter;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonConverterError;
import java.util.Iterator;

class JsonPriorityConverter
extends AbstractRsslMessageChunkTypeConverter {
    JsonPriorityConverter(JsonAbstractConverter converter) {
        super(converter);
    }

    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        this.checkObject(node, "Priority", error);
        if (error.isFailed()) {
            return;
        }
        RequestMsg requestMsg = (RequestMsg)msg;
        boolean hasClass = false;
        boolean hasCount = false;
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            JsonNode currentNode = node.path(key);
            switch (key) {
                case "Class": {
                    requestMsg.priority().priorityClass(this.getInt(currentNode, key, error));
                    hasClass = true;
                    break;
                }
                case "Count": {
                    requestMsg.priority().count(this.getInt(currentNode, key, error));
                    hasCount = true;
                    break;
                }
                default: {
                    this.processUnexpectedKey(key, error);
                }
            }
            if (!error.isFailed()) continue;
            return;
        }
        if (!hasClass) {
            error.setError(12, "Priority.Class");
            return;
        }
        if (!hasCount) {
            error.setError(12, "Priority.Count");
            return;
        }
    }
}

