/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.PostUserInfo;
import com.refinitiv.eta.json.converter.AbstractRsslMessageChunkTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import java.util.Iterator;

class JsonPostUserInfoConverter
extends AbstractRsslMessageChunkTypeConverter {
    JsonPostUserInfoConverter(JsonAbstractConverter converter) {
        super(converter);
    }

    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        this.checkObject(node, "PostUserInfo", error);
        if (error.isFailed()) {
            return;
        }
        boolean hasAddress = false;
        boolean hasUserId = false;
        PostUserInfo postUserInfo = (PostUserInfo)msg;
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            JsonNode currentNode = node.path(key);
            boolean result = false;
            switch (key) {
                case "Address": {
                    if (currentNode.isTextual()) {
                        String userAddr = this.getText(currentNode, key, error);
                        if (error.isFailed()) break;
                        this.checkIpV4Address(userAddr, error);
                        if (error.isFailed()) break;
                        postUserInfo.userAddr(userAddr);
                        hasAddress = true;
                        break;
                    }
                    if (currentNode.isInt()) {
                        postUserInfo.userAddr((long)currentNode.intValue());
                        hasAddress = true;
                        break;
                    }
                    if (currentNode.isLong()) {
                        postUserInfo.userAddr(currentNode.longValue());
                        hasAddress = true;
                        break;
                    }
                    error.setError(3, "token: " + key + " was not expected type:" + currentNode.getNodeType());
                    break;
                }
                case "UserID": {
                    if (currentNode.isTextual()) {
                        postUserInfo.userId(currentNode.asLong());
                        hasUserId = true;
                        break;
                    }
                    if (currentNode.isInt()) {
                        postUserInfo.userId((long)currentNode.intValue());
                        hasUserId = true;
                        break;
                    }
                    if (currentNode.isLong()) {
                        postUserInfo.userId(currentNode.longValue());
                        hasUserId = true;
                        break;
                    }
                    error.setError(3, "token: " + key + " was not expected type:" + currentNode.getNodeType());
                    break;
                }
                default: {
                    this.processUnexpectedKey(key, error);
                }
            }
            if (error.isFailed()) {
                return;
            }
            if (!result) continue;
            error.setError(4, key + "=" + currentNode.asText());
        }
        if (!hasAddress) {
            error.setError(12, "Address");
        }
        if (!hasUserId) {
            error.setError(12, "UserID");
        }
    }

    boolean writeToJson(JsonBuffer outBuffer, Object type, JsonConverterError error) {
        PostUserInfo userInfo = (PostUserInfo)type;
        BufferHelper.beginObject(outBuffer, error);
        BufferHelper.writeArrayAndColon("Address", outBuffer, false, error);
        JsonPostUserInfoConverter.writeUserAddress(userInfo.userAddr(), outBuffer, error);
        BufferHelper.writeArrayAndColon("UserID", outBuffer, true, error);
        BasicPrimitiveConverter.writeLong(userInfo.userId(), outBuffer, error);
        BufferHelper.endObject(outBuffer, error);
        return error.isSuccessful();
    }

    private static boolean writeUserAddress(long addr, JsonBuffer outBuffer, JsonConverterError error) {
        BufferHelper.doubleQuote(outBuffer, error);
        BasicPrimitiveConverter.writeLong(addr >> 24 & 0xFFL, outBuffer, error);
        BufferHelper.writeAsciiChar(outBuffer, '.', error);
        BasicPrimitiveConverter.writeLong(addr >> 16 & 0xFFL, outBuffer, error);
        BufferHelper.writeAsciiChar(outBuffer, '.', error);
        BasicPrimitiveConverter.writeLong(addr >> 8 & 0xFFL, outBuffer, error);
        BufferHelper.writeAsciiChar(outBuffer, '.', error);
        BasicPrimitiveConverter.writeLong(addr & 0xFFL, outBuffer, error);
        BufferHelper.doubleQuote(outBuffer, error);
        return error.isSuccessful();
    }
}

