/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.PostMsg;
import com.refinitiv.eta.json.converter.AbstractRsslMessageTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.BufferConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.converter.RsslMsgChunkType;
import com.refinitiv.eta.json.util.JsonFactory;
import java.util.Objects;

class JsonPostMsgConverter
extends AbstractRsslMessageTypeConverter {
    JsonPostMsgConverter(JsonAbstractConverter converter) {
        super(converter);
    }

    @Override
    boolean encodeJson(DecodeIterator decIter, Object msg, JsonBuffer outBuffer, JsonConverterError error) {
        PostMsg postMsg = (PostMsg)msg;
        boolean res = BufferHelper.writeArrayAndColon("PostUserInfo", outBuffer, true, error);
        if (!this.converter.processPostUserInfo(postMsg.postUserInfo(), outBuffer, error)) {
            return false;
        }
        if (postMsg.flags() != 0) {
            if (postMsg.checkHasPostId()) {
                BufferHelper.writeArrayAndColon("PostID", outBuffer, true, error);
                BasicPrimitiveConverter.writeLong(postMsg.postId(), outBuffer, error);
            }
            if (postMsg.checkHasMsgKey()) {
                BufferHelper.writeArrayAndColon("Key", outBuffer, true, error);
                if (!this.converter.processMsgKey(decIter, postMsg.msgKey(), outBuffer, postMsg.domainType(), true, error)) {
                    return false;
                }
            }
            if (postMsg.checkHasSeqNum()) {
                BufferHelper.writeArrayAndColon("SeqNumber", outBuffer, true, error);
                BasicPrimitiveConverter.writeLong(postMsg.seqNum(), outBuffer, error);
            }
            if (!postMsg.checkPostComplete()) {
                BufferHelper.writeArrayAndColon("Complete", outBuffer, true, error);
                BufferHelper.writeArray("false", outBuffer, false, error);
            }
            if (postMsg.checkAck()) {
                BufferHelper.writeArrayAndColon("Ack", outBuffer, true, error);
                BufferHelper.writeArray("true", outBuffer, false, error);
            }
            if (postMsg.checkHasPermData()) {
                if (Objects.nonNull(postMsg.permData()) && Objects.nonNull(postMsg.permData().data())) {
                    BufferHelper.writeArrayAndColon("PermData", outBuffer, true, error);
                    if (!this.converter.getPrimitiveHandler(16).encodeJson(postMsg.permData(), outBuffer, error)) {
                        return false;
                    }
                } else {
                    error.setError(4, "Empty permission data found");
                    return false;
                }
            }
            if (postMsg.checkHasPartNum()) {
                BufferHelper.writeArrayAndColon("PartNumber", outBuffer, true, error);
                BasicPrimitiveConverter.writeLong(postMsg.partNum(), outBuffer, error);
            }
            if (postMsg.checkHasPostUserRights()) {
                BufferHelper.writeArrayAndColon("PostUserRights", outBuffer, true, error);
                BasicPrimitiveConverter.writeLong(postMsg.postUserRights(), outBuffer, error);
            }
            if (postMsg.checkHasExtendedHdr()) {
                if (Objects.nonNull(postMsg.extendedHeader()) && Objects.nonNull(postMsg.extendedHeader().data())) {
                    BufferHelper.writeArrayAndColon("ExtHdr", outBuffer, true, error);
                    if (!this.converter.getPrimitiveHandler(16).encodeJson(postMsg.extendedHeader(), outBuffer, error)) {
                        return false;
                    }
                } else {
                    error.setError(4, "Empty extended header found");
                    return false;
                }
            }
        }
        if (postMsg.containerType() != 128) {
            BufferHelper.comma(outBuffer, error);
            if (!this.converter.getContainerHandler(postMsg.containerType()).encodeJson(decIter, outBuffer, true, null, error)) {
                return false;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        block53: {
            block51: {
                block52: {
                    ((Msg)msg).msgClass(8);
                    postMsg = (PostMsg)msg;
                    postMsg.domainType(6);
                    hasId = false;
                    extendedHeaderBuffer = null;
                    permDataBuffer = null;
                    isComplete = true;
                    try {
                        it = node.fieldNames();
                        while (it.hasNext()) {
                            key = (String)it.next();
                            currentNode = node.path(key);
                            var12_12 = key;
                            var13_13 = -1;
                            switch (var12_12.hashCode()) {
                                case 2331: {
                                    if (!var12_12.equals("ID")) break;
                                    var13_13 = 0;
                                    break;
                                }
                                case 2622298: {
                                    if (!var12_12.equals("Type")) break;
                                    var13_13 = 1;
                                    break;
                                }
                                case 2052636900: {
                                    if (!var12_12.equals("Domain")) break;
                                    var13_13 = 2;
                                    break;
                                }
                                case 56304919: {
                                    if (!var12_12.equals("Elements")) break;
                                    var13_13 = 3;
                                    break;
                                }
                                case 2104126169: {
                                    if (!var12_12.equals("Fields")) break;
                                    var13_13 = 4;
                                    break;
                                }
                                case 440160342: {
                                    if (!var12_12.equals("FilterList")) break;
                                    var13_13 = 5;
                                    break;
                                }
                                case 77116: {
                                    if (!var12_12.equals("Map")) break;
                                    var13_13 = 6;
                                    break;
                                }
                                case -1675388953: {
                                    if (!var12_12.equals("Message")) break;
                                    var13_13 = 7;
                                    break;
                                }
                                case -1736520349: {
                                    if (!var12_12.equals("Vector")) break;
                                    var13_13 = 8;
                                    break;
                                }
                                case 2318600: {
                                    if (!var12_12.equals("Json")) break;
                                    var13_13 = 9;
                                    break;
                                }
                                case 88055: {
                                    if (!var12_12.equals("Xml")) break;
                                    var13_13 = 10;
                                    break;
                                }
                                case -1926827967: {
                                    if (!var12_12.equals("Opaque")) break;
                                    var13_13 = 11;
                                    break;
                                }
                                case -1821971817: {
                                    if (!var12_12.equals("Series")) break;
                                    var13_13 = 12;
                                    break;
                                }
                                case 75327: {
                                    if (!var12_12.equals("Key")) break;
                                    var13_13 = 13;
                                    break;
                                }
                                case -694118407: {
                                    if (!var12_12.equals("PostUserInfo")) break;
                                    var13_13 = 14;
                                    break;
                                }
                                case -1898584613: {
                                    if (!var12_12.equals("PostID")) break;
                                    var13_13 = 15;
                                    break;
                                }
                                case 1261962556: {
                                    if (!var12_12.equals("PartNumber")) break;
                                    var13_13 = 16;
                                    break;
                                }
                                case -1074786718: {
                                    if (!var12_12.equals("PostUserRights")) break;
                                    var13_13 = 17;
                                    break;
                                }
                                case 500974298: {
                                    if (!var12_12.equals("PermData")) break;
                                    var13_13 = 18;
                                    break;
                                }
                                case -211509144: {
                                    if (!var12_12.equals("SeqNumber")) break;
                                    var13_13 = 19;
                                    break;
                                }
                                case 65641: {
                                    if (!var12_12.equals("Ack")) break;
                                    var13_13 = 20;
                                    break;
                                }
                                case 2089762101: {
                                    if (!var12_12.equals("ExtHdr")) break;
                                    var13_13 = 21;
                                    break;
                                }
                                case -1850659583: {
                                    if (!var12_12.equals("ReqKey")) break;
                                    var13_13 = 22;
                                    break;
                                }
                                case -534801063: {
                                    if (!var12_12.equals("Complete")) break;
                                    var13_13 = 23;
                                    break;
                                }
                            }
                            switch (var13_13) {
                                case 0: {
                                    postMsg.streamId(this.getInt(currentNode, key, error));
                                    hasId = true;
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    this.checkStringOrInt(currentNode, key, error);
                                    if (error.isFailed()) break;
                                    if (currentNode.isTextual()) {
                                        postMsg.domainType(ConstCharArrays.JsonDomain.ofValue(this.getText(currentNode, key, error), error));
                                        break;
                                    }
                                    postMsg.domainType(this.getInt(currentNode, key, error));
                                    break;
                                }
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: {
                                    postMsg.containerType(this.converter.getContainerDataType(key, currentNode, error));
                                    break;
                                }
                                case 13: {
                                    postMsg.applyHasMsgKey();
                                    this.converter.decodeChunk(RsslMsgChunkType.MSG_KEY_CHUNK, currentNode, (Object)postMsg, error);
                                    break;
                                }
                                case 14: {
                                    this.converter.decodeChunk(RsslMsgChunkType.POST_USER_INFO_CHUNK, currentNode, (Object)postMsg.postUserInfo(), error);
                                    break;
                                }
                                case 15: {
                                    postMsg.applyHasPostId();
                                    postMsg.postId(this.getLong(currentNode, key, error));
                                    break;
                                }
                                case 16: {
                                    postMsg.applyHasPartNum();
                                    postMsg.partNum(this.getInt(currentNode, key, error));
                                    break;
                                }
                                case 17: {
                                    postMsg.applyHasPostUserRights();
                                    postMsg.postUserRights(this.getInt(currentNode, key, error));
                                    break;
                                }
                                case 18: {
                                    postMsg.applyHasPermData();
                                    permDataBuffer = JsonFactory.createBuffer();
                                    BufferConverter.decodeFromBase64(this.getText(currentNode, key, error), permDataBuffer, error);
                                    if (error.isFailed()) break;
                                    postMsg.permData(permDataBuffer);
                                    break;
                                }
                                case 19: {
                                    postMsg.applyHasSeqNum();
                                    postMsg.seqNum(this.getLong(currentNode, key, error));
                                    break;
                                }
                                case 20: {
                                    if (!this.getBoolean(currentNode, key, error)) break;
                                    postMsg.applyAck();
                                    break;
                                }
                                case 21: {
                                    postMsg.applyHasExtendedHdr();
                                    extendedHeaderBuffer = JsonFactory.createBuffer();
                                    BufferConverter.decodeFromBase64(this.getText(currentNode, key, error), extendedHeaderBuffer, error);
                                    if (error.isFailed()) break;
                                    postMsg.extendedHeader(extendedHeaderBuffer);
                                    break;
                                }
                                case 22: {
                                    break;
                                }
                                case 23: {
                                    isComplete = this.getBoolean(currentNode, key, error);
                                    break;
                                }
                                default: {
                                    this.processUnexpectedKey(key, error);
                                }
                            }
                            if (!error.isFailed()) continue;
                            if (extendedHeaderBuffer == null) break block51;
                            break block52;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var14_14) {
                        if (extendedHeaderBuffer != null) {
                            JsonFactory.releaseBuffer(extendedHeaderBuffer);
                        }
                        if (permDataBuffer == null) throw var14_14;
                        JsonFactory.releaseBuffer(permDataBuffer);
                        throw var14_14;
                    }
                }
                JsonFactory.releaseBuffer(extendedHeaderBuffer);
            }
            if (permDataBuffer == null) return;
            JsonFactory.releaseBuffer(permDataBuffer);
            return;
lbl-1000:
            // 1 sources

            {
                if (!hasId) {
                    error.setError(12, "ID");
                }
                if (isComplete) {
                    postMsg.applyPostComplete();
                }
                if (extendedHeaderBuffer == null) break block53;
            }
            JsonFactory.releaseBuffer(extendedHeaderBuffer);
        }
        if (permDataBuffer == null) return;
        JsonFactory.releaseBuffer(permDataBuffer);
    }
}

