/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.json.converter.AbstractContainerTypeConverter;
import com.refinitiv.eta.json.converter.BufferConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;

class JsonOpaqueConverter
extends AbstractContainerTypeConverter {
    JsonOpaqueConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{130};
    }

    @Override
    Object getContainerObject() {
        return JsonFactory.createBuffer();
    }

    @Override
    void releaseContainer(Object type) {
        JsonFactory.releaseBuffer((Buffer)type);
    }

    @Override
    protected int decodeEntry(DecodeIterator decIter, Object entryObj) {
        return -1;
    }

    @Override
    protected boolean writeContent(DecodeIterator decIter, JsonBuffer outBuffer, JsonConverterError error, Object container) {
        Buffer buf = (Buffer)container;
        if (buf.length() == 0) {
            return BufferHelper.writeArray("null", outBuffer, false, error);
        }
        return BufferConverter.writeToJson(buf, outBuffer, error);
    }

    @Override
    protected int decodeContainer(DecodeIterator decIter, Object setDb, Object container) {
        Buffer buff = (Buffer)container;
        buff.clear();
        return buff.decode(decIter);
    }

    @Override
    protected boolean writeEntry(DecodeIterator decIterator, JsonBuffer outBuffer, Object localSetDb, JsonConverterError error, Object entryObj, Object container) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encodeRWF(JsonNode node, String key, EncodeIterator iter, JsonConverterError error) {
        if (!node.isTextual()) {
            error.setError(4, "Expected string value.");
            return;
        }
        Buffer opaqueBuf = JsonFactory.createBuffer();
        Buffer dataBuf = JsonFactory.createBuffer();
        try {
            opaqueBuf.clear();
            dataBuf.clear();
            this.converter.getPrimitiveHandler(16).decodeJson(node, opaqueBuf, error);
            if (error.isFailed()) {
                return;
            }
            if (iter.encodeNonRWFInit(dataBuf) < 0) {
                error.setError(17, "Encoding failed");
                return;
            }
            dataBuf.data().put(opaqueBuf.data().array(), opaqueBuf.position(), opaqueBuf.length());
            if (iter.encodeNonRWFComplete(dataBuf, true) < 0) {
                error.setError(17, "Failed to complete Opaque encoding to RWF");
            }
        }
        finally {
            JsonFactory.releaseBuffer(opaqueBuf);
            JsonFactory.releaseBuffer(dataBuf);
        }
    }
}

