/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.json.converter.AbstractContainerTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;

abstract class JsonNonRWFConverter
extends AbstractContainerTypeConverter {
    JsonNonRWFConverter(JsonAbstractConverter converter) {
        super(converter);
    }

    @Override
    Object getContainerObject() {
        return JsonFactory.createBuffer();
    }

    @Override
    void releaseContainer(Object type) {
        JsonFactory.releaseBuffer((Buffer)type);
    }

    @Override
    protected int decodeEntry(DecodeIterator decIter, Object entryObj) {
        return -1;
    }

    @Override
    protected boolean writeContent(DecodeIterator decIter, JsonBuffer outBuffer, JsonConverterError error, Object container) {
        return BasicPrimitiveConverter.writeAsciiString((Buffer)container, outBuffer, error);
    }

    @Override
    protected int decodeContainer(DecodeIterator decIter, Object setDb, Object container) {
        Buffer buff = (Buffer)container;
        buff.clear();
        return buff.decode(decIter);
    }

    @Override
    protected boolean writeEntry(DecodeIterator decIterator, JsonBuffer outBuffer, Object localSetDb, JsonConverterError error, Object entryObj, Object container) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encodeRWF(JsonNode node, String key, EncodeIterator iter, JsonConverterError error) {
        if (!node.isTextual()) {
            error.setError(4, "Expected string value, found type " + node.getNodeType().toString());
            return;
        }
        Buffer xmlBuf = JsonFactory.createBuffer();
        Buffer dataBuf = JsonFactory.createBuffer();
        try {
            xmlBuf.clear();
            dataBuf.clear();
            this.converter.getPrimitiveHandler(17).decodeJson(node, xmlBuf, error);
            if (error.isFailed()) {
                return;
            }
            if (iter.encodeNonRWFInit(dataBuf) < 0) {
                error.setError(17, "Failed to initialize " + this.getContainerName(this.dataTypes[0]) + " encoding");
                return;
            }
            dataBuf.data().put(xmlBuf.data().array(), xmlBuf.position(), xmlBuf.length());
            if (iter.encodeNonRWFComplete(dataBuf, true) < 0) {
                error.setError(17, "Failed to complete " + this.getContainerName(this.dataTypes[0]) + " encoding");
                return;
            }
        }
        finally {
            JsonFactory.releaseBuffer(xmlBuf);
            JsonFactory.releaseBuffer(dataBuf);
        }
    }
}

