/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.json.converter.AbstractContainerTypeConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;

class JsonJsonConverter
extends AbstractContainerTypeConverter {
    JsonJsonConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{142};
    }

    @Override
    Object getContainerObject() {
        return JsonFactory.createBuffer();
    }

    @Override
    void releaseContainer(Object type) {
        JsonFactory.releaseBuffer((Buffer)type);
    }

    @Override
    protected int decodeEntry(DecodeIterator decIter, Object entryObj) {
        return -1;
    }

    @Override
    protected boolean writeContent(DecodeIterator decIter, JsonBuffer outBuffer, JsonConverterError error, Object container) {
        Buffer buf = (Buffer)container;
        if (buf.length() == 0) {
            return BufferHelper.writeArray(ConstCharArrays.nullBytes, outBuffer, false, error);
        }
        try {
            this.converter.getMapper().readTree(buf.data().array(), buf.position(), buf.length());
        }
        catch (Exception e) {
            return false;
        }
        return BufferHelper.copyToByteArray(buf.data().array(), buf.position(), buf.length(), outBuffer, error);
    }

    @Override
    protected int decodeContainer(DecodeIterator decIter, Object setDb, Object container) {
        Buffer buff = (Buffer)container;
        buff.clear();
        return buff.decode(decIter);
    }

    @Override
    protected boolean writeEntry(DecodeIterator decIterator, JsonBuffer outBuffer, Object localSetDb, JsonConverterError error, Object entryObj, Object container) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encodeRWF(JsonNode node, String key, EncodeIterator iter, JsonConverterError error) {
        String json = node.toString();
        Buffer buffer = JsonFactory.createBuffer();
        buffer.clear();
        try {
            iter.encodeNonRWFInit(buffer);
            buffer.data().put(json.getBytes());
            if (iter.encodeNonRWFComplete(buffer, true) < 0) {
                error.setError(17, "Encoding failed.");
                return;
            }
        }
        finally {
            JsonFactory.releaseBuffer(buffer);
        }
    }
}

