/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Int;
import com.refinitiv.eta.json.converter.AbstractPrimitiveTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;

class JsonIntConverter
extends AbstractPrimitiveTypeConverter {
    JsonIntConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{3, 64, 66, 68, 70};
    }

    @Override
    Object getPrimitiveType() {
        return JsonFactory.createInt();
    }

    @Override
    void releasePrimitiveType(Object type) {
        JsonFactory.releaseInt((Int)type);
    }

    @Override
    int decode(DecodeIterator decIter, Object type) {
        Int iv = (Int)type;
        iv.clear();
        return iv.decode(decIter);
    }

    @Override
    boolean writeToJson(JsonBuffer outBuffer, Object type, JsonConverterError error) {
        return BasicPrimitiveConverter.writeLong(((Int)type).toLong(), outBuffer, error);
    }

    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        Int iv = (Int)msg;
        iv.clear();
        if (node.isNull()) {
            return;
        }
        if (node.isInt()) {
            iv.value(node.asInt());
        } else if (node.isLong()) {
            iv.value(node.longValue());
        } else {
            error.setError(4, "expected integer type, found " + node.getNodeType().toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encodeRWF(JsonNode dataNode, String key, EncodeIterator iter, JsonConverterError error) {
        if (dataNode.isNull()) {
            return;
        }
        Int encIntValue = JsonFactory.createInt();
        try {
            encIntValue.clear();
            if (dataNode.isInt()) {
                encIntValue.value(dataNode.asInt());
            } else if (dataNode.isLong()) {
                encIntValue.value(dataNode.longValue());
            } else {
                error.setError(4, "expected integer type, found " + dataNode.getNodeType().toString());
                return;
            }
            int result = encIntValue.encode(iter);
            if (result != 0) {
                error.setEncodeError(result, key);
                return;
            }
        }
        finally {
            JsonFactory.releaseInt(encIntValue);
        }
    }

    @Override
    boolean isInRange(int dataType, JsonNode dataNode) {
        if (dataNode.isBigInteger() || dataNode.isDouble() || dataNode.isFloat()) {
            return false;
        }
        long value = dataNode.asLong();
        switch (dataType) {
            case 3: 
            case 70: {
                if (value < Long.MIN_VALUE || value > Long.MAX_VALUE) break;
                return true;
            }
            case 64: {
                if (value < -128L || value > 127L) break;
                return true;
            }
            case 66: {
                if (value < -32768L || value > 32767L) break;
                return true;
            }
            case 68: {
                if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }
}

