/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.DictionaryEntry;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.FieldEntry;
import com.refinitiv.eta.codec.FieldList;
import com.refinitiv.eta.codec.LocalFieldSetDefDb;
import com.refinitiv.eta.json.converter.AbstractContainerTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.converter.JsonEnumerationConverter;
import com.refinitiv.eta.json.util.JsonFactory;
import java.util.Iterator;

class JsonFieldListConverter
extends AbstractContainerTypeConverter {
    JsonFieldListConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{132};
    }

    @Override
    Object getContainerObject() {
        return JsonFactory.createFieldList();
    }

    @Override
    Object getEntryObject() {
        return JsonFactory.createFieldEntry();
    }

    @Override
    void releaseContainer(Object container) {
        JsonFactory.releaseFieldList((FieldList)container);
    }

    @Override
    void releaseEntry(Object entry) {
        JsonFactory.releaseFieldEntry((FieldEntry)entry);
    }

    @Override
    boolean hasEntries(Object container) {
        return ((FieldList)container).encodedEntries() != null && ((FieldList)container).encodedEntries().data() != null && ((FieldList)container).encodedEntries().length() != 0 || ((FieldList)container).encodedSetData() != null && ((FieldList)container).encodedSetData().data() != null && ((FieldList)container).encodedSetData().length() != 0;
    }

    @Override
    protected int decodeEntry(DecodeIterator decIter, Object entryObj) {
        FieldEntry entry = (FieldEntry)entryObj;
        entry.clear();
        return entry.decode(decIter);
    }

    @Override
    protected int decodeContainer(DecodeIterator decIter, Object setDb, Object container) {
        FieldList list = (FieldList)container;
        list.clear();
        return list.decode(decIter, (LocalFieldSetDefDb)setDb);
    }

    @Override
    protected boolean writeContent(DecodeIterator decIter, JsonBuffer outBuffer, JsonConverterError error, Object container) {
        BufferHelper.beginObject(outBuffer, error);
        this.writeEntries(decIter, outBuffer, false, null, error, false, container);
        BufferHelper.endObject(outBuffer, error);
        return error.isSuccessful();
    }

    @Override
    protected boolean writeEntry(DecodeIterator decIter, JsonBuffer outBuffer, Object localSetDb, JsonConverterError error, Object entryObj, Object container) {
        FieldEntry fieldEntry = (FieldEntry)entryObj;
        DictionaryEntry def = this.converter.getDictionary().entry(fieldEntry.fieldId());
        if (def != null) {
            BasicPrimitiveConverter.writeAsciiString(def.acronym(), outBuffer, error);
            BufferHelper.colon(outBuffer, error);
            if (def.rwfType() < 127) {
                if (def.rwfType() != 14 || !this.converter.expandEnumFields()) {
                    this.converter.getPrimitiveHandler(def.rwfType()).encodeJson(decIter, outBuffer, error);
                } else {
                    ((JsonEnumerationConverter)this.converter.getPrimitiveHandler(14)).encodeJson(decIter, def, outBuffer, error);
                }
            } else {
                this.converter.getContainerHandler(def.rwfType()).encodeJson(decIter, outBuffer, false, localSetDb, error);
            }
        } else {
            error.setError(15, "encountered unexpected fid = " + fieldEntry.fieldId() + " while writing FieldEntry");
            return false;
        }
        return error.isSuccessful();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encodeRWF(JsonNode node, String stringKey, EncodeIterator iter, JsonConverterError error) {
        int ret = 0;
        if (!node.isObject()) {
            error.setError(4, "Encountered unexpected type while decoding FieldList: " + node.getNodeType().toString(), stringKey);
            return;
        }
        FieldList fieldList = JsonFactory.createFieldList();
        FieldEntry fieldEntry = JsonFactory.createFieldEntry();
        try {
            fieldList.clear();
            fieldList.applyHasStandardData();
            ret = fieldList.encodeInit(iter, null, 0);
            if (ret < 0) {
                error.setError(8, "Failed encoding FieldList, code: " + ret, stringKey);
                return;
            }
            if (this.converter.getDictionary() == null) {
                error.setError(16, "Dictionary not initialized");
                return;
            }
            Iterator it = node.fieldNames();
            while (it.hasNext()) {
                DictionaryEntry def;
                fieldEntry.clear();
                String key = (String)it.next();
                JsonNode currentNode = node.path(key);
                boolean isNumber = true;
                for (int i = 0; i < key.length(); ++i) {
                    switch (key.charAt(i)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': {
                            break;
                        }
                        case '-': {
                            if (i == 0) break;
                            isNumber = false;
                            break;
                        }
                        default: {
                            isNumber = false;
                        }
                    }
                    if (!isNumber) break;
                }
                if (isNumber) {
                    int num = Integer.valueOf(key);
                    fieldEntry.fieldId(num);
                    def = this.converter.getDictionary().entry(num);
                } else {
                    def = this.converter.getDictionary().entry(key);
                    if (def != null) {
                        fieldEntry.fieldId(def.fid());
                    }
                }
                if (def == null && this.converter.catchUnexpectedFids()) {
                    error.setError(15, "encountered unexpected fid = " + key + " while decoding FieldEntry");
                    return;
                }
                this.converter.dictionaryEntry(null);
                if (def == null) continue;
                fieldEntry.dataType(def.rwfType());
                this.converter.dictionaryEntry(def);
                ret = fieldEntry.encodeInit(iter, 0);
                if (ret < 0) {
                    error.setError(8, "Failed encoding FieldEntry, code: " + ret, key);
                    return;
                }
                this.converter.decodeChunk(fieldEntry.dataType(), currentNode, key, iter, error);
                if (error.isFailed()) {
                    return;
                }
                ret = fieldEntry.encodeComplete(iter, true);
                if (ret >= 0) continue;
                error.setError(8, "Failed encoding FieldEntry, code: " + ret, key);
                return;
            }
            ret = fieldList.encodeComplete(iter, true);
            if (ret < 0) {
                error.setError(8, "Failed encoding FieldList, code: " + ret, stringKey);
                return;
            }
            return;
        }
        finally {
            JsonFactory.releaseFieldEntry(fieldEntry);
            JsonFactory.releaseFieldList(fieldList);
        }
    }
}

