/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.ElementEntry;
import com.refinitiv.eta.codec.ElementList;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.LocalElementSetDefDb;
import com.refinitiv.eta.json.converter.AbstractContainerTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;
import java.util.Iterator;

class JsonElementListConverter
extends AbstractContainerTypeConverter {
    JsonElementListConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{133};
    }

    @Override
    Object getContainerObject() {
        return JsonFactory.createElementList();
    }

    @Override
    Object getEntryObject() {
        return JsonFactory.createElementEntry();
    }

    @Override
    void releaseContainer(Object container) {
        JsonFactory.releaseElementList((ElementList)container);
    }

    @Override
    void releaseEntry(Object entry) {
        JsonFactory.releaseElementEntry((ElementEntry)entry);
    }

    @Override
    boolean hasEntries(Object container) {
        return ((ElementList)container).encodedEntries() != null && ((ElementList)container).encodedEntries().length() != 0 || ((ElementList)container).encodedSetData() != null && ((ElementList)container).encodedSetData().length() != 0;
    }

    @Override
    protected int decodeEntry(DecodeIterator decIter, Object entryObj) {
        ElementEntry entry = (ElementEntry)entryObj;
        entry.clear();
        return entry.decode(decIter);
    }

    @Override
    protected boolean writeContent(DecodeIterator decIter, JsonBuffer outBuffer, JsonConverterError error, Object container) {
        return BufferHelper.beginObject(outBuffer, error) && this.writeEntries(decIter, outBuffer, false, null, error, false, container) && BufferHelper.endObject(outBuffer, error);
    }

    @Override
    protected int decodeContainer(DecodeIterator decIter, Object setDb, Object container) {
        ElementList list = (ElementList)container;
        list.clear();
        return list.decode(decIter, (LocalElementSetDefDb)setDb);
    }

    @Override
    protected boolean writeEntry(DecodeIterator decIter, JsonBuffer outBuffer, Object localSetDb, JsonConverterError error, Object entryObj, Object container) {
        ElementEntry elEntry = (ElementEntry)entryObj;
        if ((elEntry.dataType() == 17 || elEntry.dataType() == 4) && elEntry.encodedData().length() > 0) {
            BasicPrimitiveConverter.writeAsciiString(elEntry.name(), outBuffer, error);
            BufferHelper.colon(outBuffer, error);
            this.converter.getPrimitiveHandler(elEntry.dataType()).encodeJson(decIter, outBuffer, error);
        } else {
            int type = elEntry.dataType();
            BasicPrimitiveConverter.writeAsciiString(elEntry.name(), outBuffer, error);
            BufferHelper.colon(outBuffer, error);
            BufferHelper.beginObject(outBuffer, error);
            BufferHelper.writeArrayAndColon("Type", outBuffer, false, error);
            BufferHelper.writeArray(this.converter.getDataType(elEntry.dataType()), outBuffer, true, error);
            BufferHelper.writeArrayAndColon("Data", outBuffer, true, error);
            if (elEntry.dataType() < 127) {
                this.converter.getPrimitiveHandler(elEntry.dataType()).encodeJson(decIter, outBuffer, error);
            } else if (elEntry.dataType() > 128) {
                this.converter.getContainerHandler(type).encodeJson(decIter, outBuffer, false, localSetDb, error);
            }
            BufferHelper.endObject(outBuffer, error);
        }
        return error.isSuccessful();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encodeRWF(JsonNode node, String stringKey, EncodeIterator iter, JsonConverterError error) {
        ElementList elementList = JsonFactory.createElementList();
        ElementEntry elementEntry = JsonFactory.createElementEntry();
        Buffer name = JsonFactory.createBuffer();
        if (node.getNodeType() != JsonNodeType.OBJECT) {
            error.setError(4, "Expected object type, found " + node.getNodeType().toString());
            return;
        }
        try {
            elementList.clear();
            elementList.applyHasStandardData();
            int ret = elementList.encodeInit(iter, null, 0);
            if (ret < 0) {
                error.setError(8, "Failed encoding ElementList, code: " + ret);
                return;
            }
            Iterator iterator = node.fieldNames();
            while (iterator.hasNext()) {
                String next = (String)iterator.next();
                JsonNode currEntryElem = node.get(next);
                elementEntry.clear();
                name.clear();
                name.data(next);
                elementEntry.name(name);
                JsonNode data = null;
                if (currEntryElem.isTextual() || currEntryElem.isLong() || currEntryElem.isInt()) {
                    elementEntry.dataType(currEntryElem.isTextual() ? 17 : 4);
                    data = currEntryElem;
                    if (error.isFailed()) {
                        return;
                    }
                } else if (currEntryElem.isObject()) {
                    JsonNode type = currEntryElem.path("Type");
                    data = currEntryElem.path("Data");
                    if (type.isMissingNode()) {
                        error.setError(12, "Missing key Type in ElementEntry", next);
                        return;
                    }
                    if (data.isMissingNode()) {
                        error.setError(12, "Missing key Data in ElementEntry", next);
                        return;
                    }
                    int dataType = this.converter.getDataType(type);
                    if (dataType == -1) {
                        error.setError(11, "Unsupported data type: " + type.asText(), next);
                        return;
                    }
                    elementEntry.dataType(dataType);
                } else {
                    error.setError(4, "Unexpected token in ElementEntry, found " + currEntryElem.getNodeType() + " type", next);
                    return;
                }
                if ((ret = elementEntry.encodeInit(iter, 0)) < 0) {
                    error.setError(8, "Failed encoding ElementEntry, code: " + ret, next);
                    return;
                }
                this.converter.decodeChunk(elementEntry.dataType(), data, next, iter, error);
                if (error.isFailed()) {
                    return;
                }
                ret = elementEntry.encodeComplete(iter, true);
                if (ret >= 0) continue;
                error.setError(8, "Failed encoding ElementEntry, code: " + ret, next);
                return;
            }
            ret = elementList.encodeComplete(iter, true);
            if (ret < 0) {
                error.setError(8, "Failed encoding ElementEntry, code: " + ret, stringKey);
                return;
            }
            return;
        }
        finally {
            JsonFactory.releaseElementEntry(elementEntry);
            JsonFactory.releaseElementList(elementList);
            JsonFactory.releaseBuffer(name);
        }
    }
}

