/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.DateTime;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.json.converter.AbstractPrimitiveTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;

class JsonDateTimeConverter
extends AbstractPrimitiveTypeConverter {
    JsonDateTimeConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{11, 79, 80, 81, 82};
    }

    @Override
    Object getPrimitiveType() {
        return JsonFactory.createDateTime();
    }

    @Override
    void releasePrimitiveType(Object type) {
        JsonFactory.releaseDateTime((DateTime)type);
    }

    @Override
    int decode(DecodeIterator decIter, Object type) {
        DateTime dt = (DateTime)type;
        dt.clear();
        return dt.decode(decIter);
    }

    @Override
    boolean writeToJson(JsonBuffer outBuffer, Object type, JsonConverterError error) {
        return BasicPrimitiveConverter.writeDateTime((DateTime)type, outBuffer, error);
    }

    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        DateTime dateTime = (DateTime)msg;
        dateTime.clear();
        if (node.isNull()) {
            dateTime.blank();
        } else {
            int ret = dateTime.value(node.textValue());
            if (ret < 0) {
                error.setError(4, "Invalid DateTime value: " + node.textValue() + ", code = " + ret);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encodeRWF(JsonNode dataNode, String key, EncodeIterator iter, JsonConverterError error) {
        if (dataNode.isNull()) {
            return;
        }
        DateTime dateTime = JsonFactory.createDateTime();
        try {
            this.decodeJson(dataNode, dateTime, error);
            int result = dateTime.encode(iter);
            if (result != 0) {
                error.setEncodeError(result, key);
                return;
            }
        }
        finally {
            JsonFactory.releaseDateTime(dateTime);
        }
    }
}

