/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.refinitiv.eta.codec.DataDictionary;
import com.refinitiv.eta.json.converter.JsonConverter;
import com.refinitiv.eta.json.converter.JsonConverterBaseImpl;
import com.refinitiv.eta.json.converter.JsonConverterBuilder;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.converter.ServiceNameIdConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class JsonConverterBuilderImpl
implements JsonConverterBuilder {
    private Map<Integer, Object> propertiesMap = new HashMap<Integer, Object>();
    private ServiceNameIdConverter serviceNameIdConverter;
    private DataDictionary dataDictionary;

    JsonConverterBuilderImpl() {
    }

    @Override
    public JsonConverterBuilder setProperties(Map<Integer, Object> properties) {
        this.propertiesMap.putAll(properties);
        return this;
    }

    @Override
    public JsonConverterBuilder setProperty(int propertyId, boolean enabled) {
        this.propertiesMap.put(propertyId, enabled);
        return this;
    }

    @Override
    public JsonConverterBuilder setProperty(int propertyId, int intValue) {
        this.propertiesMap.put(propertyId, intValue);
        return this;
    }

    @Override
    public JsonConverterBuilder setServiceConverter(ServiceNameIdConverter serviceNameIdConverter) {
        this.serviceNameIdConverter = serviceNameIdConverter;
        return this;
    }

    @Override
    public JsonConverterBuilder setDictionary(DataDictionary dataDictionary) {
        this.dataDictionary = dataDictionary;
        return this;
    }

    @Override
    public JsonConverter build(JsonConverterError error) {
        switch (this.getProtocolVer()) {
            case 2: {
                return this.createJsonConverter(error);
            }
        }
        error.setError(20, String.valueOf(this.getProtocolVer()));
        return null;
    }

    @Override
    public void clear() {
        this.propertiesMap.clear();
        this.serviceNameIdConverter = null;
        if (Objects.nonNull(this.dataDictionary)) {
            this.dataDictionary = null;
        }
    }

    private int getProtocolVer() {
        if (!this.propertiesMap.containsKey(10)) {
            this.propertiesMap.put(10, 2);
        }
        return (Integer)this.propertiesMap.get(10);
    }

    private JsonConverter createJsonConverter(JsonConverterError error) {
        JsonConverterBaseImpl result = new JsonConverterBaseImpl();
        block9: for (Map.Entry<Integer, Object> entry : this.propertiesMap.entrySet()) {
            Integer propertyId = entry.getKey();
            switch (propertyId) {
                case 7: {
                    if (this.checkBoolean(entry, error)) {
                        result.catchUnexpectedKeys((Boolean)entry.getValue());
                        continue block9;
                    }
                    return null;
                }
                case 8: {
                    if (this.checkBoolean(entry, error)) {
                        result.catchUnexpectedFids((Boolean)entry.getValue());
                        continue block9;
                    }
                    return null;
                }
                case 9: {
                    if (this.checkBoolean(entry, error)) {
                        result.allowEnumDisplayStrings((Boolean)entry.getValue());
                        continue block9;
                    }
                    return null;
                }
                case 4: {
                    if (this.checkBoolean(entry, error)) {
                        result.useDefaultDynamicQoS((Boolean)entry.getValue());
                        continue block9;
                    }
                    return null;
                }
                case 5: {
                    if (this.checkBoolean(entry, error)) {
                        result.expandEnumFields((Boolean)entry.getValue());
                        continue block9;
                    }
                    return null;
                }
                case 3: {
                    if (this.checkInteger(entry, error)) {
                        result.setDefaultServiceId((Integer)entry.getValue());
                        result.setHasDefaultServiceId(true);
                        continue block9;
                    }
                    return null;
                }
                case 10: {
                    continue block9;
                }
            }
            error.setError(21, entry.toString() + " properties: " + this.propertiesMap.toString());
        }
        result.setDictionary(this.dataDictionary);
        result.setServiceNameIdConverter(this.serviceNameIdConverter);
        return result;
    }

    private boolean checkBoolean(Map.Entry<Integer, Object> entry, JsonConverterError error) {
        if (!(entry.getValue() instanceof Boolean)) {
            error.setError(21, entry.getKey() + " expected boolean");
            return false;
        }
        return true;
    }

    private boolean checkInteger(Map.Entry<Integer, Object> entry, JsonConverterError error) {
        if (!(entry.getValue() instanceof Integer)) {
            error.setError(21, entry.getKey() + " expected integer");
            return false;
        }
        return true;
    }
}

