/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.Codec;
import com.refinitiv.eta.codec.DataDictionary;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.DictionaryEntry;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.EnumTypeTable;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.PostUserInfo;
import com.refinitiv.eta.json.converter.AbstractContainerTypeConverter;
import com.refinitiv.eta.json.converter.AbstractPrimitiveTypeConverter;
import com.refinitiv.eta.json.converter.AbstractRsslMessageChunkTypeConverter;
import com.refinitiv.eta.json.converter.AbstractRsslMessageTypeConverter;
import com.refinitiv.eta.json.converter.AbstractTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ByteBufferInputStream;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.ConversionResults;
import com.refinitiv.eta.json.converter.DecodeJsonMsgOptions;
import com.refinitiv.eta.json.converter.EnumTableDefinition;
import com.refinitiv.eta.json.converter.GetJsonErrorParams;
import com.refinitiv.eta.json.converter.GetJsonMsgOptions;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonAckMsgConverter;
import com.refinitiv.eta.json.converter.JsonAnsiPageConverter;
import com.refinitiv.eta.json.converter.JsonArrayConverter;
import com.refinitiv.eta.json.converter.JsonAsciiConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonBufferConverter;
import com.refinitiv.eta.json.converter.JsonCloseMsgConverter;
import com.refinitiv.eta.json.converter.JsonConfInfoConverter;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.converter.JsonConverterState;
import com.refinitiv.eta.json.converter.JsonDateConverter;
import com.refinitiv.eta.json.converter.JsonDateTimeConverter;
import com.refinitiv.eta.json.converter.JsonDoubleConverter;
import com.refinitiv.eta.json.converter.JsonElementListConverter;
import com.refinitiv.eta.json.converter.JsonEnumerationConverter;
import com.refinitiv.eta.json.converter.JsonFieldListConverter;
import com.refinitiv.eta.json.converter.JsonFilterListConverter;
import com.refinitiv.eta.json.converter.JsonFloatConverter;
import com.refinitiv.eta.json.converter.JsonGenericMsgConverter;
import com.refinitiv.eta.json.converter.JsonIntConverter;
import com.refinitiv.eta.json.converter.JsonJsonConverter;
import com.refinitiv.eta.json.converter.JsonLongConverter;
import com.refinitiv.eta.json.converter.JsonMapConverter;
import com.refinitiv.eta.json.converter.JsonMsg;
import com.refinitiv.eta.json.converter.JsonMsgConverter;
import com.refinitiv.eta.json.converter.JsonMsgKeyConverter;
import com.refinitiv.eta.json.converter.JsonOpaqueConverter;
import com.refinitiv.eta.json.converter.JsonPostMsgConverter;
import com.refinitiv.eta.json.converter.JsonPostUserInfoConverter;
import com.refinitiv.eta.json.converter.JsonPriorityConverter;
import com.refinitiv.eta.json.converter.JsonQosConverter;
import com.refinitiv.eta.json.converter.JsonRMTESConverter;
import com.refinitiv.eta.json.converter.JsonRealConverter;
import com.refinitiv.eta.json.converter.JsonRefreshMsgConverter;
import com.refinitiv.eta.json.converter.JsonRequestMsgConverter;
import com.refinitiv.eta.json.converter.JsonSeriesConverter;
import com.refinitiv.eta.json.converter.JsonStateConverter;
import com.refinitiv.eta.json.converter.JsonStatusMsgConverter;
import com.refinitiv.eta.json.converter.JsonTimeConverter;
import com.refinitiv.eta.json.converter.JsonUnknownTypeConverter;
import com.refinitiv.eta.json.converter.JsonUpdateMsgConverter;
import com.refinitiv.eta.json.converter.JsonUtf8Converter;
import com.refinitiv.eta.json.converter.JsonVectorConverter;
import com.refinitiv.eta.json.converter.JsonXmlConverter;
import com.refinitiv.eta.json.converter.ParseJsonOptions;
import com.refinitiv.eta.json.converter.RWFToJsonOptions;
import com.refinitiv.eta.json.converter.RsslMsgChunkType;
import com.refinitiv.eta.json.converter.ServiceNameIdConverter;
import com.refinitiv.eta.json.util.JsonFactory;
import com.refinitiv.eta.transport.TransportBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class JsonConverterBaseImpl
extends JsonAbstractConverter {
    private final ThreadLocal<ObjectMapper> mapper;
    private ThreadLocal<JsonConverterState> currentState = ThreadLocal.withInitial(() -> null);
    private Map<Integer, AbstractRsslMessageTypeConverter> rsslMsgHandlerMap = new HashMap<Integer, AbstractRsslMessageTypeConverter>();
    private Map<Integer, AbstractPrimitiveTypeConverter> primitiveHandlerMap = new HashMap<Integer, AbstractPrimitiveTypeConverter>();
    private Map<Integer, AbstractContainerTypeConverter> containerHandlerMap = new HashMap<Integer, AbstractContainerTypeConverter>();
    private Map<RsslMsgChunkType, AbstractRsslMessageChunkTypeConverter> rsslMsgChunkHandlerMap = new HashMap<RsslMsgChunkType, AbstractRsslMessageChunkTypeConverter>();
    private boolean catchUnexpectedKeys;
    private boolean catchUnexpectedFids;
    private boolean allowEnumDisplayStrings;
    private boolean useDefaultQoS;
    private boolean expandEnumFields;
    private int defaultServiceId;
    private boolean hasDefaultServiceId;
    private DataDictionary dictionary;
    private ThreadLocal<DictionaryEntry> dictionaryEntry = ThreadLocal.withInitial(() -> null);
    private ThreadLocal<JsonBuffer> jsonOutputBuffer = ThreadLocal.withInitial(() -> new JsonBuffer());
    private ThreadLocal<ByteBufferInputStream> inputStream = ThreadLocal.withInitial(() -> new ByteBufferInputStream());
    private Map<EnumTypeTable, EnumTableDefinition> enumTableDefinitionMap = new HashMap<EnumTypeTable, EnumTableDefinition>(256);
    private static final Map<String, Integer> STRING_TO_RWF_MSG_CLASS = new HashMap<String, Integer>();
    private static final Map<String, Integer> STRING_TO_JSON_MSG_CLASS = new HashMap<String, Integer>();
    static final String UPDATE_STR = "Update";
    static final String GENERIC_STR = "Generic";
    static final String REFRESH_STR = "Refresh";
    static final String REQUEST_STR = "Request";
    static final String POST_STR = "Post";
    static final String STATUS_STR = "Status";
    static final String CLOSE_STR = "Close";
    static final String ACK_STR = "Ack";

    JsonConverterBaseImpl() {
        this.mapper = ThreadLocal.withInitial(() -> new ObjectMapper());
        this.initPrimitiveHandlers();
        this.initContainerHandlers();
        this.initRsslMsgChunkHandlers();
        this.initMessageHandlers();
    }

    private void initMessageHandlers() {
        this.rsslMsgHandlerMap.put(1, new JsonRequestMsgConverter(this));
        this.rsslMsgHandlerMap.put(3, new JsonStatusMsgConverter(this));
        this.rsslMsgHandlerMap.put(4, new JsonUpdateMsgConverter(this));
        this.rsslMsgHandlerMap.put(2, new JsonRefreshMsgConverter(this));
        this.rsslMsgHandlerMap.put(7, new JsonGenericMsgConverter(this));
        this.rsslMsgHandlerMap.put(6, new JsonAckMsgConverter(this));
        this.rsslMsgHandlerMap.put(5, new JsonCloseMsgConverter(this));
        this.rsslMsgHandlerMap.put(8, new JsonPostMsgConverter(this));
    }

    private void initRsslMsgChunkHandlers() {
        this.rsslMsgChunkHandlerMap.put(RsslMsgChunkType.MSG_KEY_CHUNK, new JsonMsgKeyConverter(this));
        this.rsslMsgChunkHandlerMap.put(RsslMsgChunkType.PRIORITY_CHUNK, new JsonPriorityConverter(this));
        this.rsslMsgChunkHandlerMap.put(RsslMsgChunkType.POST_USER_INFO_CHUNK, new JsonPostUserInfoConverter(this));
        this.rsslMsgChunkHandlerMap.put(RsslMsgChunkType.CONFINFO_CHUNK, new JsonConfInfoConverter(this));
    }

    private void initPrimitiveHandlers() {
        this.primitiveHandlerMap.put(12, new JsonQosConverter(this));
        this.primitiveHandlerMap.put(13, new JsonStateConverter(this));
        this.primitiveHandlerMap.put(15, new JsonArrayConverter(this));
        this.primitiveHandlerMap.put(14, new JsonEnumerationConverter(this));
        this.primitiveHandlerMap.put(16, new JsonBufferConverter(this));
        this.primitiveHandlerMap.put(18, new JsonUtf8Converter(this));
        this.primitiveHandlerMap.put(19, new JsonRMTESConverter(this));
        this.primitiveHandlerMap.put(17, new JsonAsciiConverter(this));
        JsonIntConverter convInt = new JsonIntConverter(this);
        for (int i = 0; i < convInt.dataTypes.length; ++i) {
            this.primitiveHandlerMap.put(convInt.dataTypes[i], convInt);
        }
        JsonLongConverter convLong = new JsonLongConverter(this);
        for (int i = 0; i < convLong.dataTypes.length; ++i) {
            this.primitiveHandlerMap.put(convLong.dataTypes[i], convLong);
        }
        JsonDateTimeConverter convDateTime = new JsonDateTimeConverter(this);
        for (int i = 0; i < convDateTime.dataTypes.length; ++i) {
            this.primitiveHandlerMap.put(convDateTime.dataTypes[i], convDateTime);
        }
        this.primitiveHandlerMap.put(9, new JsonDateConverter(this));
        this.primitiveHandlerMap.put(76, new JsonDateConverter(this));
        JsonTimeConverter convTime = new JsonTimeConverter(this);
        for (int i = 0; i < convTime.dataTypes.length; ++i) {
            this.primitiveHandlerMap.put(convTime.dataTypes[i], convTime);
        }
        this.primitiveHandlerMap.put(6, new JsonDoubleConverter(this));
        this.primitiveHandlerMap.put(73, new JsonDoubleConverter(this));
        this.primitiveHandlerMap.put(5, new JsonFloatConverter(this));
        this.primitiveHandlerMap.put(72, new JsonFloatConverter(this));
        this.primitiveHandlerMap.put(8, new JsonRealConverter(this));
        this.primitiveHandlerMap.put(74, new JsonRealConverter(this));
        this.primitiveHandlerMap.put(75, new JsonRealConverter(this));
        this.primitiveHandlerMap.put(0, new JsonUnknownTypeConverter(this));
    }

    private void initContainerHandlers() {
        this.containerHandlerMap.put(133, new JsonElementListConverter(this));
        this.containerHandlerMap.put(132, new JsonFieldListConverter(this));
        this.containerHandlerMap.put(135, new JsonFilterListConverter(this));
        this.containerHandlerMap.put(136, new JsonVectorConverter(this));
        this.containerHandlerMap.put(138, new JsonSeriesConverter(this));
        this.containerHandlerMap.put(137, new JsonMapConverter(this));
        this.containerHandlerMap.put(130, new JsonOpaqueConverter(this));
        this.containerHandlerMap.put(131, new JsonXmlConverter(this));
        this.containerHandlerMap.put(134, new JsonAnsiPageConverter(this));
        this.containerHandlerMap.put(142, new JsonJsonConverter(this));
        this.containerHandlerMap.put(141, new JsonMsgConverter(this));
    }

    @Override
    public int parseJsonBuffer(Buffer jsonBuffer, ParseJsonOptions options, JsonConverterError error) {
        if (options.getProtocolType() != 2) {
            return error.setError(17, "Protocol type not supported: " + options.getProtocolType());
        }
        return this.parseJsonBuffer(jsonBuffer.data().array(), error);
    }

    @Override
    public int parseJsonBuffer(TransportBuffer inBuffer, ParseJsonOptions options, JsonConverterError error) {
        if (options.getProtocolType() != 2) {
            return error.setError(17, "Protocol type not supported: " + options.getProtocolType());
        }
        return this.parseJsonBuffer(inBuffer, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int decodeJsonMsg(JsonMsg jsonMsg, DecodeJsonMsgOptions options, JsonConverterError error) {
        if (options.getJsonProtocolType() != 2) {
            return error.setError(17, "Protocol type not supported: " + options.getJsonProtocolType());
        }
        jsonMsg.rwfMsg().clear();
        int ret = this.setCurrentMessageRoot(error);
        if (ret != 0) {
            return ret;
        }
        if (this.getJsonMsgType(jsonMsg, this.currentState.get().getWorkingNode(), error) != 0) {
            this.currentState.get().setFailedNode(this.currentState.get().getWorkingNode());
            return -1;
        }
        EncodeIterator encIter = JsonFactory.createEncodeIterator();
        try {
            if (jsonMsg.jsonMsgClass() == 1) {
                this.prepareJsonMsgToDecode(jsonMsg);
                encIter.clear();
                encIter.setBufferAndRWFVersion(jsonMsg.rwfMsg().encodedMsgBuffer(), Codec.majorVersion(), Codec.minorVersion());
                this.decodeRsslMessage(jsonMsg.rwfMsg().msgClass(), this.currentState.get().getWorkingNode(), jsonMsg.rwfMsg(), error, encIter);
                if (error.isFailed()) {
                    this.currentState.get().setFailedNode(this.currentState.get().getWorkingNode());
                    int n = -1;
                    return n;
                }
            }
        }
        finally {
            JsonFactory.releaseEncodeIterator(encIter);
        }
        return error.isSuccessful() ? 0 : -1;
    }

    private int setCurrentMessageRoot(JsonConverterError error) {
        JsonConverterState state = this.currentState.get();
        JsonNode root = state.getCurrentRoot();
        if (Objects.isNull(root)) {
            return 14;
        }
        if (root.isObject()) {
            state.setCurrentRoot(null);
            state.setWorkingNode(root);
            return 0;
        }
        if (root.isArray()) {
            if (state.getArrayCounter() >= root.size()) {
                return 14;
            }
            JsonNode currentEntry = root.get(state.getArrayCounter());
            if (currentEntry.isObject()) {
                state.setWorkingNode(currentEntry);
                state.setArrayCounter(state.getArrayCounter() + 1);
                return error.isSuccessful() ? 0 : -1;
            }
            if (currentEntry.isArray()) {
                if (state.getEntryCounter() >= currentEntry.size()) {
                    state.setEntryCounter(0);
                    state.setArrayCounter(state.getArrayCounter() + 1);
                    return this.setCurrentMessageRoot(error);
                }
                state.setWorkingNode(currentEntry.get(state.getEntryCounter()));
                state.setEntryCounter(state.getEntryCounter() + 1);
                return 0;
            }
            error.setError(2, "Error parsing JSON message: expected single message or array of messages, found " + currentEntry.getNodeType().toString() + " type", "root");
            this.currentState.get().setFailedNode(currentEntry);
            return -1;
        }
        error.setError(2, "Error parsing JSON message: expected single message or array of messages, found " + root.getNodeType().toString() + " type", "root");
        this.currentState.get().setFailedNode(root);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int convertRWFToJson(Msg inMsg, RWFToJsonOptions options, ConversionResults outResults, JsonConverterError error) {
        if (options.getJsonProtocolType() != 2) {
            error.setError(-1, "Invalid protocol type.");
            return -1;
        }
        JsonBuffer buffer = this.jsonOutputBuffer.get();
        buffer.position = 0;
        int requiredLenght = this.estimateJsonLength(inMsg.encodedDataBody().length());
        if (buffer.data == null || buffer.data.length < requiredLenght) {
            JsonFactory.releaseByteArray(buffer.data);
            buffer.data = JsonFactory.createByteArray(requiredLenght);
        }
        DecodeIterator iter = JsonFactory.createDecodeIterator();
        try {
            iter.clear();
            if (inMsg.encodedDataBody() == null || inMsg.encodedDataBody().data() == null) {
                error.setError(-1, "RWF Msg encodedDataBody() is not initialized.");
                int n = -1;
                return n;
            }
            iter.setBufferAndRWFVersion(inMsg.encodedDataBody(), Codec.majorVersion(), Codec.minorVersion());
            if (this.processMsg(iter, inMsg, buffer, error, true)) {
                if (outResults != null) {
                    outResults.setLength(buffer.position + 25);
                }
                int n = 0;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            JsonFactory.releaseDecodeIterator(iter);
        }
    }

    @Override
    public int convertRWFToJson(Msg inMsg, RWFToJsonOptions options, JsonConverterError error) {
        return this.convertRWFToJson(inMsg, options, null, error);
    }

    @Override
    public int getJsonBuffer(Buffer buffer, GetJsonMsgOptions options, JsonConverterError error) {
        JsonBuffer json = this.jsonOutputBuffer.get();
        if (options.getStreamId() == null || options.isCloseMsg()) {
            if (json.position >= buffer.length()) {
                buffer.data(ByteBuffer.wrap(new byte[json.position]));
            }
            buffer.data().put(json.data, 0, json.position);
        } else {
            int fullLength = json.position - BufferHelper.getCurrentStreamIdLength(json, error) + BasicPrimitiveConverter.getLongLengthCompare(options.getStreamId().intValue());
            byte[] outputData = new byte[fullLength];
            BufferHelper.composeMessage(outputData, (int)options.getStreamId(), json, error);
            buffer.data(ByteBuffer.wrap(outputData));
        }
        return 0;
    }

    @Override
    public int getJsonBuffer(TransportBuffer buffer, GetJsonMsgOptions options, JsonConverterError error) {
        JsonBuffer json = this.jsonOutputBuffer.get();
        if (options.getStreamId() == null || options.isCloseMsg()) {
            if (buffer.data().limit() - buffer.data().position() < json.position) {
                error.setError(17, "Buffer length is not enough to encode the message, expected " + json.position + " bytes, found " + (buffer.data().limit() - buffer.data().position()) + " bytes");
                return -1;
            }
            buffer.data().put(json.data, 0, json.position);
        } else {
            int fullLength = json.position - BufferHelper.getCurrentStreamIdLength(json, error) + BasicPrimitiveConverter.getLongLengthCompare(options.getStreamId().intValue());
            if (buffer.data().limit() - buffer.data().position() < fullLength) {
                error.setError(17, "Buffer length is not enough to encode the message, expected " + fullLength + " bytes, found " + (buffer.data().limit() - buffer.data().position()) + " bytes");
                return -1;
            }
            BufferHelper.composeMessage(buffer.data(), (int)options.getStreamId(), json, error);
        }
        return 0;
    }

    @Override
    public int getErrorMessage(Buffer outBuffer, GetJsonErrorParams params, JsonConverterError error) {
        try {
            boolean res;
            JsonBuffer buffer;
            byte[] currentMessage = null;
            if (this.currentState.get().getFailedNode() != null) {
                currentMessage = this.currentState.get().getFailedNode().toString().getBytes("UTF-8");
            } else if (this.currentState.get().getFailedMessage() != null) {
                currentMessage = this.currentState.get().getFailedMessage();
            }
            int countCharsToEscape = BasicPrimitiveConverter.charsToEscapeCount(currentMessage);
            int estimatedMaxLength = (currentMessage != null ? currentMessage.length : 0) + params.getFile().getBytes(StandardCharsets.UTF_8).length + params.getText().getBytes(StandardCharsets.UTF_8).length + BasicPrimitiveConverter.getLongLengthCompare(params.getLine()) + countCharsToEscape + 207;
            try {
                buffer = new JsonBuffer(estimatedMaxLength);
            }
            catch (Exception e) {
                error.setError(17, "Failed to create JSON Error message: " + e.getMessage());
                return -1;
            }
            boolean bl = res = BufferHelper.beginObject(buffer, error) && BufferHelper.writeArrayAndColon("ID", buffer, false, error) && BasicPrimitiveConverter.writeLong(params.getStreamId(), buffer, error) && BufferHelper.writeArrayAndColon("Type", buffer, true, error) && BufferHelper.writeArray("Error", buffer, true, error) && BufferHelper.writeArrayAndColon("Text", buffer, true, error) && BasicPrimitiveConverter.writeSafeString(params.getText().getBytes(StandardCharsets.UTF_8), buffer, error) && BufferHelper.writeArrayAndColon("Debug", buffer, true, error) && BufferHelper.beginObject(buffer, error);
            if (res && params.getFile() != null) {
                boolean bl2 = res = BufferHelper.writeArrayAndColon("File", buffer, false, error) && BufferHelper.writeArray(params.getFile(), buffer, true, error);
            }
            if (res && params.getLine() != -1) {
                boolean bl3 = res = BufferHelper.writeArrayAndColon("Line", buffer, true, error) && BasicPrimitiveConverter.writeLong(params.getLine(), buffer, error);
            }
            if (res && currentMessage != null) {
                res = BufferHelper.writeArrayAndColon("Message", buffer, true, error) && BasicPrimitiveConverter.writeSafeString(currentMessage, buffer, error);
            }
            boolean bl4 = res = res && BufferHelper.endObject(buffer, error) && BufferHelper.endObject(buffer, error);
            if (res) {
                ByteBuffer output = ByteBuffer.wrap(buffer.data, 0, buffer.position);
                outBuffer.data(output);
            }
            return res ? 0 : -1;
        }
        catch (UnsupportedEncodingException e) {
            error.setError(17, "Failed to create JSON Error message: " + e.getMessage());
            return -1;
        }
    }

    @Override
    boolean processMsg(DecodeIterator decIter, Msg inMsg, JsonBuffer outBuffer, JsonConverterError error, boolean first) {
        String msgClass = this.getMsgClassString(inMsg.msgClass());
        if (msgClass == null) {
            error.setError(-1, "Unsupported msg class " + inMsg.msgClass());
            return false;
        }
        if (inMsg.msgClass() != 5) {
            BufferHelper.beginObject(outBuffer, error);
            BufferHelper.writeArrayAndColon("ID", outBuffer, false, error);
            BasicPrimitiveConverter.writeLong(inMsg.streamId(), outBuffer, error);
            BufferHelper.writeArrayAndColon("Type", outBuffer, true, error);
            BufferHelper.writeArray(msgClass, outBuffer, true, error);
            if (inMsg.domainType() != 6) {
                BufferHelper.writeArrayAndColon("Domain", outBuffer, true, error);
                String domain = this.getDomainString(inMsg.domainType());
                if (domain != null) {
                    BufferHelper.writeArray(domain, outBuffer, true, error);
                } else {
                    BasicPrimitiveConverter.writeLong(inMsg.domainType(), outBuffer, error);
                }
            }
        } else {
            BufferHelper.beginObject(outBuffer, error);
        }
        return error.isSuccessful() && this.getRsslMessageHandler(inMsg.msgClass()).encodeJson(decIter, inMsg, outBuffer, error) && BufferHelper.endObject(outBuffer, error);
    }

    AbstractRsslMessageTypeConverter getRsslMessageHandler(int msgClassTypeId, JsonConverterError error) {
        AbstractRsslMessageTypeConverter handler = this.getRsslMessageHandler(msgClassTypeId);
        if (handler != null) {
            return handler;
        }
        this.currentState.get().setFailedNode(this.currentState.get().getWorkingNode());
        error.setError(50, "dataType [" + msgClassTypeId + "] no rsslMessageHandler found");
        return null;
    }

    @Override
    AbstractTypeConverter getHandler(int dataType, JsonConverterError error) {
        AbstractTypeConverter handler = this.getContainerHandler(dataType);
        if (handler != null) {
            return handler;
        }
        handler = this.getPrimitiveHandler(dataType);
        if (handler != null) {
            return handler;
        }
        this.currentState.get().setFailedNode(this.currentState.get().getWorkingNode());
        error.setError(50, "dataType [" + dataType + "] no primitive/container handler found");
        return null;
    }

    @Override
    AbstractTypeConverter getHandler(RsslMsgChunkType rsslMsgChunkType, JsonConverterError error) {
        AbstractRsslMessageChunkTypeConverter handler = this.getMsgChunkHandler(rsslMsgChunkType);
        if (handler != null) {
            return handler;
        }
        this.currentState.get().setFailedNode(this.currentState.get().getWorkingNode());
        error.setError(50, "dataType [" + (Object)((Object)rsslMsgChunkType) + "] no rssl msgChunk handler found");
        return handler;
    }

    @Override
    AbstractPrimitiveTypeConverter getPrimitiveHandler(int dataType) {
        if (dataType >= 0 && dataType <= 19 || dataType >= 64 && dataType <= 84) {
            return this.primitiveHandlerMap.get(dataType);
        }
        return null;
    }

    @Override
    AbstractContainerTypeConverter getContainerHandler(int dataType) {
        return this.containerHandlerMap.get(dataType);
    }

    @Override
    AbstractRsslMessageChunkTypeConverter getMsgChunkHandler(RsslMsgChunkType rsslMsgChunkType) {
        return this.rsslMsgChunkHandlerMap.get((Object)rsslMsgChunkType);
    }

    @Override
    AbstractRsslMessageTypeConverter getRsslMessageHandler(int msgClassId) {
        return this.rsslMsgHandlerMap.get(msgClassId);
    }

    @Override
    int getContainerDataType(String jsonTagName, JsonNode jsonNode, JsonConverterError error) {
        int dataType = this.getContainerType(jsonTagName);
        if (dataType == 128) {
            this.currentState.get().setFailedNode(this.currentState.get().getWorkingNode());
            error.setError(6, "jsonTag " + jsonTagName + " container is not supported");
        }
        if (!this.checkContainerValueType(dataType, jsonNode)) {
            this.currentState.get().setFailedNode(this.currentState.get().getWorkingNode());
            error.setError(4, "found value of type " + jsonNode.getNodeType().toString() + " for container type " + jsonTagName);
        }
        return dataType;
    }

    @Override
    int getContainerType(String type) {
        switch (type) {
            case "FieldList": 
            case "Fields": {
                return 132;
            }
            case "FilterList": {
                return 135;
            }
            case "Elements": 
            case "ElementList": {
                return 133;
            }
            case "Json": {
                return 142;
            }
            case "Map": {
                return 137;
            }
            case "Message": {
                return 141;
            }
            case "Opaque": {
                return 130;
            }
            case "Vector": {
                return 136;
            }
            case "Series": {
                return 138;
            }
            case "Xml": {
                return 131;
            }
            case "AnsiPage": {
                return 134;
            }
        }
        return 128;
    }

    private boolean checkContainerValueType(int dataType, JsonNode jsonNode) {
        switch (dataType) {
            case 130: 
            case 131: {
                return jsonNode.isTextual() || jsonNode.isNull();
            }
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 141: 
            case 142: {
                return jsonNode.isObject() || jsonNode.isNull();
            }
        }
        return false;
    }

    private int estimateJsonLength(int rwfLength) {
        return rwfLength * 6 + 300;
    }

    private void prepareJsonMsgToDecode(JsonMsg jsonMsg) {
        Buffer currentBuffer = this.currentState.get().getCurrentBufferData();
        if (jsonMsg.jsonMsgData().length() <= 0) {
            jsonMsg.jsonMsgData().data(ByteBuffer.allocate(currentBuffer.length()));
        }
        if (jsonMsg.rwfMsg().encodedMsgBuffer().length() <= 0) {
            jsonMsg.rwfMsg().encodedMsgBuffer().data(ByteBuffer.allocate(currentBuffer.length()));
        }
        currentBuffer.copy(jsonMsg.jsonMsgData());
    }

    private String getMsgClassString(int msgClass) {
        switch (msgClass) {
            case 6: {
                return ACK_STR;
            }
            case 5: {
                return CLOSE_STR;
            }
            case 7: {
                return GENERIC_STR;
            }
            case 8: {
                return POST_STR;
            }
            case 1: {
                return REQUEST_STR;
            }
            case 2: {
                return REFRESH_STR;
            }
            case 3: {
                return STATUS_STR;
            }
            case 4: {
                return UPDATE_STR;
            }
        }
        return null;
    }

    private String getDomainString(int domainType) {
        switch (domainType) {
            case 1: {
                return "Login";
            }
            case 4: {
                return "Source";
            }
            case 5: {
                return "Dictionary";
            }
            case 6: {
                return "MarketPrice";
            }
            case 7: {
                return "MarketByOrder";
            }
            case 8: {
                return "MarketByPrice";
            }
            case 9: {
                return "MarketMaker";
            }
            case 10: {
                return "SymbolList";
            }
            case 11: {
                return "ServiceProviderStatus";
            }
            case 12: {
                return "History";
            }
            case 13: {
                return "Headline";
            }
            case 14: {
                return "Story";
            }
            case 15: {
                return "ReplayHeadline";
            }
            case 16: {
                return "ReplayStory";
            }
            case 17: {
                return "Transaction";
            }
            case 22: {
                return "YieldCurve";
            }
            case 27: {
                return "Contribution";
            }
            case 29: {
                return "ProviderAdmin";
            }
            case 30: {
                return "Analytics";
            }
            case 31: {
                return "Reference";
            }
            case 33: {
                return "NewsTextAnalytics";
            }
            case 34: {
                return "EconomicIndicator";
            }
            case 35: {
                return "Poll";
            }
            case 36: {
                return "Forecast";
            }
            case 37: {
                return "MarketByTime";
            }
            case 127: {
                return "System";
            }
        }
        return null;
    }

    @Override
    synchronized EnumTableDefinition getEnumTableDefinition(EnumTypeTable enumTypeTable) {
        EnumTableDefinition enumTableDefinition = this.enumTableDefinitionMap.get(enumTypeTable);
        if (Objects.isNull(enumTableDefinition)) {
            enumTableDefinition = new EnumTableDefinition(enumTypeTable.maxValue());
            this.enumTableDefinitionMap.put(enumTypeTable, enumTableDefinition);
        }
        return enumTableDefinition;
    }

    @Override
    ObjectMapper getMapper() {
        return this.mapper.get();
    }

    @Override
    DictionaryEntry dictionaryEntry() {
        return this.dictionaryEntry.get();
    }

    @Override
    void dictionaryEntry(DictionaryEntry entry) {
        this.dictionaryEntry.set(entry);
    }

    @Override
    ServiceNameIdConverter getServiceNameIdConverter() {
        return this.serviceNameIdConverter;
    }

    @Override
    DataDictionary getDictionary() {
        return this.dictionary;
    }

    void setDictionary(DataDictionary dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    boolean catchUnexpectedKeys() {
        return this.catchUnexpectedKeys;
    }

    void catchUnexpectedKeys(boolean enabled) {
        this.catchUnexpectedKeys = enabled;
    }

    @Override
    boolean catchUnexpectedFids() {
        return this.catchUnexpectedFids;
    }

    void catchUnexpectedFids(boolean enabled) {
        this.catchUnexpectedFids = enabled;
    }

    @Override
    boolean allowEnumDisplayStrings() {
        return this.allowEnumDisplayStrings;
    }

    void allowEnumDisplayStrings(boolean enabled) {
        this.allowEnumDisplayStrings = enabled;
    }

    @Override
    boolean useDefaultDynamicQoS() {
        return this.useDefaultQoS;
    }

    void useDefaultDynamicQoS(boolean enabled) {
        this.useDefaultQoS = enabled;
    }

    @Override
    boolean expandEnumFields() {
        return this.expandEnumFields;
    }

    void expandEnumFields(boolean enabled) {
        this.expandEnumFields = enabled;
    }

    @Override
    int getDefaultServiceId() {
        return this.defaultServiceId;
    }

    @Override
    boolean hasDefaultServiceId() {
        return this.hasDefaultServiceId;
    }

    @Override
    void setHasDefaultServiceId(boolean value) {
        this.hasDefaultServiceId = value;
    }

    void setDefaultServiceId(int id) {
        this.defaultServiceId = id;
    }

    private int parseJsonBuffer(byte[] data, JsonConverterError error) {
        try {
            JsonConverterState jsonConverterState = Optional.ofNullable(this.currentState.get()).orElseGet(JsonConverterState::new);
            jsonConverterState.clear();
            this.currentState.set(jsonConverterState);
            jsonConverterState.setCurrentRoot(this.mapper.get().readTree(data));
            jsonConverterState.getCurrentBufferData().data(ByteBuffer.wrap(data));
        }
        catch (IOException e) {
            this.currentState.get().setFailedMessage(data);
            return error.setError(2, e.getMessage());
        }
        return 0;
    }

    private int parseJsonBuffer(TransportBuffer buffer, JsonConverterError error) {
        try {
            JsonConverterState jsonConverterState = Optional.ofNullable(this.currentState.get()).orElseGet(JsonConverterState::new);
            jsonConverterState.clear();
            this.currentState.set(jsonConverterState);
            ByteBuffer data = buffer.data();
            ByteBufferInputStream stream = this.inputStream.get();
            stream.setByteBuffer(data, buffer.dataStartPosition(), data.limit());
            ObjectMapper objectMapper = this.mapper.get();
            objectMapper.enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_LEADING_ZEROS_FOR_NUMBERS.mappedFeature()});
            jsonConverterState.setCurrentRoot(objectMapper.readTree((InputStream)stream));
            jsonConverterState.getCurrentBufferData().data(data);
        }
        catch (IOException e) {
            byte[] data = new byte[buffer.length()];
            ByteBuffer inData = buffer.data();
            for (int i = 0; i < buffer.length(); ++i) {
                data[i] = inData.get(i + buffer.dataStartPosition());
            }
            this.currentState.get().setFailedMessage(data);
            return error.setError(2, e.getMessage());
        }
        return 0;
    }

    @Override
    public void decodeRsslMessage(int msgClassTypeId, JsonNode path, Object msg, JsonConverterError error, EncodeIterator encodeIterator) {
        AbstractRsslMessageTypeConverter subParser = this.getRsslMessageHandler(msgClassTypeId, error);
        if (error.isFailed()) {
            return;
        }
        subParser.decodeJson(path, msg, error);
        if (error.isFailed()) {
            return;
        }
        subParser.encodeRWF(path, "root", (Msg)msg, encodeIterator, error);
    }

    @Override
    public void decodeChunk(int dataType, JsonNode path, Object msg, JsonConverterError error) {
        AbstractTypeConverter subParser = this.getHandler(dataType, error);
        if (error.isFailed()) {
            return;
        }
        subParser.decodeJson(path, msg, error);
    }

    @Override
    protected void decodeChunk(RsslMsgChunkType rsslMsgChunkType, JsonNode path, Object msg, JsonConverterError error) {
        AbstractTypeConverter subParser = this.getHandler(rsslMsgChunkType, error);
        if (error.isFailed()) {
            return;
        }
        subParser.decodeJson(path, msg, error);
    }

    @Override
    public void decodeChunk(int dataType, JsonNode dataNode, String key, EncodeIterator iterator, JsonConverterError error) {
        AbstractTypeConverter subParser = this.getHandler(dataType, error);
        if (subParser == null) {
            error.setError(50, "Unknown datatype to parse: [" + dataType + "]");
            return;
        }
        if (subParser instanceof AbstractPrimitiveTypeConverter && !((AbstractPrimitiveTypeConverter)subParser).isInRange(dataType, dataNode)) {
            error.setError(4, "Value outside the range: [" + dataType + "]");
            return;
        }
        subParser.encodeRWF(dataNode, key, iterator, error);
    }

    @Override
    public int getRwfMsgTypeFromJson(JsonNode type, JsonConverterError error) {
        if (type.isInt()) {
            return type.intValue();
        }
        return this.stringToMsgClass(type.textValue(), error);
    }

    private int stringToMsgClass(String type, JsonConverterError error) {
        if (!STRING_TO_RWF_MSG_CLASS.containsKey(type)) {
            this.currentState.get().setFailedNode(this.currentState.get().getWorkingNode());
            return error.setError(50, type, "root");
        }
        return STRING_TO_RWF_MSG_CLASS.get(type);
    }

    @Override
    public int getJsonMsgType(JsonMsg jsonMsg, JsonNode rootNode, JsonConverterError error) {
        int jsonTypeMsg = 0;
        int rwfTypeMsg = 0;
        JsonNode typeNode = null;
        if (!rootNode.isMissingNode()) {
            typeNode = rootNode.path("Type");
            if (!typeNode.isMissingNode()) {
                if (typeNode.isInt()) {
                    jsonTypeMsg = 1;
                    rwfTypeMsg = typeNode.intValue();
                } else if (STRING_TO_RWF_MSG_CLASS.containsKey(typeNode.textValue())) {
                    jsonTypeMsg = 1;
                    rwfTypeMsg = STRING_TO_RWF_MSG_CLASS.get(typeNode.textValue());
                } else if (STRING_TO_JSON_MSG_CLASS.containsKey(typeNode.textValue())) {
                    jsonTypeMsg = STRING_TO_JSON_MSG_CLASS.get(typeNode.textValue());
                }
            } else {
                jsonTypeMsg = 1;
                rwfTypeMsg = 1;
            }
        }
        if (jsonTypeMsg == 0 || jsonTypeMsg == 1 && rwfTypeMsg == 0) {
            this.currentState.get().setFailedNode(rootNode);
            return error.setError(10, "Message type is not supported: " + typeNode);
        }
        jsonMsg.jsonMsgClass(jsonTypeMsg);
        if (jsonTypeMsg == 1) {
            jsonMsg.rwfMsg().msgClass(rwfTypeMsg);
        }
        return 0;
    }

    @Override
    int getDataType(JsonNode dataType) {
        if (dataType.isInt()) {
            int type = dataType.asInt() + 128;
            if (type >= 0 && type <= 142) {
                return type;
            }
            return -1;
        }
        if (dataType.isTextual()) {
            switch (dataType.asText()) {
                case "Unknown": {
                    return 0;
                }
                case "Int": {
                    return 3;
                }
                case "UInt": {
                    return 4;
                }
                case "Float": {
                    return 5;
                }
                case "Double": {
                    return 6;
                }
                case "Real": {
                    return 8;
                }
                case "Date": {
                    return 9;
                }
                case "Time": {
                    return 10;
                }
                case "DateTime": {
                    return 11;
                }
                case "Qos": {
                    return 12;
                }
                case "State": {
                    return 13;
                }
                case "Enum": {
                    return 14;
                }
                case "Array": {
                    return 15;
                }
                case "Buffer": {
                    return 16;
                }
                case "AsciiString": {
                    return 17;
                }
                case "Utf8String": {
                    return 18;
                }
                case "RmtesString": {
                    return 19;
                }
                case "Int1": {
                    return 64;
                }
                case "UInt1": {
                    return 65;
                }
                case "Int2": {
                    return 66;
                }
                case "UInt2": {
                    return 67;
                }
                case "Int4": {
                    return 68;
                }
                case "UInt4": {
                    return 69;
                }
                case "Int8": {
                    return 70;
                }
                case "UInt8": {
                    return 71;
                }
                case "Float4": {
                    return 72;
                }
                case "Double8": {
                    return 73;
                }
                case "Real4RB": {
                    return 74;
                }
                case "Real8RB": {
                    return 75;
                }
                case "Date4": {
                    return 76;
                }
                case "Time3": {
                    return 77;
                }
                case "Time5": {
                    return 78;
                }
                case "DateTime7": {
                    return 79;
                }
                case "DateTime9": {
                    return 80;
                }
                case "DateTime11": {
                    return 81;
                }
                case "DateTime12": {
                    return 82;
                }
                case "Time7": {
                    return 83;
                }
                case "Time8": {
                    return 84;
                }
                case "NoData": {
                    return 128;
                }
                case "Opaque": {
                    return 130;
                }
                case "Xml": {
                    return 131;
                }
                case "FieldList": {
                    return 132;
                }
                case "ElementList": {
                    return 133;
                }
                case "AnsiPage": {
                    return 134;
                }
                case "FilterList": {
                    return 135;
                }
                case "Vector": {
                    return 136;
                }
                case "Map": {
                    return 137;
                }
                case "Series": {
                    return 138;
                }
                case "Msg": {
                    return 141;
                }
                case "Json": {
                    return 142;
                }
            }
            return -1;
        }
        return -1;
    }

    @Override
    int getPayloadType(JsonNode node) {
        for (int i = 0; i < node.size(); ++i) {
            JsonNode curr = node.get(i);
            Iterator it = curr.fieldNames();
            while (it.hasNext()) {
                String name;
                switch (name = (String)it.next()) {
                    case "FieldList": 
                    case "Fields": {
                        return 132;
                    }
                    case "FilterList": {
                        return 135;
                    }
                    case "Elements": 
                    case "ElementList": {
                        return 133;
                    }
                    case "Json": {
                        return 142;
                    }
                    case "Map": {
                        return 137;
                    }
                    case "Message": {
                        return 141;
                    }
                    case "Opaque": {
                        return 130;
                    }
                    case "Vector": {
                        return 136;
                    }
                    case "Series": {
                        return 138;
                    }
                    case "Xml": {
                        return 131;
                    }
                    case "AnsiPage": {
                        return 134;
                    }
                }
            }
        }
        return 128;
    }

    @Override
    public String getDataType(int dataType) {
        if (dataType >= 0 && dataType <= 19) {
            return ConstCharArrays.dataTypeStrings[dataType];
        }
        if (dataType >= 64 && dataType <= 84) {
            return ConstCharArrays.dataTypeStrings[dataType - 44];
        }
        if (dataType >= 130 && dataType <= 142) {
            return ConstCharArrays.dataTypeStrings[dataType - 87];
        }
        if (dataType == 128) {
            return ConstCharArrays.dataTypeStrings[41];
        }
        return null;
    }

    @Override
    boolean processMsgKey(DecodeIterator decIter, Object msgKey, JsonBuffer outBuffer, int domain, boolean wantServiceName, JsonConverterError error) {
        return ((JsonMsgKeyConverter)this.rsslMsgChunkHandlerMap.get((Object)RsslMsgChunkType.MSG_KEY_CHUNK)).encodeJson(decIter, msgKey, outBuffer, domain, wantServiceName, error);
    }

    @Override
    boolean processPostUserInfo(PostUserInfo info, JsonBuffer outBuffer, JsonConverterError error) {
        return ((JsonPostUserInfoConverter)this.rsslMsgChunkHandlerMap.get((Object)RsslMsgChunkType.POST_USER_INFO_CHUNK)).writeToJson(outBuffer, info, error);
    }

    static {
        STRING_TO_RWF_MSG_CLASS.put(REQUEST_STR, 1);
        STRING_TO_RWF_MSG_CLASS.put(REFRESH_STR, 2);
        STRING_TO_RWF_MSG_CLASS.put(STATUS_STR, 3);
        STRING_TO_RWF_MSG_CLASS.put(UPDATE_STR, 4);
        STRING_TO_RWF_MSG_CLASS.put(CLOSE_STR, 5);
        STRING_TO_RWF_MSG_CLASS.put(ACK_STR, 6);
        STRING_TO_RWF_MSG_CLASS.put(GENERIC_STR, 7);
        STRING_TO_RWF_MSG_CLASS.put(POST_STR, 8);
        STRING_TO_JSON_MSG_CLASS.put("Ping", 2);
        STRING_TO_JSON_MSG_CLASS.put("Pong", 3);
        STRING_TO_JSON_MSG_CLASS.put("Error", 4);
    }
}

