/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.UpdateMsg;
import com.refinitiv.eta.json.converter.AbstractRsslMessageChunkTypeConverter;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonConverterError;
import java.util.Iterator;

class JsonConfInfoConverter
extends AbstractRsslMessageChunkTypeConverter {
    JsonConfInfoConverter(JsonAbstractConverter converter) {
        super(converter);
    }

    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        this.checkObject(node, "ConflationInfo", error);
        if (error.isFailed()) {
            return;
        }
        UpdateMsg updateMsg = (UpdateMsg)msg;
        boolean hasCount = false;
        boolean hasTime = false;
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            JsonNode currentNode = node.path(key);
            switch (key) {
                case "Count": {
                    updateMsg.conflationCount(this.getInt(currentNode, key, error));
                    hasCount = true;
                    break;
                }
                case "Time": {
                    updateMsg.conflationTime(this.getInt(currentNode, key, error));
                    hasTime = true;
                    break;
                }
                default: {
                    this.processUnexpectedKey(key, error);
                }
            }
            if (!error.isFailed()) continue;
            return;
        }
        if (!hasCount) {
            error.setError(12, "Count");
        }
        if (!hasTime) {
            error.setError(12, "Time");
        }
    }
}

