/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.Array;
import com.refinitiv.eta.codec.ArrayEntry;
import com.refinitiv.eta.codec.CloseMsg;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.ElementEntry;
import com.refinitiv.eta.codec.ElementList;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Int;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.json.converter.AbstractRsslMessageTypeConverter;
import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.BufferConverter;
import com.refinitiv.eta.json.converter.BufferHelper;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;
import com.refinitiv.eta.rdm.ElementNames;
import java.util.Objects;

class JsonCloseMsgConverter
extends AbstractRsslMessageTypeConverter {
    JsonCloseMsgConverter(JsonAbstractConverter converter) {
        super(converter);
    }

    @Override
    boolean encodeJson(DecodeIterator decIter, Object msg, JsonBuffer outBuffer, JsonConverterError error) {
        CloseMsg closeMsg = (CloseMsg)msg;
        boolean isBatch = false;
        JsonBuffer elementListBuffer = null;
        JsonBuffer batchBuffer = null;
        if (closeMsg.containerType() == 133 && closeMsg.encodedDataBody().length() != 0) {
            batchBuffer = new JsonBuffer();
            elementListBuffer = new JsonBuffer();
            if (!this.decodeElementList(batchBuffer, elementListBuffer, decIter, this.estimateJsonLength(closeMsg.encodedDataBody().length()), error)) {
                return false;
            }
            if (batchBuffer.data != null) {
                isBatch = true;
            }
        }
        BufferHelper.writeArrayAndColon("ID", outBuffer, false, error);
        if (isBatch) {
            BufferHelper.copyToByteArray(batchBuffer.data, 0, batchBuffer.position, outBuffer, error);
        } else {
            BasicPrimitiveConverter.writeLong(closeMsg.streamId(), outBuffer, error);
        }
        String msgType = this.getMsgClassString(closeMsg.msgClass());
        BufferHelper.writeArrayAndColon("Type", outBuffer, true, error);
        if (msgType != null) {
            BufferHelper.writeArray(msgType, outBuffer, true, error);
        } else {
            BasicPrimitiveConverter.writeLong(closeMsg.msgClass(), outBuffer, error);
        }
        if (closeMsg.domainType() != 6) {
            String domainType = this.getDomainString(closeMsg.domainType());
            BufferHelper.writeArrayAndColon("Domain", outBuffer, true, error);
            if (domainType != null) {
                BufferHelper.writeArray(domainType, outBuffer, true, error);
            } else {
                BasicPrimitiveConverter.writeLong(closeMsg.domainType(), outBuffer, error);
            }
        }
        if (closeMsg.checkAck()) {
            BufferHelper.writeArrayAndColon("Ack", outBuffer, true, error);
            BufferHelper.writeArray("true", outBuffer, false, error);
        }
        if (closeMsg.checkHasExtendedHdr()) {
            if (Objects.nonNull(closeMsg.extendedHeader()) && Objects.nonNull(closeMsg.extendedHeader().data())) {
                BufferHelper.writeArrayAndColon("ExtHdr", outBuffer, true, error);
                if (!this.converter.getPrimitiveHandler(16).encodeJson(closeMsg.extendedHeader(), outBuffer, error)) {
                    return false;
                }
            } else {
                error.setError(4, "Empty extended header found");
                return false;
            }
        }
        if (!isBatch && closeMsg.containerType() != 128) {
            if (closeMsg.containerType() == 133) {
                if (elementListBuffer.data != null) {
                    BufferHelper.writeArrayAndColon("Entries", outBuffer, true, error);
                    BufferHelper.beginArray(outBuffer, error);
                    BufferHelper.copyToByteArray(elementListBuffer.data, 0, elementListBuffer.position, outBuffer, error);
                    BufferHelper.endArray(outBuffer, error);
                }
            } else {
                BufferHelper.comma(outBuffer, error);
                if (!this.converter.getContainerHandler(closeMsg.containerType()).encodeJson(decIter, outBuffer, true, null, error)) {
                    return false;
                }
            }
        }
        return error.isSuccessful();
    }

    private int estimateJsonLength(int rwfLength) {
        return rwfLength * 6 + 300;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decodeElementList(JsonBuffer batchStreamIdBuffer, JsonBuffer elementListBuffer, DecodeIterator decIter, int estimatedElementListLength, JsonConverterError error) {
        ElementList elemList = JsonFactory.createElementList();
        ElementEntry elemEntry = JsonFactory.createElementEntry();
        try {
            elemList.clear();
            int ret = elemList.decode(decIter, null);
            if (ret < 0) {
                error.setError(15, "Failed decoding ElementList payload, code = " + ret);
                boolean bl = false;
                return bl;
            }
            boolean listComma = false;
            boolean listRes = true;
            while ((ret = elemEntry.decode(decIter)) != 14) {
                if (ret < 0) {
                    error.setError(15, "Failed decoding ElementEntry of payload, code = " + ret);
                    boolean bl = false;
                    return bl;
                }
                if (elemEntry.name().equals(ElementNames.BATCH_STREAMID_LIST)) {
                    boolean bl = this.getBatchStreamIds(batchStreamIdBuffer, decIter, this.estimateJsonLength(elemEntry.encodedData().length()), error);
                    return bl;
                }
                if (elementListBuffer.data == null) {
                    elementListBuffer.data = new byte[estimatedElementListLength];
                }
                if (listComma) {
                    listRes = listRes && BufferHelper.comma(elementListBuffer, error);
                } else {
                    listComma = true;
                }
                listRes = listRes && this.converter.getContainerHandler(133).writeEntry(decIter, elementListBuffer, null, error, elemEntry, elemList);
                elemEntry.clear();
                elemEntry.decode(decIter);
            }
            boolean bl = listRes;
            return bl;
        }
        finally {
            JsonFactory.releaseElementList(elemList);
            JsonFactory.releaseElementEntry(elemEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getBatchStreamIds(JsonBuffer batchStreamIdBuffer, DecodeIterator decIter, int estimatedLength, JsonConverterError error) {
        Array array = JsonFactory.createArray();
        ArrayEntry arrayEntry = JsonFactory.createArrayEntry();
        Int fid = CodecFactory.createInt();
        try {
            array.clear();
            int ret = array.decode(decIter);
            if (ret < 0) {
                error.setError(15, "Failed decoding Array, code = " + ret);
                boolean bl = false;
                return bl;
            }
            batchStreamIdBuffer.data = new byte[estimatedLength];
            boolean res = BufferHelper.beginArray(batchStreamIdBuffer, error);
            boolean comma = false;
            ret = arrayEntry.decode(decIter);
            while (res && ret != 14) {
                if (ret < 0) {
                    error.setError(15, "Failed decoding ArrayEntry, code = " + ret);
                    boolean bl = false;
                    return bl;
                }
                if (comma) {
                    res = BufferHelper.comma(batchStreamIdBuffer, error);
                } else {
                    comma = true;
                }
                fid.clear();
                ret = fid.decode(decIter);
                if (ret < 0) {
                    error.setError(15, "Failed decoding Int, code = " + ret);
                    boolean bl = false;
                    return bl;
                }
                res = res && BasicPrimitiveConverter.writeLong(fid.toLong(), batchStreamIdBuffer, error);
                arrayEntry.clear();
                ret = arrayEntry.decode(decIter);
            }
            boolean bl = res && BufferHelper.endArray(batchStreamIdBuffer, error);
            return bl;
        }
        finally {
            JsonFactory.releaseArrayEntry(arrayEntry);
            JsonFactory.releaseArray(array);
            JsonFactory.releaseInt(fid);
        }
    }

    private String getMsgClassString(int msgClass) {
        switch (msgClass) {
            case 6: {
                return "Ack";
            }
            case 5: {
                return "Close";
            }
            case 7: {
                return "Generic";
            }
            case 8: {
                return "Post";
            }
            case 1: {
                return "Request";
            }
            case 2: {
                return "Refresh";
            }
            case 3: {
                return "Status";
            }
            case 4: {
                return "Update";
            }
        }
        return null;
    }

    private String getDomainString(int domainType) {
        switch (domainType) {
            case 1: {
                return "Login";
            }
            case 4: {
                return "Source";
            }
            case 5: {
                return "Dictionary";
            }
            case 6: {
                return "MarketPrice";
            }
            case 7: {
                return "MarketByOrder";
            }
            case 8: {
                return "MarketByPrice";
            }
            case 9: {
                return "MarketMaker";
            }
            case 10: {
                return "SymbolList";
            }
            case 11: {
                return "ServiceProviderStatus";
            }
            case 12: {
                return "History";
            }
            case 13: {
                return "Headline";
            }
            case 14: {
                return "Story";
            }
            case 15: {
                return "ReplayHeadline";
            }
            case 16: {
                return "ReplayStory";
            }
            case 17: {
                return "Transaction";
            }
            case 22: {
                return "YieldCurve";
            }
            case 27: {
                return "Contribution";
            }
            case 29: {
                return "ProviderAdmin";
            }
            case 30: {
                return "Analytics";
            }
            case 31: {
                return "Reference";
            }
            case 33: {
                return "NewsTextAnalytics";
            }
            case 34: {
                return "EconomicIndicator";
            }
            case 35: {
                return "Poll";
            }
            case 36: {
                return "Forecast";
            }
            case 37: {
                return "MarketByTime";
            }
            case 127: {
                return "System";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        block39: {
            block37: {
                block38: {
                    ((Msg)msg).msgClass(5);
                    closeMsg = (CloseMsg)msg;
                    closeMsg.domainType(6);
                    hasId = false;
                    batchClose = false;
                    extendedHeaderBuffer = null;
                    permDataBuffer = null;
                    try {
                        it = node.fieldNames();
                        while (it.hasNext()) {
                            key = (String)it.next();
                            currentNode = node.path(key);
                            var12_12 = key;
                            var13_13 = -1;
                            switch (var12_12.hashCode()) {
                                case 2331: {
                                    if (!var12_12.equals("ID")) break;
                                    var13_13 = 0;
                                    break;
                                }
                                case 2622298: {
                                    if (!var12_12.equals("Type")) break;
                                    var13_13 = 1;
                                    break;
                                }
                                case 2052636900: {
                                    if (!var12_12.equals("Domain")) break;
                                    var13_13 = 2;
                                    break;
                                }
                                case 56304919: {
                                    if (!var12_12.equals("Elements")) break;
                                    var13_13 = 3;
                                    break;
                                }
                                case 2104126169: {
                                    if (!var12_12.equals("Fields")) break;
                                    var13_13 = 4;
                                    break;
                                }
                                case 440160342: {
                                    if (!var12_12.equals("FilterList")) break;
                                    var13_13 = 5;
                                    break;
                                }
                                case 77116: {
                                    if (!var12_12.equals("Map")) break;
                                    var13_13 = 6;
                                    break;
                                }
                                case -1675388953: {
                                    if (!var12_12.equals("Message")) break;
                                    var13_13 = 7;
                                    break;
                                }
                                case -1736520349: {
                                    if (!var12_12.equals("Vector")) break;
                                    var13_13 = 8;
                                    break;
                                }
                                case 2318600: {
                                    if (!var12_12.equals("Json")) break;
                                    var13_13 = 9;
                                    break;
                                }
                                case 88055: {
                                    if (!var12_12.equals("Xml")) break;
                                    var13_13 = 10;
                                    break;
                                }
                                case -1926827967: {
                                    if (!var12_12.equals("Opaque")) break;
                                    var13_13 = 11;
                                    break;
                                }
                                case -1821971817: {
                                    if (!var12_12.equals("Series")) break;
                                    var13_13 = 12;
                                    break;
                                }
                                case 65641: {
                                    if (!var12_12.equals("Ack")) break;
                                    var13_13 = 13;
                                    break;
                                }
                                case 2089762101: {
                                    if (!var12_12.equals("ExtHdr")) break;
                                    var13_13 = 14;
                                    break;
                                }
                            }
                            switch (var13_13) {
                                case 0: {
                                    if (currentNode.isInt()) {
                                        closeMsg.streamId(this.getInt(currentNode, key, error));
                                        hasId = true;
                                        break;
                                    }
                                    if (currentNode.isArray()) {
                                        if (currentNode.get(0).isInt()) {
                                            closeMsg.streamId(currentNode.get(0).asInt());
                                        } else {
                                            error.setError(4, "Expected integer for IDs array, found " + currentNode.getNodeType().toString());
                                        }
                                        batchClose = true;
                                        break;
                                    }
                                    error.setError(4, "Expected integer or array type for ID, found " + currentNode.getNodeType().toString());
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    this.checkStringOrInt(currentNode, key, error);
                                    if (error.isFailed()) break;
                                    if (currentNode.isTextual()) {
                                        closeMsg.domainType(ConstCharArrays.JsonDomain.ofValue(this.getText(currentNode, key, error), error));
                                        break;
                                    }
                                    closeMsg.domainType(this.getInt(currentNode, key, error));
                                    break;
                                }
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: {
                                    if (batchClose) break;
                                    closeMsg.containerType(this.converter.getContainerDataType(key, currentNode, error));
                                    break;
                                }
                                case 13: {
                                    if (!this.getBoolean(currentNode, key, error)) break;
                                    closeMsg.applyAck();
                                    break;
                                }
                                case 14: {
                                    closeMsg.applyHasExtendedHdr();
                                    extendedHeaderBuffer = JsonFactory.createBuffer();
                                    BufferConverter.decodeFromBase64(this.getText(currentNode, key, error), extendedHeaderBuffer, error);
                                    if (error.isFailed()) break;
                                    closeMsg.extendedHeader(extendedHeaderBuffer);
                                    break;
                                }
                                default: {
                                    this.processUnexpectedKey(key, error);
                                }
                            }
                            if (!error.isFailed()) continue;
                            if (extendedHeaderBuffer == null) break block37;
                            break block38;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var14_14) {
                        if (extendedHeaderBuffer != null) {
                            JsonFactory.releaseBuffer(extendedHeaderBuffer);
                        }
                        if (permDataBuffer == null) throw var14_14;
                        JsonFactory.releaseBuffer(permDataBuffer);
                        throw var14_14;
                    }
                }
                JsonFactory.releaseBuffer(extendedHeaderBuffer);
            }
            if (permDataBuffer == null) return;
            JsonFactory.releaseBuffer(permDataBuffer);
            return;
lbl-1000:
            // 1 sources

            {
                if (!hasId && !batchClose) {
                    error.setError(12, "ID");
                }
                if (batchClose) {
                    closeMsg.containerType(133);
                }
                if (extendedHeaderBuffer == null) break block39;
            }
            JsonFactory.releaseBuffer(extendedHeaderBuffer);
        }
        if (permDataBuffer == null) return;
        JsonFactory.releaseBuffer(permDataBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encodeRWF(JsonNode dataNode, String key, Msg msg, EncodeIterator iter, JsonConverterError error) {
        int result = 0;
        JsonNode idNode = dataNode.path("ID");
        if (idNode.isInt()) {
            super.encodeRWF(dataNode, key, msg, iter, error);
        } else if (idNode.isArray() && idNode.size() > 0) {
            msg.containerType(133);
            result = msg.encodeInit(iter, 0);
            if (result < 0) {
                error.setEncodeError(result, "msg [" + msg.msgClass() + "] encode");
                return;
            }
            ElementList elemList = JsonFactory.createElementList();
            ElementEntry elemEntry = JsonFactory.createElementEntry();
            Array array = JsonFactory.createArray();
            ArrayEntry arrayEntry = JsonFactory.createArrayEntry();
            Int iv = JsonFactory.createInt();
            elemList.clear();
            elemEntry.clear();
            array.clear();
            arrayEntry.clear();
            try {
                elemList.applyHasStandardData();
                result = elemList.encodeInit(iter, null, 0);
                if (result < 0) {
                    error.setEncodeError(result, "msg [" + msg.msgClass() + "] encode");
                    return;
                }
                elemEntry.name(ElementNames.BATCH_STREAMID_LIST);
                elemEntry.dataType(15);
                result = elemEntry.encodeInit(iter, 0);
                if (result < 0) {
                    error.setEncodeError(result, "msg [" + msg.msgClass() + "] encode");
                    return;
                }
                array.primitiveType(3);
                result = array.encodeInit(iter);
                if (result < 0) {
                    error.setEncodeError(result, "msg [" + msg.msgClass() + "] encode");
                    return;
                }
                for (int i = 0; i < idNode.size(); ++i) {
                    iv.clear();
                    this.converter.getPrimitiveHandler(3).decodeJson(idNode.get(i), iv, error);
                    if (error.isFailed()) {
                        return;
                    }
                    arrayEntry.clear();
                    result = arrayEntry.encode(iter, iv);
                    if (result >= 0) continue;
                    error.setEncodeError(result, "msg [" + msg.msgClass() + "] encode");
                    return;
                }
                result = array.encodeComplete(iter, true);
                if (result < 0) {
                    error.setEncodeError(result, "msg [" + msg.msgClass() + "] encode");
                    return;
                }
                result = elemEntry.encodeComplete(iter, true);
                if (result < 0) {
                    error.setEncodeError(result, "msg [" + msg.msgClass() + "] encode");
                    return;
                }
                result = elemList.encodeComplete(iter, true);
                if (result < 0) {
                    error.setEncodeError(result, "msg [" + msg.msgClass() + "] encode");
                    return;
                }
            }
            finally {
                JsonFactory.releaseElementList(elemList);
                JsonFactory.releaseElementEntry(elemEntry);
                JsonFactory.releaseArrayEntry(arrayEntry);
                JsonFactory.releaseArray(array);
                JsonFactory.releaseInt(iv);
            }
            result = msg.encodeComplete(iter, error.isSuccessful());
        }
        if (error.isFailed()) {
            return;
        }
        if (result < 0) {
            error.setEncodeError(result, "msg encode complete");
            return;
        }
    }
}

