/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.json.converter.AbstractPrimitiveTypeConverter;
import com.refinitiv.eta.json.converter.BufferConverter;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;
import java.nio.ByteBuffer;
import java.util.Base64;

class JsonBufferConverter
extends AbstractPrimitiveTypeConverter {
    JsonBufferConverter(JsonAbstractConverter converter) {
        super(converter);
        this.dataTypes = new int[]{16};
    }

    @Override
    Object getPrimitiveType() {
        return JsonFactory.createBuffer();
    }

    @Override
    void releasePrimitiveType(Object type) {
        JsonFactory.releaseBuffer((Buffer)type);
    }

    @Override
    int decode(DecodeIterator decIter, Object type) {
        Buffer buffer = (Buffer)type;
        buffer.clear();
        return buffer.decode(decIter);
    }

    @Override
    boolean writeToJson(JsonBuffer outBuffer, Object type, JsonConverterError error) {
        return BufferConverter.writeToJson((Buffer)type, outBuffer, error);
    }

    @Override
    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        Buffer inBuffer = (Buffer)msg;
        inBuffer.clear();
        if (node.isNull()) {
            return;
        }
        try {
            byte[] bytes = Base64.getDecoder().decode(node.textValue());
            inBuffer.data(ByteBuffer.wrap(bytes));
        }
        catch (Exception e) {
            error.setError(4, "Failed decoding buffer: " + node.asText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encodeRWF(JsonNode dataNode, String key, EncodeIterator iter, JsonConverterError error) {
        Buffer encBufferValue = JsonFactory.createBuffer();
        try {
            int result;
            this.decodeJson(dataNode, encBufferValue, error);
            if (error.isSuccessful() && (result = encBufferValue.encode(iter)) != 0) {
                error.setEncodeError(result, key);
            }
        }
        finally {
            JsonFactory.releaseBuffer(encBufferValue);
        }
    }
}

