/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.json.converter.JsonConverterError;

class ConstCharArrays {
    public static final String blankStringConst = new String(new byte[]{0});
    public static final Buffer emptyBuffer = CodecFactory.createBuffer();
    public static final char[] nullBytes;
    public static final String nullString = "null";
    public static final String trueString = "true";
    public static final String falseString = "false";
    public static final char[] digits;
    public static final char[] minInt;
    public static final char[] minLong;
    public static final String jsonDoublePositiveInfinityStr = "Inf";
    public static final String jsonDoubleNegativeInfinityStr = "-Inf";
    public static final String jsonDoubleNanStr = "NaN";
    public static final char[] inf;
    public static final char[] infNeg;
    public static final char[] nan;
    public static final char[] safeQuote;
    public static final char[] safeBackslash;
    public static final String JSON_ID = "ID";
    public static final String JSON_TYPE = "Type";
    public static final String JSON_DOMAIN = "Domain";
    public static final String JSON_EXTHDR = "ExtHdr";
    public static final String JSON_DATA = "Data";
    public static final String JSON_KEY = "Key";
    public static final String JSON_REQKEY = "ReqKey";
    public static final String JSON_KEY_NAME = "Name";
    public static final String JSON_KEY_NAME_TYPE = "NameType";
    public static final String JSON_KEY_FILTER = "Filter";
    public static final String JSON_KEY_IDENTIFIER = "Identifier";
    public static final String JSON_KEY_SERVICE = "Service";
    public static final String JSON_ELEMENTS = "Elements";
    public static final String JSON_ELEMENTLIST = "ElementList";
    public static final String JSON_FILTERLIST = "FilterList";
    public static final String JSON_OPAQUE = "Opaque";
    public static final String JSON_XML = "Xml";
    public static final String JSON_JSON = "Json";
    public static final String JSON_NAME = "Name";
    public static final String JSON_ANSI = "AnsiPage";
    public static final String JSON_VIEW = "View";
    public static final String JSON_VIEW_NAME_LIST = "NameList";
    public static final String JSON_VIEW_FID_LIST = "FidList";
    public static final String JSON_PRIVATE = "Private";
    public static final String JSON_VIEWTYPE = "ViewType";
    public static final String JSON_STREAMING = "Streaming";
    public static final String JSON_PAUSE = "Pause";
    public static final String JSON_REFRESH = "Refresh";
    public static final String JSON_KEYINUPDATES = "KeyInUpdates";
    public static final String JSON_CONFINFOINUPDATES = "ConfInfoInUpdates";
    public static final String JSON_QUALIFIED = "Qualified";
    public static final String JSON_COMPLETE = "Complete";
    public static final String JSON_DONOTCACHE = "DoNotCache";
    public static final String JSON_POSTUSERINFO = "PostUserInfo";
    public static final String JSON_ADDRESS = "Address";
    public static final String JSON_USERID = "UserID";
    public static final String JSON_PARTNUMBER = "PartNumber";
    public static final String JSON_CLEARCACHE = "ClearCache";
    public static final String JSON_UPDATETYPE = "UpdateType";
    public static final String JSON_DONOTCONFLATE = "DoNotConflate";
    public static final String JSON_DONOTRIPPLE = "DoNotRipple";
    public static final String JSON_DISCARDABLE = "Discardable";
    public static final String JSON_PERMDATA = "PermData";
    public static final String JSON_SEQNUM = "SeqNumber";
    public static final String JSON_SECSEQNUM = "SecSeqNumber";
    public static final String JSON_CONFINFO = "ConflationInfo";
    public static final String JSON_PROVIDER_DRIVEN = "ProviderDriven";
    public static final String JSON_QOS = "Qos";
    public static final String JSON_WORSTQOS = "WorstQos";
    public static final String JSON_TIMELINESS = "Timeliness";
    public static final String JSON_RATE = "Rate";
    public static final String JSON_DYNAMIC = "Dynamic";
    public static final String JSON_TIMEINFO = "TimeInfo";
    public static final String JSON_RATEINFO = "RateInfo";
    public static final String JSON_PRIORITY = "Priority";
    public static final String JSON_CLASS = "Class";
    public static final String JSON_COUNT = "Count";
    public static final String JSON_TIME = "Time";
    public static final String JSON_LENGTH = "Length";
    public static final String JSON_FIELDS = "Fields";
    public static final String JSON_FIELDLIST = "FieldList";
    public static final String JSON_STATE = "State";
    public static final String JSON_STREAM = "Stream";
    public static final String JSON_CODE = "Code";
    public static final String JSON_TEXT = "Text";
    public static final String JSON_ENTRIES = "Entries";
    public static final String JSON_COUNTHINT = "CountHint";
    public static final String JSON_ACTION = "Action";
    public static final String JSON_SET = "Set";
    public static final String JSON_CLEAR = "Clear";
    public static final String JSON_MAP = "Map";
    public static final String JSON_SUMMARY = "Summary";
    public static final String JSON_HASPERMDATA = "HasPermData";
    public static final String JSON_KEYTYPE = "KeyType";
    public static final String JSON_KEYFIELDID = "KeyFieldID";
    public static final String JSON_SERIES = "Series";
    public static final String JSON_VECTOR = "Vector";
    public static final String JSON_DATATYPE = "DataType";
    public static final String JSON_ACK = "Ack";
    public static final String JSON_POSTUSERRIGHTS = "PostUserRights";
    public static final String JSON_NONE = "None";
    public static final String JSON_CREATE = "Create";
    public static final String JSON_MODIFYPERM = "ModifyPerm";
    public static final String JSON_SOLICITED = "Solicited";
    public static final String JSON_POSTID = "PostID";
    public static final String JSON_ACKID = "AckID";
    public static final String JSON_NAKCODE = "NakCode";
    public static final String JSON_MESSAGE = "Message";
    public static final String JSON_INDEX = "Index";
    public static final String JSON_SUPPORTSORTING = "SupportSorting";
    public static final String PING = "Ping";
    public static final String PONG = "Pong";
    public static final String JSON_ERROR = "Error";
    public static final String JSON_STRING = "String";
    public static final String JSON_PRIMITIVE = "Primitive";
    public static final String JSON_DEBUG = "Debug";
    public static final String JSON_FILE = "File";
    public static final String JSON_LINE = "Line";
    public static final String JSON_OFFSET = "Offset";
    public static final String JSON_RDM_OMMSTR_LOGIN_USER_AUTHENTICATION_TOKEN = "AuthnToken";
    public static final String STATE_CODE_STR_NONE = "None";
    public static final String STATE_CODE_STR_NOT_FOUND = "NotFound";
    public static final String STATE_CODE_STR_TIMEOUT = "Timeout";
    public static final String STATE_CODE_STR_NOT_ENTITLED = "NotEntitled";
    public static final String STATE_CODE_STR_INVALID_ARGUMENT = "InvalidArgument";
    public static final String STATE_CODE_STR_USAGE_ERROR = "UsageError";
    public static final String STATE_CODE_STR_PREEMPTED = "Preempted";
    public static final String STATE_CODE_STR_JIT_CONFLATION_STARTED = "JitConflationStarted";
    public static final String STATE_CODE_STR_REALTIME_RESUMED = "RealtimeResumed";
    public static final String STATE_CODE_STR_FAILOVER_STARTED = "FailoverStarted";
    public static final String STATE_CODE_STR_FAILOVER_COMPLETED = "FailoverCompleted";
    public static final String STATE_CODE_STR_GAP_DETECTED = "GapDetected";
    public static final String STATE_CODE_STR_NO_RESOURCES = "NoResources";
    public static final String STATE_CODE_STR_TOO_MANY_ITEMS = "TooManyItems";
    public static final String STATE_CODE_STR_ALREADY_OPEN = "AlreadyOpen";
    public static final String STATE_CODE_STR_SOURCE_UNKNOWN = "SourceUnknown";
    public static final String STATE_CODE_STR_NOT_OPEN = "NotOpen";
    public static final String STATE_CODE_STR_NON_UPDATING_ITEM = "NonUpdatingItem";
    public static final String STATE_CODE_STR_UNSUPPORTED_VIEW_TYPE = "UnsupportedViewType";
    public static final String STATE_CODE_STR_INVALID_VIEW = "InvalidView";
    public static final String STATE_CODE_STR_FULL_VIEW_PROVIDED = "FullViewProvided";
    public static final String STATE_CODE_STR_UNABLE_TO_REQUEST_AS_BATCH = "UnableToRequestAsBatch";
    public static final String STATE_CODE_STR_NO_BATCH_VIEW_SUPPORT_IN_REQ = "NoBatchViewSupportInReq";
    public static final String STATE_CODE_STR_EXCEEDED_MAX_MOUNTS_PER_USER = "ExceededMaxMountsPerUser";
    public static final String STATE_CODE_STR_ERROR = "Error";
    public static final String STATE_CODE_STR_DACS_DOWN = "DacsDown";
    public static final String STATE_CODE_STR_USER_UNKNOWN_TO_PERM_SYS = "UserUnknownToPermSys";
    public static final String STATE_CODE_STR_DACS_MAX_LOGINS_REACHED = "MaxLoginsReached";
    public static final String STATE_CODE_STR_DACS_USER_ACCESS_TO_APP_DENIED = "UserAccessToAppDenied";
    public static final String STATE_CODE_STR_GAP_FILL = "GapFill";
    public static final String STATE_CODE_STR_APP_AUTHORIZATION_FAILED = "AppAuthorizationFailed";
    public static final String[] stateCodesString;
    public static final String QOS_T9S_STR_UNSPECIFIED = "Unspecified";
    public static final String QOS_T9S_STR_REALTIME = "Realtime";
    public static final String QOS_T9S_STR_DELAYED_BY_UNKNOWN = "DelayedUnknown";
    public static final String QOS_T9S_STR_DELAYED_BY_TIME_INFO = "Delayed";
    public static final String[] qosTimelinessStrings;
    public static final String QOS_RATE_STR_UNSPECIFIED = "Unspecified";
    public static final String QOS_RATE_STR_TICK_BY_TICK = "TickByTick";
    public static final String QOS_RATE_STR_JUST_IN_TIME_CONFLATED = "JitConflated";
    public static final String QOS_RATE_STR_CONFLATED_BY_RATE_INFO = "TimeConflated";
    public static final String[] qosRateStrings;
    public static final String NAME_TYPE_STR_UNSPECIFIED = "Unspecified";
    public static final String NAME_TYPE_STR_RIC = "Ric";
    public static final String NAME_TYPE_STR_CONTRIBUTOR = "Contributor";
    public static final String LOGIN_USER_NAME = "Name";
    public static final String LOGIN_USER_EMAIL_ADDRESS = "EmailAddress";
    public static final String LOGIN_USER_TOKEN = "Token";
    public static final String LOGIN_USER_COOKIE = "Cookie";
    public static final String LOGIN_USER_AUTHENTICATION_TOKEN = "AuthnToken";
    public static final String DOMAIN_STR_LOGIN = "Login";
    public static final String DOMAIN_STR_SOURCE = "Source";
    public static final String DOMAIN_STR_DICTIONARY = "Dictionary";
    public static final String DOMAIN_STR_MARKET_PRICE = "MarketPrice";
    public static final String DOMAIN_STR_MARKET_BY_ORDER = "MarketByOrder";
    public static final String DOMAIN_STR_MARKET_BY_PRICE = "MarketByPrice";
    public static final String DOMAIN_STR_MARKET_MAKER = "MarketMaker";
    public static final String DOMAIN_STR_SYMBOL_LIST = "SymbolList";
    public static final String DOMAIN_STR_SERVICE_PROVIDER_STATUS = "ServiceProviderStatus";
    public static final String DOMAIN_STR_HISTORY = "History";
    public static final String DOMAIN_STR_HEADLINE = "Headline";
    public static final String DOMAIN_STR_STORY = "Story";
    public static final String DOMAIN_STR_REPLAYHEADLINE = "ReplayHeadline";
    public static final String DOMAIN_STR_REPLAYSTORY = "ReplayStory";
    public static final String DOMAIN_STR_TRANSACTION = "Transaction";
    public static final String DOMAIN_STR_YIELD_CURVE = "YieldCurve";
    public static final String DOMAIN_STR_CONTRIBUTION = "Contribution";
    public static final String DOMAIN_STR_PROVIDER_ADMIN = "ProviderAdmin";
    public static final String DOMAIN_STR_ANALYTICS = "Analytics";
    public static final String DOMAIN_STR_REFERENCE = "Reference";
    public static final String DOMAIN_STR_NEWS_TEXT_ANALYTICS = "NewsTextAnalytics";
    public static final String DOMAIN_STR_ECONOMIC_INDICATOR = "EconomicIndicator";
    public static final String DOMAIN_STR_POLL = "Poll";
    public static final String DOMAIN_STR_FORECAST = "Forecast";
    public static final String DOMAIN_STR_MARKET_BY_TIME = "MarketByTime";
    public static final String DOMAIN_STR_SYSTEM = "System";
    public static final String NAKC_STR_NONE = "None";
    public static final String NAKC_STR_ACCESS_DENIED = "AccessDenied";
    public static final String NAKC_STR_DENIED_BY_SRC = "DeniedBySrc";
    public static final String NAKC_STR_SOURCE_DOWN = "SourceDown";
    public static final String NAKC_STR_SOURCE_UNKNOWN = "SourceUnknown";
    public static final String NAKC_STR_NO_RESOURCES = "NoResources";
    public static final String NAKC_STR_NO_RESPONSE = "NoResponse";
    public static final String NAKC_STR_GATEWAY_DOWN = "GatewayDown";
    public static final String NAKC_STR_SYMBOL_UNKNOWN = "SymbolUnknown";
    public static final String NAKC_STR_NOT_OPEN = "NotOpen";
    public static final String NAKC_STR_INVALID_CONTENT = "InvalidContent";
    public static final String STREAM_STATE_STR_UNSPECIFIED = "Unspecified";
    public static final String STREAM_STATE_STR_OPEN = "Open";
    public static final String STREAM_STATE_STR_NON_STREAMING = "NonStreaming";
    public static final String STREAM_STATE_STR_CLOSED_RECOVER = "ClosedRecover";
    public static final String STREAM_STATE_STR_CLOSED = "Closed";
    public static final String STREAM_STATE_STR_REDIRECTED = "Redirected";
    public static final String[] streamStateStrings;
    public static final String UPD_EVENT_TYPE_UNSPECIFIED = "Unspecified";
    public static final String UPD_EVENT_TYPE_QUOTE = "Quote";
    public static final String UPD_EVENT_TYPE_TRADE = "Trade";
    public static final String UPD_EVENT_TYPE_NEWS_ALERT = "NewsAlert";
    public static final String UPD_EVENT_TYPE_VOLUME_ALERT = "VolumeAlert";
    public static final String UPD_EVENT_TYPE_ORDER_INDICATION = "OrderIndication";
    public static final String UPD_EVENT_TYPE_CLOSING_RUN = "ClosingRun";
    public static final String UPD_EVENT_TYPE_CORRECTION = "Correction";
    public static final String UPD_EVENT_TYPE_MARKET_DIGEST = "MarketDigest";
    public static final String UPD_EVENT_TYPE_QUOTES_TRADE = "QuotesTrade";
    public static final String UPD_EVENT_TYPE_MULTIPLE = "Multiple";
    public static final String UPD_EVENT_TYPE_VERIFY = "Verify";
    public static final String NAKC_NONE = "None";
    public static final String NAKC_ACCESS_DENIED = "AccessDenied";
    public static final String NAKC_DENIED_BY_SRC = "DeniedBySrc";
    public static final String NAKC_SOURCE_DOWN = "SourceDown";
    public static final String NAKC_SOURCE_UNKNOWN = "SourceUnknown";
    public static final String NAKC_NO_RESOURCES = "NoResources";
    public static final String NAKC_NO_RESPONSE = "NoResponse";
    public static final String NAKC_GATEWAY_DOWN = "GatewayDown";
    public static final String NAKC_SYMBOL_UNKNOWN = "SymbolUnknown";
    public static final String NAKC_NOT_OPEN = "NotOpen";
    public static final String NAKC_INVALID_CONTENT = "InvalidContent";
    public static final String DATA_STATE_STR_NO_CHANGE = "NoChange";
    public static final String DATA_STATE_STR_OK = "Ok";
    public static final String DATA_STATE_STR_SUSPECT = "Suspect";
    public static final String[] dataStateStrings;
    public static final String DATA_TYPE_STR_UNKNOWN = "Unknown";
    public static final String DATA_TYPE_STR_INT = "Int";
    public static final String DATA_TYPE_STR_UINT = "UInt";
    public static final String DATA_TYPE_STR_FLOAT = "Float";
    public static final String DATA_TYPE_STR_DOUBLE = "Double";
    public static final String DATA_TYPE_STR_REAL = "Real";
    public static final String DATA_TYPE_STR_DATE = "Date";
    public static final String DATA_TYPE_STR_TIME = "Time";
    public static final String DATA_TYPE_STR_DATE_TIME = "DateTime";
    public static final String DATA_TYPE_STR_QOS = "Qos";
    public static final String DATA_TYPE_STR_STATE = "State";
    public static final String DATA_TYPE_STR_ENUM = "Enum";
    public static final String DATA_TYPE_STR_ARRAY = "Array";
    public static final String DATA_TYPE_STR_BUFFER = "Buffer";
    public static final String DATA_TYPE_STR_ASCII_STRING = "AsciiString";
    public static final String DATA_TYPE_STR_UTF_8_STRING = "Utf8String";
    public static final String DATA_TYPE_STR_RMTES_STRING = "RmtesString";
    public static final String DATA_TYPE_STR_INT_1 = "Int1";
    public static final String DATA_TYPE_STR_UINT_1 = "UInt1";
    public static final String DATA_TYPE_STR_INT_2 = "Int2";
    public static final String DATA_TYPE_STR_UINT_2 = "UInt2";
    public static final String DATA_TYPE_STR_INT_4 = "Int4";
    public static final String DATA_TYPE_STR_UINT_4 = "UInt4";
    public static final String DATA_TYPE_STR_INT_8 = "Int8";
    public static final String DATA_TYPE_STR_UINT_8 = "UInt8";
    public static final String DATA_TYPE_STR_FLOAT_4 = "Float4";
    public static final String DATA_TYPE_STR_DOUBLE_8 = "Double8";
    public static final String DATA_TYPE_STR_REAL_4_RB = "Real4RB";
    public static final String DATA_TYPE_STR_REAL_8_RB = "Real8RB";
    public static final String DATA_TYPE_STR_DATE_4 = "Date4";
    public static final String DATA_TYPE_STR_TIME_3 = "Time3";
    public static final String DATA_TYPE_STR_TIME_5 = "Time5";
    public static final String DATA_TYPE_STR_DATE_TIME_7 = "DateTime7";
    public static final String DATA_TYPE_STR_DATE_TIME_9 = "DateTime9";
    public static final String DATA_TYPE_STR_DATE_TIME_11 = "DateTime11";
    public static final String DATA_TYPE_STR_DATE_TIME_12 = "DateTime12";
    public static final String DATA_TYPE_STR_TIME_7 = "Time7";
    public static final String DATA_TYPE_STR_TIME_8 = "Time8";
    public static final String DATA_TYPE_STR_NO_DATA = "NoData";
    public static final String DATA_TYPE_STR_OPAQUE = "Opaque";
    public static final String DATA_TYPE_STR_XML = "Xml";
    public static final String DATA_TYPE_STR_FIELD_LIST = "FieldList";
    public static final String DATA_TYPE_STR_ELEMENT_LIST = "ElementList";
    public static final String DATA_TYPE_STR_ANSI_PAGE = "AnsiPage";
    public static final String DATA_TYPE_STR_FILTER_LIST = "FilterList";
    public static final String DATA_TYPE_STR_VECTOR = "Vector";
    public static final String DATA_TYPE_STR_MAP = "Map";
    public static final String DATA_TYPE_STR_SERIES = "Series";
    public static final String DATA_TYPE_STR_MSG = "Msg";
    public static final String DATA_TYPE_STR_JSON = "Json";
    public static final int INT_1_SHIFT = 44;
    public static final int OPAQUE_SHIFT = 87;
    public static final int NO_DATA_POSITION = 41;
    public static final String[] dataTypeStrings;
    public static final String UPD_EVENT_TYPE_STR_UNSPECIFIED = "Unspecified";
    public static final String UPD_EVENT_TYPE_STR_QUOTE = "Quote";
    public static final String UPD_EVENT_TYPE_STR_TRADE = "Trade";
    public static final String UPD_EVENT_TYPE_STR_NEWS_ALERT = "NewsAlert";
    public static final String UPD_EVENT_TYPE_STR_VOLUME_ALERT = "VolumeAlert";
    public static final String UPD_EVENT_TYPE_STR_ORDER_INDICATION = "OrderIndication";
    public static final String UPD_EVENT_TYPE_STR_CLOSING_RUN = "ClosingRun";
    public static final String UPD_EVENT_TYPE_STR_CORRECTION = "Correction";
    public static final String UPD_EVENT_TYPE_STR_MARKET_DIGEST = "MarketDigest";
    public static final String UPD_EVENT_TYPE_STR_QUOTES_TRADE = "QuotesTrade";
    public static final String UPD_EVENT_TYPE_STR_MULTIPLE = "Multiple";
    public static final String UPD_EVENT_TYPE_STR_VERIFY = "Verify";
    public static final String BATCH_REQUEST_NAME_STR = ":ItemList";
    public static final String VIEW_TYPE_STR = ":ViewType";
    public static final String VIEW_NAME_STR = ":ViewData";
    public static final String ACTION_STR_UPDATE = "Update";
    public static final String ACTION_STR_ADD = "Add";
    public static final String ACTION_STR_CLEAR = "Clear";
    public static final String ACTION_STR_INSERT = "Insert";
    public static final String ACTION_STR_DELETE = "Delete";
    public static final String ACTION_STR_SET = "Set";
    public static final String[] entryActionStrings;
    public static final String[] mapEntryActionStrings;
    public static final String[] containerTypes;
    public static final String MC_REQUEST = "Request";
    public static final String MC_REFRESH = "Refresh";
    public static final String MC_STATUS = "Status";
    public static final String MC_UPDATE = "Update";
    public static final String MC_CLOSE = "Close";
    public static final String MC_ACK = "Ack";
    public static final String MC_GENERIC = "Generic";
    public static final String MC_POST = "Post";
    public static final String MESSAGE_START = "{\"ID\":";

    ConstCharArrays() {
    }

    static {
        emptyBuffer.data(blankStringConst);
        nullBytes = new char[]{'n', 'u', 'l', 'l'};
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        minInt = new char[]{'-', '2', '1', '4', '7', '4', '8', '3', '6', '4', '8'};
        minLong = new char[]{'-', '9', '2', '2', '3', '3', '7', '2', '0', '3', '6', '8', '5', '4', '7', '7', '5', '8', '0', '8'};
        inf = new char[]{'I', 'n', 'f'};
        infNeg = new char[]{'-', 'I', 'n', 'f'};
        nan = new char[]{'N', 'a', 'N'};
        safeQuote = new char[]{'\\', '\"'};
        safeBackslash = new char[]{'\\', '\\'};
        stateCodesString = new String[]{"None", STATE_CODE_STR_NOT_FOUND, STATE_CODE_STR_TIMEOUT, STATE_CODE_STR_NOT_ENTITLED, STATE_CODE_STR_INVALID_ARGUMENT, STATE_CODE_STR_USAGE_ERROR, STATE_CODE_STR_PREEMPTED, STATE_CODE_STR_JIT_CONFLATION_STARTED, STATE_CODE_STR_REALTIME_RESUMED, STATE_CODE_STR_FAILOVER_STARTED, STATE_CODE_STR_FAILOVER_COMPLETED, STATE_CODE_STR_GAP_DETECTED, "NoResources", STATE_CODE_STR_TOO_MANY_ITEMS, STATE_CODE_STR_ALREADY_OPEN, "SourceUnknown", "NotOpen", "", "", STATE_CODE_STR_NON_UPDATING_ITEM, STATE_CODE_STR_UNSUPPORTED_VIEW_TYPE, STATE_CODE_STR_INVALID_VIEW, STATE_CODE_STR_FULL_VIEW_PROVIDED, STATE_CODE_STR_UNABLE_TO_REQUEST_AS_BATCH, "", "", STATE_CODE_STR_NO_BATCH_VIEW_SUPPORT_IN_REQ, STATE_CODE_STR_EXCEEDED_MAX_MOUNTS_PER_USER, "Error", STATE_CODE_STR_DACS_DOWN, STATE_CODE_STR_USER_UNKNOWN_TO_PERM_SYS, STATE_CODE_STR_DACS_MAX_LOGINS_REACHED, STATE_CODE_STR_DACS_USER_ACCESS_TO_APP_DENIED, STATE_CODE_STR_GAP_FILL, STATE_CODE_STR_APP_AUTHORIZATION_FAILED};
        qosTimelinessStrings = new String[]{"Unspecified", QOS_T9S_STR_REALTIME, QOS_T9S_STR_DELAYED_BY_UNKNOWN, QOS_T9S_STR_DELAYED_BY_TIME_INFO};
        qosRateStrings = new String[]{"Unspecified", QOS_RATE_STR_TICK_BY_TICK, QOS_RATE_STR_JUST_IN_TIME_CONFLATED, QOS_RATE_STR_CONFLATED_BY_RATE_INFO};
        streamStateStrings = new String[]{"Unspecified", STREAM_STATE_STR_OPEN, STREAM_STATE_STR_NON_STREAMING, STREAM_STATE_STR_CLOSED_RECOVER, STREAM_STATE_STR_CLOSED, STREAM_STATE_STR_REDIRECTED};
        dataStateStrings = new String[]{DATA_STATE_STR_NO_CHANGE, DATA_STATE_STR_OK, DATA_STATE_STR_SUSPECT};
        dataTypeStrings = new String[]{DATA_TYPE_STR_UNKNOWN, "", "", DATA_TYPE_STR_INT, DATA_TYPE_STR_UINT, DATA_TYPE_STR_FLOAT, DATA_TYPE_STR_DOUBLE, "", DATA_TYPE_STR_REAL, DATA_TYPE_STR_DATE, "Time", DATA_TYPE_STR_DATE_TIME, "Qos", "State", DATA_TYPE_STR_ENUM, DATA_TYPE_STR_ARRAY, DATA_TYPE_STR_BUFFER, DATA_TYPE_STR_ASCII_STRING, DATA_TYPE_STR_UTF_8_STRING, DATA_TYPE_STR_RMTES_STRING, DATA_TYPE_STR_INT_1, DATA_TYPE_STR_UINT_1, DATA_TYPE_STR_INT_2, DATA_TYPE_STR_UINT_2, DATA_TYPE_STR_INT_4, DATA_TYPE_STR_UINT_4, DATA_TYPE_STR_INT_8, DATA_TYPE_STR_UINT_8, DATA_TYPE_STR_FLOAT_4, DATA_TYPE_STR_DOUBLE_8, DATA_TYPE_STR_REAL_4_RB, DATA_TYPE_STR_REAL_8_RB, DATA_TYPE_STR_DATE_4, DATA_TYPE_STR_TIME_3, DATA_TYPE_STR_TIME_5, DATA_TYPE_STR_DATE_TIME_7, DATA_TYPE_STR_DATE_TIME_9, DATA_TYPE_STR_DATE_TIME_11, DATA_TYPE_STR_DATE_TIME_12, DATA_TYPE_STR_TIME_7, DATA_TYPE_STR_TIME_8, DATA_TYPE_STR_NO_DATA, "", "Opaque", "Xml", "FieldList", "ElementList", "AnsiPage", "FilterList", "Vector", "Map", "Series", "", "", DATA_TYPE_STR_MSG, "Json"};
        entryActionStrings = new String[]{"Update", "Set", "Clear", ACTION_STR_INSERT, ACTION_STR_DELETE};
        mapEntryActionStrings = new String[]{"Update", ACTION_STR_ADD, ACTION_STR_DELETE};
        containerTypes = new String[]{"Opaque", "Xml", JSON_FIELDS, JSON_ELEMENTS, "AnsiPage", "FilterList", "Vector", "Map", "Series", DATA_TYPE_STR_MSG, "Json"};
    }

    public static class JsonUpdateType {
        public static int ofValue(String updateTypeStr, JsonConverterError error) {
            switch (updateTypeStr) {
                case "Unspecified": {
                    return 0;
                }
                case "Quote": {
                    return 1;
                }
                case "Trade": {
                    return 2;
                }
                case "NewsAlert": {
                    return 3;
                }
                case "VolumeAlert": {
                    return 4;
                }
                case "OrderIndication": {
                    return 5;
                }
                case "ClosingRun": {
                    return 6;
                }
                case "Correction": {
                    return 7;
                }
                case "MarketDigest": {
                    return 8;
                }
                case "QuotesTrade": {
                    return 9;
                }
                case "Multiple": {
                    return 10;
                }
                case "Verify": {
                    return 11;
                }
            }
            error.setError(4, "Update type '" + updateTypeStr + "'");
            return 0;
        }
    }

    public static class JsonNackCode {
        public static int ofValue(String nackCodeStr, JsonConverterError error) {
            switch (nackCodeStr) {
                case "None": {
                    return 0;
                }
                case "AccessDenied": {
                    return 1;
                }
                case "DeniedBySrc": {
                    return 2;
                }
                case "SourceDown": {
                    return 3;
                }
                case "SourceUnknown": {
                    return 4;
                }
                case "NoResources": {
                    return 5;
                }
                case "NoResponse": {
                    return 6;
                }
                case "GatewayDown": {
                    return 7;
                }
                case "SymbolUnknown": {
                    return 10;
                }
                case "NotOpen": {
                    return 11;
                }
                case "InvalidContent": {
                    return 12;
                }
            }
            return 0;
        }
    }

    public static class JsonStreamState {
        public static int ofValue(String codeStr, JsonConverterError error) {
            switch (codeStr) {
                case "Unspecified": {
                    return 0;
                }
                case "Open": {
                    return 1;
                }
                case "NonStreaming": {
                    return 2;
                }
                case "ClosedRecover": {
                    return 3;
                }
                case "Closed": {
                    return 4;
                }
                case "Redirected": {
                    return 5;
                }
            }
            error.setError(4, "State code '" + codeStr + "'");
            return 0;
        }
    }

    public static class JsonDataState {
        public static int ofValue(String codeStr, JsonConverterError error) {
            switch (codeStr) {
                case "Ok": {
                    return 1;
                }
                case "Suspect": {
                    return 2;
                }
                case "NoChange": {
                    return 0;
                }
            }
            error.setError(4, "State code '" + codeStr + "'");
            return 0;
        }
    }

    public static class JsonStateCode {
        public static int ofValue(String codeStr, JsonConverterError error) {
            switch (codeStr) {
                case "AlreadyOpen": {
                    return 14;
                }
                case "AppAuthorizationFailed": {
                    return 35;
                }
                case "DacsDown": {
                    return 29;
                }
                case "Error": {
                    return 28;
                }
                case "ExceededMaxMountsPerUser": {
                    return 27;
                }
                case "FailoverCompleted": {
                    return 10;
                }
                case "FailoverStarted": {
                    return 9;
                }
                case "FullViewProvided": {
                    return 22;
                }
                case "GapDetected": {
                    return 11;
                }
                case "GapFill": {
                    return 34;
                }
                case "InvalidArgument": {
                    return 4;
                }
                case "InvalidView": {
                    return 21;
                }
                case "JitConflationStarted": {
                    return 7;
                }
                case "MaxLoginsReached": {
                    return 31;
                }
                case "NoBatchViewSupportInReq": {
                    return 26;
                }
                case "None": {
                    return 0;
                }
                case "NonUpdatingItem": {
                    return 19;
                }
                case "NoResources": {
                    return 12;
                }
                case "NotEntitled": {
                    return 3;
                }
                case "NotFound": {
                    return 1;
                }
                case "NotOpen": {
                    return 16;
                }
                case "Preempted": {
                    return 6;
                }
                case "RealtimeResumed": {
                    return 8;
                }
                case "SourceUnknown": {
                    return 15;
                }
                case "Timeout": {
                    return 2;
                }
                case "TooManyItems": {
                    return 13;
                }
                case "UnableToRequestAsBatch": {
                    return 23;
                }
                case "UnsupportedViewType": {
                    return 20;
                }
                case "UsageError": {
                    return 5;
                }
                case "UserAccessToAppDenied": {
                    return 32;
                }
                case "UserUnknownToPermSys": {
                    return 30;
                }
            }
            error.setError(4, "State code '" + codeStr + "'");
            return 0;
        }
    }

    public static class JsonDomain {
        public static int ofValue(String domainStr, JsonConverterError error) {
            switch (domainStr) {
                case "Login": {
                    return 1;
                }
                case "Source": {
                    return 4;
                }
                case "Dictionary": {
                    return 5;
                }
                case "MarketPrice": {
                    return 6;
                }
                case "MarketByOrder": {
                    return 7;
                }
                case "MarketByPrice": {
                    return 8;
                }
                case "MarketMaker": {
                    return 9;
                }
                case "SymbolList": {
                    return 10;
                }
                case "ServiceProviderStatus": {
                    return 11;
                }
                case "History": {
                    return 12;
                }
                case "Headline": {
                    return 13;
                }
                case "Story": {
                    return 14;
                }
                case "ReplayHeadline": {
                    return 15;
                }
                case "ReplayStory": {
                    return 16;
                }
                case "Transaction": {
                    return 17;
                }
                case "YieldCurve": {
                    return 22;
                }
                case "Contribution": {
                    return 27;
                }
                case "ProviderAdmin": {
                    return 29;
                }
                case "Analytics": {
                    return 30;
                }
                case "Reference": {
                    return 31;
                }
                case "NewsTextAnalytics": {
                    return 33;
                }
                case "EconomicIndicator": {
                    return 34;
                }
                case "Poll": {
                    return 35;
                }
                case "Forecast": {
                    return 36;
                }
                case "MarketByTime": {
                    return 37;
                }
                case "System": {
                    return 127;
                }
            }
            error.setError(4, "Domain '" + domainStr + "'");
            return 1;
        }
    }

    public static class JsonNameType {
        public static int ofValue(String nameTypeStr, JsonConverterError error) {
            switch (nameTypeStr) {
                case "Unspecified": {
                    return 0;
                }
                case "Ric": {
                    return 1;
                }
                case "Contributor": {
                    return 2;
                }
                case "Name": {
                    return 1;
                }
                case "EmailAddress": {
                    return 2;
                }
                case "Token": {
                    return 3;
                }
                case "Cookie": {
                    return 4;
                }
                case "AuthnToken": {
                    return 5;
                }
            }
            error.setError(4, "NameType ='" + nameTypeStr + "'");
            return 0;
        }
    }

    public static class JsonQosRate {
        public static int ofValue(String rateStr, JsonConverterError error) {
            switch (rateStr) {
                case "Unspecified": {
                    return 0;
                }
                case "TickByTick": {
                    return 1;
                }
                case "JitConflated": {
                    return 2;
                }
                case "TimeConflated": {
                    return 3;
                }
            }
            error.setError(4, "QosRate ='" + rateStr + "'");
            return -1;
        }
    }

    public static class JsonQosTimeliness {
        public static int ofValue(String timelinessStr, JsonConverterError error) {
            switch (timelinessStr) {
                case "Unspecified": {
                    return 0;
                }
                case "Realtime": {
                    return 1;
                }
                case "DelayedUnknown": {
                    return 2;
                }
                case "Delayed": {
                    return 3;
                }
            }
            error.setError(4, "QosTimeliness ='" + timelinessStr + "'");
            return -1;
        }
    }
}

