/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.refinitiv.eta.json.converter.BasicPrimitiveConverter;
import com.refinitiv.eta.json.converter.ConstCharArrays;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;
import java.nio.ByteBuffer;

class BufferHelper {
    private static byte[] intBuffer = new byte[BasicPrimitiveConverter.getIntLengthCompare(-2147483647)];

    BufferHelper() {
    }

    private static int getNewBufLength(int currLen, int elemLen) {
        return currLen * 2 + elemLen;
    }

    static boolean checkAndResize(JsonBuffer buffer, int length, JsonConverterError error) {
        if (buffer.position + length >= buffer.data.length) {
            return BufferHelper.reallocate(buffer, BufferHelper.getNewBufLength(buffer.data.length, length), error);
        }
        return error.isSuccessful();
    }

    static boolean reallocate(JsonBuffer buffer, int newLength, JsonConverterError errorObj) {
        try {
            byte[] tmp = JsonFactory.createByteArray(newLength);
            System.arraycopy(buffer.data, 0, tmp, 0, buffer.position);
            JsonFactory.releaseByteArray(buffer.data);
            buffer.data = tmp;
            return true;
        }
        catch (OutOfMemoryError error) {
            errorObj.setError(16, "Failed to allocate array of length " + newLength);
            return false;
        }
    }

    static boolean copyToByteArray(String value, JsonBuffer buffer, JsonConverterError error) {
        if (BufferHelper.checkAndResize(buffer, value.length(), error)) {
            for (int i = 0; i < value.length(); ++i) {
                buffer.data[buffer.position++] = (byte)value.charAt(i);
            }
            return true;
        }
        return false;
    }

    static void copyToByteArray(char[] value, int start, byte[] buffer) {
        for (int i = 0; i < value.length; ++i) {
            buffer[start + i] = (byte)value[i];
        }
    }

    static boolean copyToByteArray(byte[] value, int start, int length, JsonBuffer buffer, JsonConverterError error) {
        if (BufferHelper.checkAndResize(buffer, length, error)) {
            System.arraycopy(value, start, buffer.data, buffer.position, length);
            buffer.position += length;
            return true;
        }
        return false;
    }

    static void fillZeroes(int length, byte[] buffer, int start) {
        for (int i = start; i < start + length; ++i) {
            buffer[i] = 48;
        }
    }

    static void copyToByteArray(char[] value, JsonBuffer buffer) {
        for (int i = 0; i < value.length; ++i) {
            buffer.data[buffer.position++] = (byte)value[i];
        }
    }

    static void copyToByteArray(byte[] value, JsonBuffer buffer) {
        BufferHelper.copyToByteArray(value, buffer, 0, value.length);
    }

    static void copyToByteArray(byte[] value, JsonBuffer buffer, int position, int length) {
        for (int i = position; i < position + length; ++i) {
            buffer.data[buffer.position++] = value[i];
        }
    }

    public static boolean writeArray(char[] array, JsonBuffer buffer, boolean asString, JsonConverterError error) {
        if (array == null) {
            if (BufferHelper.checkAndResize(buffer, ConstCharArrays.nullBytes.length, error)) {
                BufferHelper.copyToByteArray(ConstCharArrays.nullBytes, buffer);
                return true;
            }
            return false;
        }
        if (BufferHelper.checkAndResize(buffer, asString ? array.length + 2 : array.length, error)) {
            if (asString) {
                buffer.data[buffer.position++] = 34;
            }
            BufferHelper.copyToByteArray(array, buffer);
            if (asString) {
                buffer.data[buffer.position++] = 34;
            }
            return true;
        }
        return false;
    }

    public static boolean writeArray(String array, JsonBuffer buffer, boolean asString, JsonConverterError error) {
        if (array == null) {
            if (BufferHelper.checkAndResize(buffer, ConstCharArrays.nullBytes.length, error)) {
                BufferHelper.copyToByteArray(ConstCharArrays.nullBytes, buffer);
                return true;
            }
            return false;
        }
        if (BufferHelper.checkAndResize(buffer, asString ? array.length() + 2 : array.length(), error)) {
            if (asString) {
                buffer.data[buffer.position++] = 34;
            }
            BufferHelper.copyToByteArray(array, buffer, error);
            if (asString) {
                buffer.data[buffer.position++] = 34;
            }
            return true;
        }
        return false;
    }

    public static boolean writeArray(ByteBuffer array, JsonBuffer buffer, int position, int length, boolean asString, JsonConverterError error) {
        if (array == null) {
            if (BufferHelper.checkAndResize(buffer, ConstCharArrays.nullBytes.length, error)) {
                BufferHelper.copyToByteArray(ConstCharArrays.nullBytes, buffer);
                return true;
            }
            return false;
        }
        if (BufferHelper.checkAndResize(buffer, asString ? array.array().length + 2 : length, error)) {
            if (asString) {
                buffer.data[buffer.position++] = 34;
            }
            BufferHelper.copyToByteArray(array.array(), buffer, position, length);
            if (asString) {
                buffer.data[buffer.position++] = 34;
            }
            return true;
        }
        return false;
    }

    static boolean writeAsciiChar(JsonBuffer outBuffer, char ch, JsonConverterError error) {
        if (BufferHelper.checkAndResize(outBuffer, 1, error)) {
            outBuffer.data[outBuffer.position++] = (byte)ch;
            return true;
        }
        return false;
    }

    public static boolean writeByte(JsonBuffer outBuffer, byte b, JsonConverterError error) {
        if (BufferHelper.checkAndResize(outBuffer, 1, error)) {
            outBuffer.data[outBuffer.position++] = b;
            return true;
        }
        return false;
    }

    static void writeCharAsHex(byte value, JsonBuffer buffer) {
        int end = buffer.position + 5;
        int tmp = value;
        for (int i = 0; i < 4; ++i) {
            buffer.data[end--] = (byte)ConstCharArrays.digits[tmp & 0xF];
            tmp >>= 4;
        }
        buffer.data[end--] = 117;
        buffer.data[end--] = 92;
        buffer.position += 6;
    }

    public static boolean writeCharAsHex0(byte value, JsonBuffer buffer, JsonConverterError error) {
        if (BufferHelper.checkAndResize(buffer, 6, error)) {
            BufferHelper.writeCharAsHex(value, buffer);
            return true;
        }
        return false;
    }

    public static boolean beginObject(JsonBuffer outBuffer, JsonConverterError error) {
        return BufferHelper.writeAsciiChar(outBuffer, '{', error);
    }

    public static boolean endObject(JsonBuffer outBuffer, JsonConverterError error) {
        return BufferHelper.writeAsciiChar(outBuffer, '}', error);
    }

    public static boolean beginArray(JsonBuffer outBuffer, JsonConverterError error) {
        return BufferHelper.writeAsciiChar(outBuffer, '[', error);
    }

    public static boolean endArray(JsonBuffer outBuffer, JsonConverterError error) {
        return BufferHelper.writeAsciiChar(outBuffer, ']', error);
    }

    static boolean colon(JsonBuffer outBuffer, JsonConverterError error) {
        return BufferHelper.writeAsciiChar(outBuffer, ':', error);
    }

    public static boolean comma(JsonBuffer outBuffer, JsonConverterError error) {
        return BufferHelper.writeAsciiChar(outBuffer, ',', error);
    }

    public static boolean doubleQuote(JsonBuffer outBuffer, JsonConverterError error) {
        return BufferHelper.writeAsciiChar(outBuffer, '\"', error);
    }

    public static boolean writeArrayAndColon(char[] array, JsonBuffer buffer, boolean commaBefore, JsonConverterError error) {
        if (BufferHelper.checkAndResize(buffer, commaBefore ? array.length + 4 : array.length + 3, error)) {
            if (commaBefore) {
                buffer.data[buffer.position++] = 44;
            }
            buffer.data[buffer.position++] = 34;
            BufferHelper.copyToByteArray(array, buffer);
            buffer.data[buffer.position++] = 34;
            buffer.data[buffer.position++] = 58;
            return true;
        }
        return false;
    }

    public static boolean writeArrayAndColon(String array, JsonBuffer buffer, boolean commaBefore, JsonConverterError error) {
        if (BufferHelper.checkAndResize(buffer, commaBefore ? array.length() + 4 : array.length() + 3, error)) {
            if (commaBefore) {
                buffer.data[buffer.position++] = 44;
            }
            buffer.data[buffer.position++] = 34;
            BufferHelper.copyToByteArray(array, buffer, error);
            buffer.data[buffer.position++] = 34;
            buffer.data[buffer.position++] = 58;
            return true;
        }
        return false;
    }

    public static boolean writeArrayAndColon(byte[] array, JsonBuffer buffer, boolean commaBefore, JsonConverterError error) {
        if (BufferHelper.checkAndResize(buffer, commaBefore ? array.length + 4 : array.length + 3, error)) {
            if (commaBefore) {
                buffer.data[buffer.position++] = 44;
            }
            buffer.data[buffer.position++] = 34;
            BufferHelper.copyToByteArray(array, buffer);
            buffer.data[buffer.position++] = 34;
            buffer.data[buffer.position++] = 58;
            return true;
        }
        return false;
    }

    public static boolean writeEmptyObject(JsonBuffer outBuffer, JsonConverterError error) {
        if (BufferHelper.checkAndResize(outBuffer, 2, error)) {
            outBuffer.data[outBuffer.position++] = 123;
            outBuffer.data[outBuffer.position++] = 125;
            return true;
        }
        return false;
    }

    public static void composeMessage(byte[] outMessage, int streamId, JsonBuffer encodedJson, JsonConverterError error) {
        int end = "{\"ID\":".length();
        while (encodedJson.data[end++] != 44) {
        }
        for (int i = 0; i < "{\"ID\":".length(); ++i) {
            outMessage[i] = (byte)"{\"ID\":".charAt(i);
        }
        int streamIdLength = BasicPrimitiveConverter.getIntLengthCompare(streamId);
        BasicPrimitiveConverter.writeInt(streamId, streamId > 0 ? streamIdLength : streamIdLength - 1, outMessage, "{\"ID\":".length());
        int start = "{\"ID\":".length() + streamIdLength;
        for (int i = end; i <= encodedJson.position; ++i) {
            outMessage[i - end + start] = encodedJson.data[i - 1];
        }
    }

    public static void replaceStreamId(JsonBuffer buffer, int streamId, JsonConverterError error) {
        int end = "{\"ID\":".length();
        while (buffer.data[end++] != 44) {
        }
        int streamIdLength = BasicPrimitiveConverter.getIntLengthCompare(streamId);
        if (--end - "{\"ID\":".length() == streamIdLength) {
            BasicPrimitiveConverter.writeInt(streamId, streamId > 0 ? streamIdLength : streamIdLength - 1, buffer.data, "{\"ID\":".length());
        } else {
            if (streamIdLength - (end - "{\"ID\":".length()) > 0) {
                for (int i = buffer.position - 1; i >= end; --i) {
                    buffer.data[i + streamIdLength - (end - "{\"ID\":".length())] = buffer.data[i];
                }
            } else {
                for (int i = end; i < buffer.position; ++i) {
                    buffer.data[i + streamIdLength - (end - "{\"ID\":".length())] = buffer.data[i];
                }
            }
            buffer.position += streamIdLength - (end - "{\"ID\":".length());
            BasicPrimitiveConverter.writeInt(streamId, streamId > 0 ? streamIdLength : streamIdLength - 1, buffer.data, "{\"ID\":".length());
        }
    }

    public static int getCurrentStreamIdLength(JsonBuffer buffer, JsonConverterError error) {
        int end = "{\"ID\":".length();
        while (buffer.data[end++] != 44) {
        }
        return end - "{\"ID\":".length() - 1;
    }

    public static void composeMessage(ByteBuffer buffer, int streamId, JsonBuffer jsonBuffer, JsonConverterError error) {
        for (int i = 0; i < "{\"ID\":".length(); ++i) {
            buffer.put((byte)"{\"ID\":".charAt(i));
        }
        int streamIdLength = BasicPrimitiveConverter.getIntLengthCompare(streamId);
        BasicPrimitiveConverter.writeInt(streamId, streamId > 0 ? streamIdLength : streamIdLength - 1, intBuffer, 0);
        buffer.put(intBuffer, 0, streamIdLength);
        int end = "{\"ID\":".length();
        while (jsonBuffer.data[end++] != 44) {
        }
        for (int i = end - 1; i < jsonBuffer.position; ++i) {
            buffer.put(jsonBuffer.data[i]);
        }
    }
}

