/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.RequestMsg;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonConverterError;

abstract class AbstractTypeConverter {
    public static final boolean DEFAULT_BOOLEAN = false;
    public static final int DEFAULT_INT = -1;
    public static final String DEFAULT_TEXT = "";
    protected final JsonAbstractConverter converter;
    public int[] dataTypes;

    AbstractTypeConverter(JsonAbstractConverter converter) {
        this.converter = converter;
    }

    protected void decodeJson(JsonNode node, Object msg, JsonConverterError error) {
        error.setError(100, this.getClass().getCanonicalName());
    }

    void encodeRWF(JsonNode dataNode, String key, EncodeIterator iter, JsonConverterError error) {
        error.setError(100, this.getClass().getCanonicalName());
    }

    boolean getBoolean(JsonNode node, String nodeName, JsonConverterError error) {
        if (node.isObject()) {
            error.setError(3, "token: " + nodeName + " was expected: PRIMITIVE, BOOLEAN, found: OBJECT");
            return false;
        }
        if (node.isBoolean()) {
            return node.booleanValue();
        }
        if (node.isTextual() && node.asText().equals("true")) {
            return true;
        }
        return node.isInt() && node.asInt() == 1;
    }

    String getText(JsonNode node, String nodeName, JsonConverterError error) {
        if (!node.isTextual()) {
            error.setError(3, "token: " + nodeName + " was expected TEXT, found:" + node.getNodeType());
            return DEFAULT_TEXT;
        }
        return node.asText();
    }

    int getInt(JsonNode node, String nodeName, JsonConverterError error) {
        if (!node.isInt()) {
            error.setError(3, "token: " + nodeName + " was expected INT, found:" + node.getNodeType());
            return -1;
        }
        return node.intValue();
    }

    long getLong(JsonNode node, String nodeName, JsonConverterError error) {
        if (node.isInt()) {
            return node.intValue();
        }
        if (node.isLong()) {
            return node.longValue();
        }
        error.setError(3, "token: " + nodeName + " was expected INT or LONG, found:" + node.getNodeType());
        return -1L;
    }

    void checkInt(JsonNode node, String nodeName, JsonConverterError error) {
        if (!node.isInt()) {
            error.setError(3, "token: " + nodeName + " Int was expected, found:" + node.getNodeType());
        }
    }

    void checkStringOrInt(JsonNode node, String nodeName, JsonConverterError error) {
        if (!node.isInt() && !node.isTextual()) {
            error.setError(3, "token: " + nodeName + " String or Int was expected, found:" + node.getNodeType());
        }
    }

    void checkObject(JsonNode node, String nodeName, JsonConverterError error) {
        this.checkObject(node, nodeName, true, error);
    }

    void checkObject(JsonNode node, String nodeName, boolean objectIsExpected, JsonConverterError error) {
        if (objectIsExpected && !node.isObject()) {
            error.setError(3, "token: " + nodeName + " object was expected, found:" + node.getNodeType());
            return;
        }
        if (!objectIsExpected && node.isObject()) {
            error.setError(3, "token: " + nodeName + " object was not expected, found:" + node.getNodeType());
        }
    }

    void checkIpV4Address(String ipv4AddrString, JsonConverterError error) {
        int pos = 0;
        for (int i = 0; i < 4 && (pos = this.isCorrectIpV4Part(ipv4AddrString, pos)) >= 0; ++i) {
        }
        if (pos < ipv4AddrString.length()) {
            error.setError(4, "invalid IpV4 value: " + ipv4AddrString, "Address");
            return;
        }
    }

    private int isCorrectIpV4Part(String ipv4AddrString, int start) {
        int res = 0;
        boolean foundDigit = false;
        while (start < ipv4AddrString.length() && ipv4AddrString.charAt(start) != '.') {
            int digit = ipv4AddrString.charAt(start) - 48;
            if (digit >= 0 && digit <= 9) {
                foundDigit = true;
                res = res * 10 + digit;
                ++start;
                continue;
            }
            return -1;
        }
        return foundDigit && res <= 255 ? start + 1 : -1;
    }

    void processUnexpectedKey(String key, JsonConverterError error) {
        if (this.converter.catchUnexpectedKeys()) {
            error.setError(14, key);
        }
    }

    void setDeafultDynamicQoS(Object msg) {
        RequestMsg requestMsg = (RequestMsg)msg;
        if (!requestMsg.checkHasQos() && this.converter.useDefaultDynamicQoS()) {
            requestMsg.applyHasQos();
            requestMsg.qos().dynamic(true);
            requestMsg.qos().timeliness(1);
            requestMsg.qos().rate(1);
            requestMsg.applyHasWorstQos();
            requestMsg.worstQos().timeliness(2);
            requestMsg.worstQos().rate(3);
            requestMsg.worstQos().rateInfo(65535);
        }
    }

    int getEncodingMaxSize() {
        return 0;
    }
}

