/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.refinitiv.eta.codec.Array;
import com.refinitiv.eta.codec.ArrayEntry;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.DictionaryEntry;
import com.refinitiv.eta.codec.ElementEntry;
import com.refinitiv.eta.codec.ElementList;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Int;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.RequestMsg;
import com.refinitiv.eta.codec.UInt;
import com.refinitiv.eta.json.converter.AbstractTypeConverter;
import com.refinitiv.eta.json.converter.JsonAbstractConverter;
import com.refinitiv.eta.json.converter.JsonBuffer;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.util.JsonFactory;
import com.refinitiv.eta.rdm.ElementNames;
import java.util.Objects;

abstract class AbstractRsslMessageTypeConverter
extends AbstractTypeConverter {
    AbstractRsslMessageTypeConverter(JsonAbstractConverter converter) {
        super(converter);
    }

    abstract boolean encodeJson(DecodeIterator var1, Object var2, JsonBuffer var3, JsonConverterError var4);

    void encodeRWF(JsonNode dataNode, String key, Msg msg, EncodeIterator iter, JsonConverterError error) {
        int result = 0;
        if (msg.containerType() == 16) {
            result = msg.encode(iter);
            if (result != 0) {
                error.setEncodeError(result, "Message type [" + msg.msgClass() + "]");
            }
            return;
        }
        result = msg.encodeInit(iter, 0);
        if (result < 0) {
            error.setEncodeError(result, "msg [" + msg.msgClass() + "] encode");
            return;
        }
        if (result == 11) {
            this.encodeMsgAttribs(dataNode, iter, error);
            result = msg.encodeKeyAttribComplete(iter, error.isSuccessful());
            if (error.isFailed()) {
                return;
            }
            if (result < 0) {
                error.setEncodeError(result, "msg attrib");
                return;
            }
        }
        if (result == 13) {
            this.encodeMsgPayload(dataNode, msg, iter, error);
        }
        if (error.isFailed()) {
            return;
        }
        result = msg.encodeComplete(iter, error.isSuccessful());
        if (error.isFailed()) {
            return;
        }
        if (result < 0) {
            error.setEncodeError(result, "msg encode complete");
            return;
        }
    }

    void encodeMsgAttribs(JsonNode node, EncodeIterator iter, JsonConverterError error) {
        String key = "Elements";
        JsonNode currentNode = node.path("Key").path("Elements");
        if (currentNode == null) {
            error.setError(2, "json key " + key + " ARRAY was not found");
            return;
        }
        this.converter.decodeChunk(133, currentNode, key, iter, error);
    }

    void encodeMsgPayload(JsonNode node, Msg outMsg, EncodeIterator iter, JsonConverterError error) {
        if (outMsg.msgClass() == 1 && (((RequestMsg)outMsg).checkHasBatch() || ((RequestMsg)outMsg).checkHasView())) {
            this.encodeBatchAndView(node, outMsg, iter, error);
            return;
        }
        JsonNode currentNode = null;
        String key = null;
        switch (outMsg.containerType()) {
            case 133: {
                key = "Elements";
                break;
            }
            case 135: {
                key = "FilterList";
                break;
            }
            case 132: {
                key = "Fields";
                break;
            }
            case 137: {
                key = "Map";
                break;
            }
            case 136: {
                key = "Vector";
                break;
            }
            case 130: {
                key = "Opaque";
                break;
            }
            case 131: {
                key = "Xml";
                break;
            }
            case 138: {
                key = "Series";
                break;
            }
            case 142: {
                key = "Json";
                break;
            }
            case 141: {
                key = "Message";
                break;
            }
            default: {
                error.setError(6, "body type [" + outMsg.containerType() + "] is not supported");
                return;
            }
        }
        currentNode = node.path(key);
        if (currentNode == null) {
            error.setError(12, "body, missing key '" + key + "'");
            return;
        }
        this.converter.decodeChunk(outMsg.containerType(), currentNode, key, iter, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void encodeBatchAndView(JsonNode currentRoot, Msg outMsg, EncodeIterator encodeIterator, JsonConverterError error) {
        JsonNode currentNode;
        String key;
        ElementList elementList = CodecFactory.createElementList();
        elementList.applyHasStandardData();
        int result = elementList.encodeInit(encodeIterator, null, this.getEncodingMaxSize());
        if (result != 0) {
            error.setEncodeError(result, "msg encode BatchRequest/View elementList");
            return;
        }
        if (((RequestMsg)outMsg).checkHasBatch()) {
            key = "Name";
            currentNode = currentRoot.path("Key").path(key);
            if (currentNode == null) {
                error.setError(2, "json key " + key + " was not found");
                return;
            }
            this.decodeBatchAndViewRequestNamesElementEntry(currentNode, encodeIterator, key, true, error);
            if (error.isFailed()) {
                elementList.encodeComplete(encodeIterator, false);
                return;
            }
        }
        if (((RequestMsg)outMsg).checkHasView()) {
            key = "ViewType";
            currentNode = currentRoot.path(key);
            if (!(currentNode.isNull() && currentNode.isMissingNode() || !currentNode.isTextual())) {
                ElementEntry entry = JsonFactory.createElementEntry();
                UInt val = JsonFactory.createUInt();
                try {
                    entry.name(ElementNames.VIEW_TYPE);
                    entry.dataType(4);
                    switch (currentNode.asText()) {
                        case "FidList": {
                            val.value(1);
                            break;
                        }
                        case "NameList": {
                            val.value(2);
                            break;
                        }
                    }
                    entry.encode(encodeIterator, val);
                }
                finally {
                    JsonFactory.releaseElementEntry(entry);
                    JsonFactory.releaseUInt(val);
                }
            }
            if ((currentNode = currentRoot.path(key = "View")) == null) {
                error.setError(2, "json key " + key + " was not found");
                return;
            }
            this.decodeBatchAndViewRequestNamesElementEntry(currentNode, encodeIterator, key, false, error);
            if (error.isFailed()) {
                elementList.encodeComplete(encodeIterator, false);
                return;
            }
        }
        if ((result = elementList.encodeComplete(encodeIterator, true)) != 0) {
            error.setEncodeError(result, "msg encode BatchRequest/View elementList complete");
            return;
        }
    }

    private void decodeBatchAndViewRequestNamesElementEntry(JsonNode currentNode, EncodeIterator iter, String key, boolean isBatch, JsonConverterError error) {
        ElementEntry elementEntry = CodecFactory.createElementEntry();
        Buffer batchElementEntryName = CodecFactory.createBuffer();
        batchElementEntryName.data(isBatch ? ":ItemList" : ":ViewData");
        elementEntry.dataType(15);
        elementEntry.name(batchElementEntryName);
        int result = elementEntry.encodeInit(iter, this.getEncodingMaxSize());
        if (result != 0) {
            error.setEncodeError(result, "batch elementEntry encode failure");
            return;
        }
        this.decodeBatchRequestNamesArray(currentNode, iter, key, isBatch, error);
        result = elementEntry.encodeComplete(iter, error.isSuccessful());
        if (error.isFailed()) {
            return;
        }
        if (result != 0) {
            error.setEncodeError(result, "batch elementEntry encode complete");
            return;
        }
    }

    private void decodeBatchRequestNamesArray(JsonNode currentNode, EncodeIterator iter, String key, boolean isBatch, JsonConverterError error) {
        int result;
        Array array = CodecFactory.createArray();
        array.primitiveType(isBatch ? 17 : 3);
        if (isBatch) {
            array.itemLength(0);
        }
        if ((result = array.encodeInit(iter)) != 0) {
            error.setEncodeError(result, "ARRAY encode");
            return;
        }
        this.processArrayItems(currentNode, iter, key, isBatch, error);
        result = array.encodeComplete(iter, error.isSuccessful());
        if (error.isFailed()) {
            return;
        }
        if (result != 0) {
            error.setEncodeError(result, "ARRAY encode complete");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processArrayItems(JsonNode currentNode, EncodeIterator iter, String key, boolean isBatch, JsonConverterError error) {
        ArrayEntry arrayEntry = JsonFactory.createArrayEntry();
        Buffer bufText = JsonFactory.createBuffer();
        Int intValue = JsonFactory.createInt();
        intValue.value("");
        try {
            for (int i = 0; i < currentNode.size(); ++i) {
                arrayEntry.clear();
                if (isBatch && !currentNode.get(i).isTextual()) {
                    error.setError(8, "Expected String type, found: " + currentNode.get(i).getNodeType().toString());
                    return;
                }
                if (!(isBatch || currentNode.get(i).isTextual() || currentNode.get(i).isInt())) {
                    error.setError(8, "Expected String or Int type, found: " + currentNode.get(i).getNodeType().toString());
                    return;
                }
                int result = -1;
                if (isBatch) {
                    bufText.data(currentNode.get(i).textValue());
                    result = arrayEntry.encode(iter, bufText);
                } else {
                    DictionaryEntry def;
                    if (currentNode.get(i).isInt()) {
                        intValue.value(currentNode.get(i).intValue());
                    } else if (Objects.nonNull(this.converter.getDictionary()) && currentNode.get(i).isTextual() && (def = this.converter.getDictionary().entry(currentNode.get(i).textValue())) != null) {
                        intValue.value(def.fid());
                    }
                    if (!intValue.isBlank()) {
                        result = arrayEntry.encode(iter, intValue);
                    }
                }
                if (result == 0) continue;
                error.setEncodeError(result, "ARRAY, element " + i);
                return;
            }
        }
        finally {
            JsonFactory.releaseBuffer(bufText);
            JsonFactory.releaseArrayEntry(arrayEntry);
            JsonFactory.releaseInt(intValue);
        }
    }
}

