/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.util;

import com.redis.om.spring.annotations.EnableRedisDocumentRepositories;
import com.redis.om.spring.annotations.EnableRedisEnhancedRepositories;
import com.redis.om.spring.convert.MappingRedisOMConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.annotation.Id;
import org.springframework.data.geo.Distance;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.convert.Bucket;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.util.Pair;
import org.springframework.util.ReflectionUtils;
import redis.clients.jedis.args.GeoUnit;
import redis.clients.jedis.search.Document;

public class ObjectUtils {
    public static String getDistanceAsRedisString(Distance distance) {
        return String.format("%s %s", distance.getValue(), distance.getUnit());
    }

    public static List<Field> getFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return ObjectUtils.getDeclaredFieldsTransitively(clazz).stream().filter(f -> f.isAnnotationPresent(annotationClass)).toList();
    }

    public static GeoUnit getDistanceUnit(Distance distance) {
        if (distance.getUnit().equals(RedisGeoCommands.DistanceUnit.MILES.getAbbreviation())) {
            return GeoUnit.MI;
        }
        if (distance.getUnit().equals(RedisGeoCommands.DistanceUnit.FEET.getAbbreviation())) {
            return GeoUnit.FT;
        }
        if (distance.getUnit().equals(RedisGeoCommands.DistanceUnit.KILOMETERS.getAbbreviation())) {
            return GeoUnit.KM;
        }
        return GeoUnit.M;
    }

    public static String getTargetClassName(String fullTypeClassName) {
        String[] splitted = fullTypeClassName.split(" ");
        String cls = splitted[splitted.length - 1];
        if (cls.contains("<")) {
            cls = cls.substring(0, cls.indexOf("<"));
        }
        return cls;
    }

    public static String getCollectionTargetClassName(String fullTypeClassName) {
        String[] splitted = fullTypeClassName.split(" ");
        String cls = splitted[splitted.length - 1];
        if (cls.contains("<")) {
            cls = cls.substring(cls.indexOf("<") + 1, cls.indexOf(">"));
        }
        return cls;
    }

    public static String firstToLowercase(String string) {
        char[] c = string.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    public static Optional<Class<?>> getCollectionElementType(Field field) {
        if (Collection.class.isAssignableFrom(field.getType()) || Iterable.class.isAssignableFrom(field.getType())) {
            ResolvableType collectionType = ResolvableType.forField((Field)field);
            Class elementType = collectionType.getGeneric(new int[]{0}).getRawClass();
            return Optional.of(elementType);
        }
        return Optional.empty();
    }

    public static Optional<Field> getIdFieldForEntityClass(Class<?> cl) {
        return ObjectUtils.getDeclaredFieldsTransitively(cl).stream().filter(f -> f.isAnnotationPresent(Id.class)).findFirst();
    }

    public static Object getIdFieldForEntity(Object entity) {
        Optional<Field> maybeIdField = ObjectUtils.getIdFieldForEntityClass(entity.getClass());
        if (maybeIdField.isEmpty()) {
            return null;
        }
        Field idField = maybeIdField.get();
        String getterName = "get" + ObjectUtils.ucfirst(idField.getName());
        Method getter = ReflectionUtils.findMethod(entity.getClass(), (String)getterName);
        return getter != null ? ReflectionUtils.invokeMethod((Method)getter, (Object)entity) : null;
    }

    public static Object getIdFieldForEntity(Field idField, Object entity) {
        String getterName = "get" + ObjectUtils.ucfirst(idField.getName());
        Method getter = ReflectionUtils.findMethod(entity.getClass(), (String)getterName);
        return ReflectionUtils.invokeMethod((Method)getter, (Object)entity);
    }

    public static Method getGetterForField(Class<?> cls, Field field) {
        String getterName = "get" + ObjectUtils.ucfirst(field.getName());
        return ReflectionUtils.findMethod(cls, (String)getterName);
    }

    public static Method getSetterForField(Class<?> cls, Field field) {
        String setterName = "set" + ObjectUtils.ucfirst(field.getName());
        return ReflectionUtils.findMethod(cls, (String)setterName, (Class[])new Class[]{field.getType()});
    }

    public static String ucfirst(String input) {
        return ObjectUtils.withFirst(input, first -> String.valueOf(Character.toUpperCase(first.charValue())));
    }

    public static String withFirst(String input, Function<Character, String> callback) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return "";
        }
        return String.join((CharSequence)"", callback.apply(Character.valueOf(input.charAt(0))), input.subSequence(1, input.length()));
    }

    public static boolean isFirstLowerCase(String string) {
        String first = string.substring(0, 1);
        return Character.isLetter(first.charAt(0)) && first.toLowerCase().equals(first);
    }

    public static String lcfirst(String input) {
        return ObjectUtils.withFirst(input, first -> String.valueOf(Character.toLowerCase(first.charValue())));
    }

    public static String unQuote(String s) {
        Objects.requireNonNull(s);
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String toUnderscoreSeparated(String javaName) {
        Objects.requireNonNull(javaName);
        StringBuilder result = new StringBuilder();
        String input = ObjectUtils.unQuote(javaName.trim());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (result.length() == 0) {
                result.append(Character.toLowerCase(c));
                continue;
            }
            if (Character.isUpperCase(c)) {
                result.append("_").append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String shortName(String longName) {
        String temp = longName.replace('$', '.');
        int openBrPos = temp.indexOf(60);
        String parameters = "";
        if (openBrPos > 0) {
            parameters = temp.substring(openBrPos);
            temp = temp.substring(0, openBrPos);
        }
        if (temp.contains(".")) {
            temp = temp.substring(temp.lastIndexOf(46) + 1);
        }
        return temp + parameters;
    }

    public static boolean isPropertyAnnotatedWith(Class<?> cls, String property, Class<? extends Annotation> annotationClass) {
        try {
            Field field = ReflectionUtils.findField(cls, (String)property);
            if (field == null) {
                return false;
            }
            return field.isAnnotationPresent(annotationClass);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static Object documentToObject(Document document, Class<?> returnedObjectType, MappingRedisOMConverter mappingConverter) {
        Bucket b = new Bucket();
        document.getProperties().forEach(p -> b.put((String)p.getKey(), (byte[])p.getValue()));
        return mappingConverter.read(returnedObjectType, new RedisData(b));
    }

    public static Object mapToObject(Map<String, Object> properties, Class<?> returnedObjectType, MappingRedisOMConverter mappingConverter) {
        Bucket b = new Bucket();
        properties.forEach((k, v) -> b.put(k, (byte[])v));
        return mappingConverter.read(returnedObjectType, new RedisData(b));
    }

    public static <T> T documentToEntity(Document document, Class<T> classOfT, MappingRedisOMConverter mappingConverter) {
        Bucket b = new Bucket();
        document.getProperties().forEach(p -> b.put((String)p.getKey(), (byte[])p.getValue()));
        return mappingConverter.read(classOfT, new RedisData(b));
    }

    public static String asString(Object value, MappingRedisOMConverter mappingConverter) {
        if (value instanceof String) {
            String valueAsString = (String)value;
            return valueAsString;
        }
        return (String)mappingConverter.getConversionService().convert(value, String.class);
    }

    public static Set<BeanDefinition> getBeanDefinitionsFor(ApplicationContext ac, Class ... classes) {
        HashSet<BeanDefinition> beanDefs = new HashSet<BeanDefinition>();
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        for (Class cls : classes) {
            provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(cls));
        }
        List<Pair<EnableRedisDocumentRepositories, String>> erdrs = ObjectUtils.getEnableRedisDocumentRepositories(ac);
        for (Pair<EnableRedisDocumentRepositories, String> pair : erdrs) {
            EnableRedisDocumentRepositories edr = (EnableRedisDocumentRepositories)pair.getFirst();
            if (edr.basePackages().length > 0) {
                for (String string : edr.basePackages()) {
                    beanDefs.addAll(provider.findCandidateComponents(string));
                }
                continue;
            }
            if (edr.basePackageClasses().length > 0) {
                for (Class<?> clazz : edr.basePackageClasses()) {
                    beanDefs.addAll(provider.findCandidateComponents(clazz.getPackageName()));
                }
                continue;
            }
            beanDefs.addAll(provider.findCandidateComponents((String)pair.getSecond()));
        }
        List<Pair<EnableRedisEnhancedRepositories, String>> erers = ObjectUtils.getEnableRedisEnhancedRepositories(ac);
        for (Pair<EnableRedisEnhancedRepositories, String> pair : erers) {
            EnableRedisEnhancedRepositories er = (EnableRedisEnhancedRepositories)pair.getFirst();
            if (er.basePackages().length > 0) {
                for (String string : er.basePackages()) {
                    beanDefs.addAll(provider.findCandidateComponents(string));
                }
                continue;
            }
            if (er.basePackageClasses().length > 0) {
                for (Class<?> clazz : er.basePackageClasses()) {
                    beanDefs.addAll(provider.findCandidateComponents(clazz.getPackageName()));
                }
                continue;
            }
            beanDefs.addAll(provider.findCandidateComponents((String)pair.getSecond()));
        }
        return beanDefs;
    }

    public static List<Pair<EnableRedisDocumentRepositories, String>> getEnableRedisDocumentRepositories(ApplicationContext ac) {
        Map annotatedBeans = ac.getBeansWithAnnotation(SpringBootApplication.class);
        annotatedBeans.putAll(ac.getBeansWithAnnotation(Configuration.class));
        ArrayList<Pair<EnableRedisDocumentRepositories, String>> erdrs = new ArrayList<Pair<EnableRedisDocumentRepositories, String>>();
        for (Object ab : annotatedBeans.values()) {
            Class<?> cls = ab.getClass();
            if (!cls.isAnnotationPresent(EnableRedisDocumentRepositories.class)) continue;
            EnableRedisDocumentRepositories edr = cls.getAnnotation(EnableRedisDocumentRepositories.class);
            erdrs.add((Pair<EnableRedisDocumentRepositories, String>)Pair.of((Object)edr, (Object)cls.getPackageName()));
        }
        return erdrs;
    }

    public static List<Pair<EnableRedisEnhancedRepositories, String>> getEnableRedisEnhancedRepositories(ApplicationContext ac) {
        Map annotatedBeans = ac.getBeansWithAnnotation(SpringBootApplication.class);
        annotatedBeans.putAll(ac.getBeansWithAnnotation(Configuration.class));
        ArrayList<Pair<EnableRedisEnhancedRepositories, String>> erers = new ArrayList<Pair<EnableRedisEnhancedRepositories, String>>();
        for (Object ab : annotatedBeans.values()) {
            Class<?> cls = ab.getClass();
            if (!cls.isAnnotationPresent(EnableRedisEnhancedRepositories.class)) continue;
            EnableRedisEnhancedRepositories edr = cls.getAnnotation(EnableRedisEnhancedRepositories.class);
            erers.add((Pair<EnableRedisEnhancedRepositories, String>)Pair.of((Object)edr, (Object)cls.getPackageName()));
        }
        return erers;
    }

    public static List<Field> getDeclaredFieldsTransitively(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            fields.addAll(Arrays.stream(clazz.getDeclaredFields()).toList());
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static Field getDeclaredFieldTransitively(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Field field = ReflectionUtils.findField(clazz, (String)fieldName);
        if (field == null) {
            throw new NoSuchFieldException(fieldName);
        }
        return field;
    }

    public static byte[] floatArrayToByteArray(float[] input) {
        byte[] bytes = new byte[4 * input.length];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer().put(input);
        return bytes;
    }

    public static byte[] longArrayToByteArray(long[] input) {
        float[] floats = new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            floats[i] = input[i];
        }
        return ObjectUtils.floatArrayToByteArray(floats);
    }

    private ObjectUtils() {
    }
}

