/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.vector;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import redis.clients.jedis.search.querybuilder.Node;

public class KNNPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final int k;
    private final byte[] blobAttribute;

    public KNNPredicate(SearchFieldAccessor field, int k, byte[] blobAttribute) {
        super(field);
        this.k = k;
        this.blobAttribute = blobAttribute;
    }

    public int getK() {
        return this.k;
    }

    public byte[] getBlobAttribute() {
        return this.blobAttribute;
    }

    public String getBlobAttributeName() {
        return String.format("%s_blob", this.getSearchAlias());
    }

    @Override
    public Node apply(Node root) {
        final String query = String.format("(%s)=>[KNN $K @%s $%s]", root.toString().isBlank() ? "*" : root.toString(), this.getSearchAlias(), this.getBlobAttributeName());
        return new Node(){

            public String toString() {
                return query;
            }

            public String toString(Node.Parenthesize mode) {
                return query;
            }
        };
    }
}

