/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.numeric;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.Value;
import redis.clients.jedis.search.querybuilder.Values;

public class BetweenPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final T min;
    private final T max;

    public BetweenPredicate(SearchFieldAccessor field, T min, T max) {
        super(field);
        this.min = min;
        this.max = max;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    @Override
    public Node apply(Node root) {
        boolean paramsPresent;
        boolean bl = paramsPresent = ObjectUtils.isNotEmpty(this.getMin()) && ObjectUtils.isNotEmpty(this.getMax());
        if (!paramsPresent) {
            return root;
        }
        Class<?> cls = this.min.getClass();
        if (cls == LocalDate.class) {
            LocalDate minLocalDate = (LocalDate)this.min;
            LocalDate maxLocalDate = (LocalDate)this.max;
            Instant minInstant = minLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant();
            Instant maxInstant = maxLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant();
            long minUnixTime = minInstant.getEpochSecond();
            long maxUnixTime = maxInstant.getEpochSecond();
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.between((double)Double.parseDouble(Long.toString(minUnixTime)), (double)Double.parseDouble(Long.toString(maxUnixTime)))});
        }
        if (cls == Date.class) {
            Date minLocalDate = (Date)this.min;
            Date maxLocalDate = (Date)this.max;
            Instant minInstant = minLocalDate.toInstant();
            Instant maxInstant = maxLocalDate.toInstant();
            long minUnixTime = minInstant.getEpochSecond();
            long maxUnixTime = maxInstant.getEpochSecond();
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.between((double)Double.parseDouble(Long.toString(minUnixTime)), (double)Double.parseDouble(Long.toString(maxUnixTime)))});
        }
        if (cls == LocalDateTime.class) {
            LocalDateTime minLocalDateTime = (LocalDateTime)this.min;
            LocalDateTime maxLocalDateTime = (LocalDateTime)this.max;
            long minUnixTime = minLocalDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            long maxUnixTime = maxLocalDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.between((double)minUnixTime, (double)maxUnixTime)});
        }
        if (cls == Instant.class) {
            Instant minInstant = (Instant)this.min;
            Instant maxInstant = (Instant)this.max;
            long minUnixTime = minInstant.getEpochSecond();
            long maxUnixTime = maxInstant.getEpochSecond();
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.between((double)minUnixTime, (double)maxUnixTime)});
        }
        if (cls == Integer.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.between((int)Integer.parseInt(this.getMin().toString()), (int)Integer.parseInt(this.getMax().toString()))});
        }
        if (cls == Long.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.between((double)Long.parseLong(this.getMin().toString()), (double)Long.parseLong(this.getMax().toString()))});
        }
        if (cls == Double.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.between((double)Double.parseDouble(this.getMin().toString()), (double)Double.parseDouble(this.getMax().toString()))});
        }
        return root;
    }
}

