/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.support;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.redis.om.spring.RediSearchIndexer;
import com.redis.om.spring.convert.MappingRedisOMConverter;
import com.redis.om.spring.id.ULIDIdentifierGenerator;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.repository.RedisDocumentRepository;
import com.redis.om.spring.serialization.gson.GsonListOfType;
import com.redis.om.spring.util.ObjectUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import lombok.NonNull;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.keyvalue.repository.support.SimpleKeyValueRepository;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.convert.KeyspaceConfiguration;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.convert.ReferenceResolver;
import org.springframework.data.redis.core.convert.ReferenceResolverImpl;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.json.JsonProtocol;
import redis.clients.jedis.json.Path;
import redis.clients.jedis.json.Path2;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.SearchResult;
import redis.clients.jedis.util.SafeEncoder;

public class SimpleRedisDocumentRepository<T, ID>
extends SimpleKeyValueRepository<T, ID>
implements RedisDocumentRepository<T, ID> {
    private final Gson gson;
    protected final RedisModulesOperations<String> modulesOperations;
    protected final EntityInformation<T, ID> metadata;
    protected final KeyValueOperations operations;
    protected final RediSearchIndexer indexer;
    protected final MappingRedisOMConverter mappingConverter;
    private final ULIDIdentifierGenerator generator;
    private final RedisMappingContext mappingContext;

    public SimpleRedisDocumentRepository(EntityInformation<T, ID> metadata, KeyValueOperations operations, @Qualifier(value="redisModulesOperations") RedisModulesOperations<?> rmo, RediSearchIndexer keyspaceToIndexMap, RedisMappingContext mappingContext, Gson gson) {
        super(metadata, operations);
        this.modulesOperations = rmo;
        this.metadata = metadata;
        this.operations = operations;
        this.indexer = keyspaceToIndexMap;
        this.mappingConverter = new MappingRedisOMConverter(null, (ReferenceResolver)new ReferenceResolverImpl((RedisOperations)this.modulesOperations.getTemplate()));
        this.generator = ULIDIdentifierGenerator.INSTANCE;
        this.gson = gson;
        this.mappingContext = mappingContext;
    }

    @Override
    public Iterable<ID> getIds() {
        String keyspace = this.indexer.getKeyspaceForEntityClass(this.metadata.getJavaType());
        Optional<String> maybeSearchIndex = this.indexer.getIndexName(keyspace);
        List<Object> result = List.of();
        if (maybeSearchIndex.isPresent()) {
            SearchOperations<String> searchOps = this.modulesOperations.opsForSearch(maybeSearchIndex.get());
            Optional<Field> maybeIdField = ObjectUtils.getIdFieldForEntityClass(this.metadata.getJavaType());
            String idField = maybeIdField.map(Field::getName).orElse("id");
            Query query = new Query("*");
            query.returnFields(new String[]{idField});
            SearchResult searchResult = searchOps.search(query);
            result = searchResult.getDocuments().stream().map(d -> this.gson.fromJson(SafeEncoder.encode((byte[])((byte[])d.get(idField))), this.metadata.getIdType())).toList();
        }
        return result;
    }

    @Override
    public Page<ID> getIds(Pageable pageable) {
        ArrayList ids = Lists.newArrayList(this.getIds());
        int fromIndex = Math.toIntExact(pageable.getOffset());
        int toIndex = fromIndex + pageable.getPageSize();
        return new PageImpl(ids.subList(fromIndex, toIndex), pageable, (long)ids.size());
    }

    @Override
    public void deleteById(ID id, Path path) {
        this.modulesOperations.opsForJSON().del(this.getKey(id), path);
    }

    @Override
    public void updateField(T entity, MetamodelField<T, ?> field, Object value) {
        this.modulesOperations.opsForJSON().set(this.getKey(this.metadata.getId(entity)), value, Path.of((String)("$." + field.getSearchAlias())));
    }

    @Override
    public <F> Iterable<F> getFieldsByIds(Iterable<ID> ids, MetamodelField<T, F> field) {
        String[] keys = (String[])StreamSupport.stream(ids.spliterator(), false).map(this::getKey).toArray(String[]::new);
        return this.modulesOperations.opsForJSON().mget(Path2.of((String)("$." + field.getSearchAlias())), List.class, (String[])keys).stream().flatMap(Collection::stream).toList();
    }

    @Override
    public Long getExpiration(ID id) {
        StringRedisTemplate template = this.modulesOperations.getTemplate();
        return template.getExpire((Object)this.getKey(id));
    }

    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        ArrayList<S> saved = new ArrayList<S>();
        try (Jedis jedis = this.modulesOperations.getClient().getJedis().get();){
            Pipeline pipeline = jedis.pipelined();
            for (S entity : entities) {
                boolean isNew = this.metadata.isNew(entity);
                KeyValuePersistentEntity keyValueEntity = (KeyValuePersistentEntity)this.mappingConverter.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass(entity));
                Object id = isNew ? this.generator.generateIdentifierOfType(((KeyValuePersistentProperty)keyValueEntity.getIdProperty()).getTypeInformation()) : keyValueEntity.getPropertyAccessor(entity).getProperty(keyValueEntity.getIdProperty());
                keyValueEntity.getPropertyAccessor(entity).setProperty(keyValueEntity.getIdProperty(), id);
                String keyspace = keyValueEntity.getKeySpace();
                byte[] objectKey = this.createKey(keyspace, id.toString());
                this.processAuditAnnotations(objectKey, entity, isNew);
                Optional<Long> maybeTtl = this.getTTLForEntity(entity);
                RedisData rdo = new RedisData();
                this.mappingConverter.write(entity, rdo);
                ArrayList<byte[]> args = new ArrayList<byte[]>(4);
                args.add(objectKey);
                args.add(SafeEncoder.encode((String)Path.ROOT_PATH.toString()));
                args.add(SafeEncoder.encode((String)this.gson.toJson(entity)));
                pipeline.sendCommand((ProtocolCommand)JsonProtocol.JsonCommand.SET, (byte[][])args.toArray((T[])new byte[args.size()][]));
                maybeTtl.ifPresent(aLong -> pipeline.expire(objectKey, aLong.longValue()));
                saved.add(entity);
            }
            pipeline.sync();
        }
        return saved;
    }

    @Override
    public Iterable<T> bulkLoad(String file) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(file, new String[0]));){
            List entities = (List)this.gson.fromJson((Reader)reader, new GsonListOfType(this.metadata.getJavaType()));
            Iterable iterable = this.saveAll((Iterable)entities);
            return iterable;
        }
    }

    @NonNull
    public List<T> findAllById(Iterable<ID> ids) {
        String[] keys = (String[])StreamSupport.stream(ids.spliterator(), false).map(this::getKey).toArray(String[]::new);
        return this.modulesOperations.opsForJSON().mget(this.metadata.getJavaType(), (String[])keys).stream().toList();
    }

    private String getKeyspace() {
        return this.indexer.getKeyspaceForEntityClass(this.metadata.getJavaType());
    }

    private String getKey(Object id) {
        return this.getKeyspace() + id.toString();
    }

    public byte[] createKey(String keyspace, String id) {
        return this.mappingConverter.toBytes(keyspace + ":" + id);
    }

    private void processAuditAnnotations(byte[] redisKey, Object item, boolean isNew) {
        Class auditClass = isNew ? CreatedDate.class : LastModifiedDate.class;
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(item.getClass(), auditClass);
        if (!fields.isEmpty()) {
            BeanWrapper accessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)item);
            fields.forEach(arg_0 -> SimpleRedisDocumentRepository.lambda$processAuditAnnotations$4((PropertyAccessor)accessor, arg_0));
        }
    }

    private Optional<Long> getTTLForEntity(Object entity) {
        block7: {
            KeyspaceConfiguration keyspaceConfig = this.mappingContext.getMappingConfiguration().getKeyspaceConfiguration();
            if (keyspaceConfig.hasSettingsFor(entity.getClass())) {
                KeyspaceConfiguration.KeyspaceSettings settings = keyspaceConfig.getKeyspaceSettings(entity.getClass());
                if (StringUtils.hasText((String)settings.getTimeToLivePropertyName())) {
                    try {
                        Field fld = ReflectionUtils.findField(entity.getClass(), (String)settings.getTimeToLivePropertyName());
                        Method ttlGetter = ObjectUtils.getGetterForField(entity.getClass(), fld);
                        Long ttlPropertyValue = ((Number)ReflectionUtils.invokeMethod((Method)ttlGetter, (Object)entity)).longValue();
                        ReflectionUtils.invokeMethod((Method)ttlGetter, (Object)entity);
                        if (ttlPropertyValue != null) {
                            TimeToLive ttl = fld.getAnnotation(TimeToLive.class);
                            if (!ttl.unit().equals((Object)TimeUnit.SECONDS)) {
                                return Optional.of(TimeUnit.SECONDS.convert(ttlPropertyValue, ttl.unit()));
                            }
                            return Optional.of(ttlPropertyValue);
                        }
                        break block7;
                    }
                    catch (IllegalArgumentException | SecurityException e) {
                        return Optional.empty();
                    }
                }
                if (settings != null && settings.getTimeToLive() != null && settings.getTimeToLive() > 0L) {
                    return Optional.of(settings.getTimeToLive());
                }
            }
        }
        return Optional.empty();
    }

    private static /* synthetic */ void lambda$processAuditAnnotations$4(PropertyAccessor accessor, Field f) {
        if (f.getType() == Date.class) {
            accessor.setPropertyValue(f.getName(), (Object)new Date(System.currentTimeMillis()));
        } else if (f.getType() == LocalDateTime.class) {
            accessor.setPropertyValue(f.getName(), (Object)LocalDateTime.now());
        } else if (f.getType() == LocalDate.class) {
            accessor.setPropertyValue(f.getName(), (Object)LocalDate.now());
        }
    }
}

