/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.metamodel;

import com.github.f4b6a3.ulid.Ulid;
import com.google.auto.service.AutoService;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.SchemaFieldType;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.metamodel.IllegalJavaBeanException;
import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.metamodel.ObjectGraphFieldSpec;
import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.metamodel.indexed.BooleanField;
import com.redis.om.spring.metamodel.indexed.CollectionField;
import com.redis.om.spring.metamodel.indexed.DateField;
import com.redis.om.spring.metamodel.indexed.GeoField;
import com.redis.om.spring.metamodel.indexed.NumericField;
import com.redis.om.spring.metamodel.indexed.TagField;
import com.redis.om.spring.metamodel.indexed.TextField;
import com.redis.om.spring.metamodel.indexed.TextTagField;
import com.redis.om.spring.metamodel.indexed.VectorField;
import com.redis.om.spring.metamodel.nonindexed.NonIndexedBooleanField;
import com.redis.om.spring.metamodel.nonindexed.NonIndexedGeoField;
import com.redis.om.spring.metamodel.nonindexed.NonIndexedNumericField;
import com.redis.om.spring.metamodel.nonindexed.NonIndexedTagField;
import com.redis.om.spring.metamodel.nonindexed.NonIndexedTextField;
import com.redis.om.spring.tuple.Pair;
import com.redis.om.spring.tuple.Triple;
import com.redis.om.spring.tuple.Tuples;
import com.redis.om.spring.util.ObjectUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.springframework.data.annotation.Id;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.util.ClassUtils;

@SupportedAnnotationTypes(value={"com.redis.om.spring.annotations.Document", "org.springframework.data.redis.core.RedisHash"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@AutoService(value={Processor.class})
public final class MetamodelGenerator
extends AbstractProcessor {
    static final String GET_PREFIX = "get";
    static final String IS_PREFIX = "is";
    private ProcessingEnvironment processingEnvironment;
    private Messager messager;
    private TypeElement objectTypeElement;
    private static final Set<String> DISALLOWED_ACCESS_LEVELS = Stream.of("PROTECTED", "PRIVATE", "NONE").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    public static final Character REPLACEMENT_CHARACTER = Character.valueOf('_');
    static final Set<String> JAVA_LITERAL_WORDS = Set.of("true", "false", "null");
    static final Set<String> JAVA_RESERVED_WORDS = Collections.unmodifiableSet(Stream.of("const", "goto", "abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while").collect(Collectors.toSet()));
    static final Set<Class<?>> JAVA_BUILT_IN_CLASSES = Set.of(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Object.class, Short.class, String.class, BigDecimal.class, BigInteger.class, Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE);
    private static final Set<String> JAVA_BUILT_IN_CLASS_WORDS = Collections.unmodifiableSet(JAVA_BUILT_IN_CLASSES.stream().map(Class::getSimpleName).collect(Collectors.toSet()));
    private static final Set<String> JAVA_USED_WORDS = Collections.unmodifiableSet(Stream.of(JAVA_LITERAL_WORDS, JAVA_RESERVED_WORDS, JAVA_BUILT_IN_CLASS_WORDS).flatMap(Collection::stream).collect(Collectors.toSet()));
    private static final Set<String> JAVA_USED_WORDS_LOWER_CASE = Collections.unmodifiableSet(JAVA_USED_WORDS.stream().map(String::toLowerCase).collect(Collectors.toSet()));

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.processingEnvironment = env;
        this.processingEnvironment.getElementUtils();
        this.processingEnvironment.getTypeUtils();
        this.messager = this.processingEnvironment.getMessager();
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Redis OM Spring Field Generator Processor");
        this.objectTypeElement = this.processingEnvironment.getElementUtils().getTypeElement("java.lang.Object");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations.isEmpty() || roundEnv.processingOver()) {
            return false;
        }
        Set<? extends Element> documentEntities = roundEnv.getElementsAnnotatedWith(Document.class);
        Set<? extends Element> hashEntities = roundEnv.getElementsAnnotatedWith(RedisHash.class);
        Set metamodelCandidates = Stream.of(documentEntities, hashEntities).flatMap(Collection::stream).collect(Collectors.toSet());
        metamodelCandidates.stream().filter(ae -> ae.getKind() == ElementKind.CLASS).forEach(ae -> {
            try {
                this.generateMetaModelClass((Element)ae);
            }
            catch (IOException ioe) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Cannot generate metamodel class for " + ae.getClass().getName() + " because " + ioe.getMessage());
            }
        });
        return true;
    }

    void generateMetaModelClass(Element annotatedElement) throws IOException {
        boolean hasFields;
        String packageName;
        String qualifiedGenEntityName = annotatedElement.asType().toString() + "$";
        String entityName = ObjectUtils.shortName(annotatedElement.asType().toString());
        String genEntityName = entityName + "$";
        TypeName entity = TypeName.get((TypeMirror)annotatedElement.asType());
        Map<? extends Element, String> enclosedFields = this.getInstanceFields(annotatedElement);
        PackageElement packageElement = this.processingEnvironment.getElementUtils().getPackageOf(annotatedElement);
        if (packageElement.isUnnamed()) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Class " + entityName + " has an unnamed package.");
            packageName = "";
        } else {
            packageName = packageElement.getQualifiedName().toString();
        }
        ArrayList<FieldSpec> interceptors = new ArrayList<FieldSpec>();
        ArrayList fields = new ArrayList();
        ArrayList<CodeBlock> initCodeBlocks = new ArrayList<CodeBlock>();
        ArrayList nestedFieldsConstants = new ArrayList();
        enclosedFields.forEach((field, getter) -> {
            List<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>> fieldMetamodels = this.processFieldMetamodel(entity, entityName, List.of(field));
            for (Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock> fieldMetamodel : fieldMetamodels) {
                FieldSpec fieldSpec = fieldMetamodel.getSecond();
                fields.add(fieldMetamodel.getFirst());
                interceptors.add(fieldMetamodel.getSecond());
                initCodeBlocks.add(fieldMetamodel.getThird());
                if (!fieldSpec.type.toString().startsWith(VectorField.class.getName())) continue;
                String fieldName = fieldMetamodel.getFirst().fieldSpec().name;
                Pair<FieldSpec, CodeBlock> vectorFieldScore = this.generateUnboundMetamodelField(entity, "_" + fieldSpec.name + "_SCORE", "__" + fieldName + "_score", Double.class);
                interceptors.add(vectorFieldScore.getFirst());
                initCodeBlocks.add(vectorFieldScore.getSecond());
            }
        });
        Pair<FieldSpec, CodeBlock> keyAccessor = this.generateUnboundMetamodelField(entity, "_KEY", "__key", String.class);
        interceptors.add(keyAccessor.getFirst());
        initCodeBlocks.add(keyAccessor.getSecond());
        CodeBlock.Builder blockBuilder = CodeBlock.builder();
        boolean bl = hasFields = !fields.isEmpty();
        if (hasFields) {
            blockBuilder.beginControlFlow("try", new Object[0]);
        }
        for (ObjectGraphFieldSpec ogfs : fields) {
            StringBuilder sb = new StringBuilder("$T.class");
            for (int i = 0; i < ogfs.chain().size(); ++i) {
                Element element = ogfs.chain().get(i);
                if (i != 0) {
                    sb.append(".getType()");
                }
                String formattedString = String.format("com.redis.om.spring.util.ObjectUtils.getDeclaredFieldTransitively(%s, \"%s\")", sb.toString(), element.getSimpleName());
                sb.setLength(0);
                sb.append(formattedString);
            }
            FieldSpec fieldSpec = ogfs.fieldSpec();
            blockBuilder.addStatement("$L = " + sb, new Object[]{fieldSpec.name, entity});
        }
        for (CodeBlock initCodeBlock : initCodeBlocks) {
            blockBuilder.add(initCodeBlock);
        }
        if (hasFields) {
            blockBuilder.nextControlFlow("catch($T | $T e)", new Object[]{NoSuchFieldException.class, SecurityException.class});
            blockBuilder.addStatement("System.err.println(e.getMessage())", new Object[0]);
            blockBuilder.endControlFlow();
        }
        CodeBlock staticBlock = blockBuilder.build();
        TypeSpec metaClass = TypeSpec.classBuilder((String)genEntityName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addFields(fields.stream().map(ObjectGraphFieldSpec::fieldSpec).toList()).addFields(nestedFieldsConstants).addStaticBlock(staticBlock).addFields(interceptors).build();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)metaClass).build();
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(qualifiedGenEntityName, new Element[0]);
        Writer writer = builderFile.openWriter();
        javaFile.writeTo((Appendable)writer);
        writer.close();
    }

    private List<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>> processFieldMetamodel(TypeName entity, String entityName, List<Element> chain) {
        return this.processFieldMetamodel(entity, entityName, chain, null);
    }

    private List<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>> processFieldMetamodel(TypeName entity, String entityName, List<Element> chain, String collectionPrefix) {
        Class targetInterceptor;
        TypeName entityField;
        String chainedFieldName;
        boolean fieldIsIndexed;
        ArrayList<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>> fieldMetamodelSpec;
        block44: {
            fieldMetamodelSpec = new ArrayList<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>>();
            Element field = chain.get(chain.size() - 1);
            fieldIsIndexed = field.getAnnotation(Searchable.class) != null || field.getAnnotation(Indexed.class) != null || field.getAnnotation(Id.class) != null;
            chainedFieldName = chain.stream().map(Element::getSimpleName).collect(Collectors.joining("_"));
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Processing " + chainedFieldName);
            entityField = TypeName.get((TypeMirror)field.asType());
            TypeMirror fieldType = field.asType();
            String fullTypeClassName = fieldType.toString();
            String cls = ObjectUtils.getTargetClassName(fullTypeClassName);
            if (field.asType().getKind().isPrimitive()) {
                Class primitive = ClassUtils.resolvePrimitiveClassName((String)cls);
                if (primitive == null) {
                    return Collections.emptyList();
                }
                Class primitiveWrapper = ClassUtils.resolvePrimitiveIfNecessary((Class)primitive);
                entityField = TypeName.get((Type)primitiveWrapper);
                fullTypeClassName = entityField.toString();
                cls = ObjectUtils.getTargetClassName(fullTypeClassName);
            }
            targetInterceptor = null;
            Class targetCls = null;
            Indexed indexed = field.getAnnotation(Indexed.class);
            Searchable searchable = field.getAnnotation(Searchable.class);
            if (searchable != null) {
                targetInterceptor = TextField.class;
            } else if (indexed != null || field.getAnnotation(Id.class) != null) {
                try {
                    targetCls = ClassUtils.forName((String)cls, (ClassLoader)MetamodelGenerator.class.getClassLoader());
                }
                catch (ClassNotFoundException cnfe) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Processing class " + entityName + " could not resolve " + cls + " while checking for nested indexables");
                    fieldMetamodelSpec.addAll(this.processNestedIndexableFields(entity, chain));
                }
                if (indexed != null && indexed.schemaFieldType() != SchemaFieldType.AUTODETECT) {
                    switch (indexed.schemaFieldType()) {
                        case TAG: {
                            targetInterceptor = TextTagField.class;
                            break;
                        }
                        case NUMERIC: {
                            targetInterceptor = NumericField.class;
                            break;
                        }
                        case GEO: {
                            targetInterceptor = GeoField.class;
                            break;
                        }
                        case VECTOR: {
                            targetInterceptor = VectorField.class;
                        }
                    }
                } else if (targetCls != null) {
                    if (CharSequence.class.isAssignableFrom(targetCls) || targetCls == Ulid.class) {
                        targetInterceptor = TextTagField.class;
                    } else if (Number.class.isAssignableFrom(targetCls)) {
                        targetInterceptor = NumericField.class;
                    } else if (targetCls == LocalDateTime.class || targetCls == LocalDate.class || targetCls == Date.class || targetCls == Instant.class) {
                        targetInterceptor = DateField.class;
                    } else {
                        if (Set.class.isAssignableFrom(targetCls) || List.class.isAssignableFrom(targetCls)) {
                            String collectionElementName = ObjectUtils.getCollectionTargetClassName(fullTypeClassName);
                            targetInterceptor = TagField.class;
                            try {
                                ClassUtils.forName((String)collectionElementName, (ClassLoader)MetamodelGenerator.class.getClassLoader());
                            }
                            catch (ClassNotFoundException cnfe) {
                                Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock> collectionFieldMetamodel = null;
                                try {
                                    collectionFieldMetamodel = this.generateCollectionFieldMetamodel(entity, chain, chainedFieldName, collectionElementName);
                                }
                                catch (IOException e) {
                                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Processing class " + entityName + " could create collection field metamodel element for " + collectionElementName);
                                }
                                if (collectionFieldMetamodel != null) {
                                    fieldMetamodelSpec.add(collectionFieldMetamodel);
                                    targetInterceptor = null;
                                }
                                break block44;
                            }
                        }
                        if (targetCls == Point.class) {
                            targetInterceptor = GeoField.class;
                        } else if (targetCls == Boolean.class) {
                            targetInterceptor = BooleanField.class;
                        }
                    }
                }
            } else {
                try {
                    targetCls = ClassUtils.forName((String)cls, (ClassLoader)MetamodelGenerator.class.getClassLoader());
                    if (CharSequence.class.isAssignableFrom(targetCls) || targetCls == Ulid.class) {
                        targetInterceptor = NonIndexedTextField.class;
                    } else if (targetCls == Boolean.class) {
                        targetInterceptor = NonIndexedBooleanField.class;
                    } else if (Number.class.isAssignableFrom(targetCls) || targetCls == LocalDateTime.class || targetCls == LocalDate.class || targetCls == Date.class || targetCls == Instant.class) {
                        targetInterceptor = NonIndexedNumericField.class;
                    } else if (Set.class.isAssignableFrom(targetCls) || List.class.isAssignableFrom(targetCls)) {
                        targetInterceptor = NonIndexedTagField.class;
                    } else if (targetCls == Point.class) {
                        targetInterceptor = NonIndexedGeoField.class;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Processing class " + entityName + " could not resolve " + cls);
                }
            }
        }
        if (targetInterceptor != null) {
            fieldMetamodelSpec.add(this.generateFieldMetamodel(entity, chain, chainedFieldName, entityField, targetInterceptor, fieldIsIndexed, collectionPrefix));
        }
        return fieldMetamodelSpec;
    }

    private Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock> generateCollectionFieldMetamodel(TypeName parentEntity, List<Element> chain, String chainedFieldName, String collectionElementName) throws IOException {
        String packageName;
        Element entity1 = chain.get(chain.size() - 1).getEnclosingElement();
        String qualifiedGenEntityName = parentEntity.toString() + "_" + chainedFieldName + "$";
        String genEntityName = qualifiedGenEntityName.substring(qualifiedGenEntityName.lastIndexOf(46) + 1);
        String entityName = collectionElementName;
        ClassName entity = ClassName.bestGuess((String)entityName);
        Map<? extends Element, String> enclosedFields = this.getInstanceFields((TypeName)entity);
        PackageElement packageElement = this.processingEnvironment.getElementUtils().getPackageOf(entity1);
        if (packageElement.isUnnamed()) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Class " + entity1.getSimpleName() + " has an unnamed package.");
            packageName = "";
        } else {
            packageName = packageElement.getQualifiedName().toString();
        }
        ArrayList interceptors = new ArrayList();
        ArrayList fields = new ArrayList();
        ArrayList initCodeBlocks = new ArrayList();
        ArrayList nestedFieldsConstants = new ArrayList();
        enclosedFields.forEach((arg_0, arg_1) -> this.lambda$generateCollectionFieldMetamodel$3((TypeName)entity, entityName, chainedFieldName, fields, interceptors, initCodeBlocks, arg_0, arg_1));
        CodeBlock.Builder blockBuilder = CodeBlock.builder();
        blockBuilder.beginControlFlow("try", new Object[0]);
        for (ObjectGraphFieldSpec ogfs : fields) {
            StringBuilder sb = new StringBuilder("$T.class");
            for (int i = 0; i < ogfs.chain().size(); ++i) {
                Element element = ogfs.chain().get(i);
                if (i != 0) {
                    sb.append(".getType()");
                }
                String formattedString = String.format("com.redis.om.spring.util.ObjectUtils.getDeclaredFieldTransitively(%s, \"%s\")", sb.toString(), element.getSimpleName());
                sb.setLength(0);
                sb.append(formattedString);
            }
            FieldSpec fieldSpec = ogfs.fieldSpec();
            blockBuilder.addStatement("$L = " + sb.toString(), new Object[]{fieldSpec.name, entity});
        }
        for (CodeBlock initCodeBlock : initCodeBlocks) {
            blockBuilder.add(initCodeBlock);
        }
        blockBuilder.nextControlFlow("catch($T | $T e)", new Object[]{NoSuchFieldException.class, SecurityException.class});
        blockBuilder.addStatement("System.err.println(e.getMessage())", new Object[0]);
        blockBuilder.endControlFlow();
        CodeBlock staticBlock = blockBuilder.build();
        TypeSpec metaClass = TypeSpec.classBuilder((String)genEntityName).superclass(CollectionField.class).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(SearchFieldAccessor.class, "searchFieldAccessor", new Modifier[0]).addParameter(Boolean.TYPE, "indexed", new Modifier[0]).addStatement("super(searchFieldAccessor, indexed)", new Object[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addFields(fields.stream().map(ObjectGraphFieldSpec::fieldSpec).toList()).addFields(nestedFieldsConstants).addStaticBlock(staticBlock).addFields(interceptors).build();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)metaClass).build();
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(qualifiedGenEntityName, new Element[0]);
        Writer writer = builderFile.openWriter();
        javaFile.writeTo((Appendable)writer);
        writer.close();
        ClassName generatedTypeName = ClassName.bestGuess((String)qualifiedGenEntityName);
        return this.generateFieldMetamodel(chain, chainedFieldName, (TypeName)generatedTypeName, true);
    }

    private List<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>> processNestedIndexableFields(TypeName entity, List<Element> chain) {
        Element fieldElement = chain.get(chain.size() - 1);
        TypeMirror typeMirror = fieldElement.asType();
        DeclaredType asDeclaredType = (DeclaredType)typeMirror;
        Element entityField = asDeclaredType.asElement();
        ArrayList<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>> fieldMetamodels = new ArrayList<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>>();
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Processing constants for " + fieldElement + " of type " + entityField);
        String entityFieldName = fieldElement.toString();
        this.messager.printMessage(Diagnostic.Kind.NOTE, "entityFieldName => " + entityFieldName);
        Map<? extends Element, String> enclosedFields = this.getInstanceFields(entityField);
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Enclosed subfield size() ==> " + enclosedFields.size());
        enclosedFields.forEach((field, getter) -> {
            boolean fieldIsIndexed;
            boolean bl = fieldIsIndexed = field.getAnnotation(Indexed.class) != null || field.getAnnotation(Searchable.class) != null;
            if (fieldIsIndexed) {
                ArrayList<Element> newChain = new ArrayList<Element>(chain);
                newChain.add((Element)field);
                fieldMetamodels.addAll(this.processFieldMetamodel(entity, entityFieldName, newChain));
            }
        });
        return fieldMetamodels;
    }

    private Map<? extends Element, String> getInstanceFields(Element element) {
        if (this.objectTypeElement.equals(element)) {
            return Collections.emptyMap();
        }
        Map getters = element.getEnclosedElements().stream().filter(ee -> ee.getKind() == ElementKind.METHOD).filter(ee -> ee.getEnclosedElements().stream().noneMatch(eee -> eee.getKind() == ElementKind.PARAMETER)).collect(Collectors.toMap(e -> e.getSimpleName().toString(), Function.identity()));
        this.messager.printMessage(Diagnostic.Kind.NOTE, "getters size() ==> " + getters.size());
        Set isGetters = getters.values().stream().map(Element::getSimpleName).map(Object::toString).filter(n -> n.startsWith(IS_PREFIX)).map(n -> n.substring(2)).map(ObjectUtils::lcfirst).collect(Collectors.toSet());
        Map results = element.getEnclosedElements().stream().filter(ee -> ee.getKind().isField() && !ee.getModifiers().contains((Object)Modifier.STATIC) && !ee.getModifiers().contains((Object)Modifier.FINAL)).collect(Collectors.toMap(Function.identity(), ee -> this.findGetter((Element)ee, getters, isGetters, element.toString(), this.lombokGetterAvailable(element, (Element)ee))));
        Types types = this.processingEnvironment.getTypeUtils();
        List<? extends TypeMirror> superTypes = types.directSupertypes(element.asType());
        superTypes.stream().map(types::asElement).filter(superElement -> superElement.getKind().isClass()).findFirst().ifPresent(superElement -> results.putAll(this.getInstanceFields((Element)superElement)));
        return results;
    }

    private Map<? extends Element, String> getInstanceFields(TypeName entity) {
        Element element = this.getElementFromTypeName(entity);
        return this.getInstanceFields(element);
    }

    private Element getElementFromTypeName(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            return this.getElementFromTypeName((TypeName)parameterizedTypeName.rawType);
        }
        if (typeName instanceof ClassName) {
            ClassName className = (ClassName)typeName;
            return this.processingEnvironment.getElementUtils().getTypeElement(className.reflectionName());
        }
        throw new IllegalArgumentException("Unknown type name: " + typeName);
    }

    private boolean lombokGetterAvailable(Element classElement, Element fieldElement) {
        boolean globalEnable = this.isLombokAnnotated(classElement, "Data") || this.isLombokAnnotated(classElement, "Getter");
        boolean localEnable = this.isLombokAnnotated(fieldElement, "Getter");
        boolean disallowedAccessLevel = DISALLOWED_ACCESS_LEVELS.contains(this.getterAccessLevel(fieldElement).orElse("No access level defined"));
        return !disallowedAccessLevel && (globalEnable || localEnable);
    }

    private boolean isLombokAnnotated(Element annotatedElement, String lombokSimpleClassName) {
        try {
            String className = "lombok." + lombokSimpleClassName;
            Class<?> clazz = Class.forName(className);
            return annotatedElement.getAnnotation(clazz) != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private Optional<String> getterAccessLevel(Element fieldElement) {
        List<? extends AnnotationMirror> mirrors = fieldElement.getAnnotationMirrors();
        Map map = mirrors.stream().filter(am -> "lombok.Getter".equals(am.getAnnotationType().toString())).findFirst().map(AnnotationMirror::getElementValues).orElse(Collections.emptyMap());
        return map.values().stream().map(AnnotationValue::toString).map(v -> v.substring(v.lastIndexOf(46) + 1)).filter(this::isAccessLevel).findFirst();
    }

    private boolean isAccessLevel(String s) {
        Set validAccessLevels = Stream.of("PACKAGE", "NONE", "PRIVATE", "MODULE", "PROTECTED", "PUBLIC").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
        return validAccessLevels.contains(s);
    }

    private String findGetter(Element field, Map<String, Element> getters, Set<String> isGetters, String entityName, boolean lombokGetterAvailable) {
        String standardJavaName;
        String fieldName = field.getSimpleName().toString();
        String getterPrefix = isGetters.contains(fieldName) ? IS_PREFIX : GET_PREFIX;
        String standardGetterName = getterPrefix + (standardJavaName = MetamodelGenerator.javaNameFromExternal(fieldName));
        Element standardGetter = getters.get(standardGetterName);
        if (standardGetter != null || lombokGetterAvailable) {
            return entityName + "::" + standardGetterName;
        }
        String lambdaName = ObjectUtils.lcfirst(entityName);
        if (!field.getModifiers().contains((Object)Modifier.PROTECTED) && !field.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return lambdaName + " -> " + lambdaName + "." + fieldName;
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, "Class " + entityName + " is not a proper JavaBean because " + field.getSimpleName().toString() + " has no standard getter.");
        return lambdaName + " -> {throw new " + IllegalJavaBeanException.class.getSimpleName() + "(" + entityName + ".class, \"" + fieldName + "\");}";
    }

    public static String staticField(String externalName) {
        Objects.requireNonNull(externalName);
        return ObjectUtils.toUnderscoreSeparated(MetamodelGenerator.javaNameFromExternal(externalName)).toUpperCase();
    }

    public static String javaNameFromExternal(String externalName) {
        Objects.requireNonNull(externalName);
        return MetamodelGenerator.replaceIfIllegalJavaIdentifierCharacter(MetamodelGenerator.replaceIfJavaUsedWord(MetamodelGenerator.nameFromExternal(externalName)));
    }

    public static String nameFromExternal(String externalName) {
        Objects.requireNonNull(externalName);
        String result = ObjectUtils.unQuote(externalName.trim());
        result = Stream.of(result.replaceAll("(\\p{Lu}+)", "_$1").split("[^\\pL\\d]")).map(String::toLowerCase).map(ObjectUtils::ucfirst).collect(Collectors.joining());
        return result;
    }

    public static String replaceIfJavaUsedWord(String word) {
        Objects.requireNonNull(word);
        if (JAVA_USED_WORDS_LOWER_CASE.contains(word.toLowerCase())) {
            return word + "_";
        }
        return word;
    }

    private Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock> generateFieldMetamodel(TypeName entity, List<Element> chain, String chainFieldName, TypeName entityField, Class<?> interceptorClass, boolean fieldIsIndexed, String collectionPrefix) {
        String fieldAccessor = MetamodelGenerator.staticField(chainFieldName);
        FieldSpec objectField = FieldSpec.builder(Field.class, (String)chainFieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        ObjectGraphFieldSpec ogf = new ObjectGraphFieldSpec(objectField, chain);
        ParameterizedTypeName interceptor = ParameterizedTypeName.get((ClassName)ClassName.get(interceptorClass), (TypeName[])new TypeName[]{entity, entityField});
        FieldSpec aField = FieldSpec.builder((TypeName)interceptor, (String)fieldAccessor, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        String searchSchemaAlias = chain.stream().map(e -> e.getSimpleName().toString()).collect(Collectors.joining("_"));
        searchSchemaAlias = collectionPrefix != null ? collectionPrefix + "_" + searchSchemaAlias : searchSchemaAlias;
        CodeBlock aFieldInit = CodeBlock.builder().addStatement("$L = new $T(new $T(\"$L\", $L),$L)", new Object[]{fieldAccessor, interceptor, SearchFieldAccessor.class, searchSchemaAlias, chainFieldName, fieldIsIndexed}).build();
        return Tuples.of(ogf, aField, aFieldInit);
    }

    private Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock> generateFieldMetamodel(List<Element> chain, String chainFieldName, TypeName interceptor, boolean fieldIsIndexed) {
        String fieldAccessor = MetamodelGenerator.staticField(chainFieldName);
        FieldSpec objectField = FieldSpec.builder(Field.class, (String)chainFieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        ObjectGraphFieldSpec ogf = new ObjectGraphFieldSpec(objectField, chain);
        FieldSpec aField = FieldSpec.builder((TypeName)interceptor, (String)fieldAccessor, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        String searchSchemaAlias = chain.stream().map(e -> e.getSimpleName().toString()).collect(Collectors.joining("_"));
        CodeBlock aFieldInit = CodeBlock.builder().addStatement("$L = new $T(new $T(\"$L\", $L),$L)", new Object[]{fieldAccessor, interceptor, SearchFieldAccessor.class, searchSchemaAlias, chainFieldName, fieldIsIndexed}).build();
        return Tuples.of(ogf, aField, aFieldInit);
    }

    private Pair<FieldSpec, CodeBlock> generateUnboundMetamodelField(TypeName entity, String name, String alias, Class<?> type) {
        ParameterizedTypeName interceptor = ParameterizedTypeName.get((ClassName)ClassName.get(MetamodelField.class), (TypeName[])new TypeName[]{entity, TypeName.get(type)});
        FieldSpec aField = FieldSpec.builder((TypeName)interceptor, (String)name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        CodeBlock aFieldInit = CodeBlock.builder().addStatement("$L = new $T(\"$L\", $T.class, $L)", new Object[]{name, interceptor, alias, type, true}).build();
        return Tuples.of(aField, aFieldInit);
    }

    public static String replaceIfIllegalJavaIdentifierCharacter(String word) {
        Objects.requireNonNull(word);
        if (word.isEmpty()) {
            return REPLACEMENT_CHARACTER.toString();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (i == 0) {
                if (Character.isJavaIdentifierStart(c)) {
                    sb.append(c);
                    continue;
                }
                if (Character.isJavaIdentifierPart(c)) {
                    sb.append(REPLACEMENT_CHARACTER).append(c);
                    continue;
                }
                sb.append(REPLACEMENT_CHARACTER);
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            sb.append(REPLACEMENT_CHARACTER);
        }
        return sb.toString();
    }

    private /* synthetic */ void lambda$generateCollectionFieldMetamodel$3(TypeName entity, String entityName, String chainedFieldName, List fields, List interceptors, List initCodeBlocks, Element field, String getter) {
        List<Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock>> fieldMetamodels = this.processFieldMetamodel(entity, entityName, List.of(field), chainedFieldName);
        for (Triple<ObjectGraphFieldSpec, FieldSpec, CodeBlock> fieldMetamodel : fieldMetamodels) {
            FieldSpec fieldSpec = fieldMetamodel.getSecond();
            fields.add(fieldMetamodel.getFirst());
            interceptors.add(fieldMetamodel.getSecond());
            initCodeBlocks.add(fieldMetamodel.getThird());
            if (!fieldSpec.type.toString().startsWith(VectorField.class.getName())) continue;
            String fieldName = fieldMetamodel.getFirst().fieldSpec().name;
            Pair<FieldSpec, CodeBlock> vectorFieldScore = this.generateUnboundMetamodelField(entity, "_" + fieldSpec.name + "_SCORE", "__" + fieldName + "_score", Double.class);
            interceptors.add(vectorFieldScore.getFirst());
            initCodeBlocks.add(vectorFieldScore.getSecond());
        }
    }
}

