/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.keyvalue.core.CriteriaAccessor;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.keyvalue.core.SortAccessor;
import org.springframework.data.keyvalue.core.SpelSortAccessor;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.redis.core.RedisKeyValueAdapter;
import org.springframework.data.redis.repository.query.RedisOperationChain;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class EnhancedRedisQueryEngine
extends QueryEngine<RedisKeyValueAdapter, RedisOperationChain, Comparator<?>> {
    private static final Log logger = LogFactory.getLog(EnhancedRedisQueryEngine.class);

    public EnhancedRedisQueryEngine() {
        this(new RedisCriteriaAccessor(), (SortAccessor<Comparator<?>>)new SpelSortAccessor(new SpelExpressionParser()));
    }

    public EnhancedRedisQueryEngine(CriteriaAccessor<RedisOperationChain> criteriaAccessor, SortAccessor<Comparator<?>> sortAccessor) {
        super(criteriaAccessor, sortAccessor);
    }

    public <T> Collection<T> execute(RedisOperationChain criteria, Comparator<?> sort, long offset, int rows, String keyspace, Class<T> type) {
        logger.debug((Object)String.format("Executing %s", criteria));
        List<?> result = List.of();
        if (sort != null) {
            result.sort(sort);
        }
        return result;
    }

    public Collection<?> execute(RedisOperationChain criteria, Comparator<?> sort, long offset, int rows, String keyspace) {
        return this.execute(criteria, sort, offset, rows, keyspace, Object.class);
    }

    public long count(RedisOperationChain criteria, String keyspace) {
        if (criteria == null || criteria.isEmpty()) {
            RedisKeyValueAdapter adapter = (RedisKeyValueAdapter)this.getAdapter();
            return adapter != null ? adapter.count(keyspace) : 0L;
        }
        return 0L;
    }

    static class RedisCriteriaAccessor
    implements CriteriaAccessor<RedisOperationChain> {
        RedisCriteriaAccessor() {
        }

        public RedisOperationChain resolve(KeyValueQuery<?> query) {
            return (RedisOperationChain)query.getCriteria();
        }
    }
}

