/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.util;

import com.redis.lettucemod.RedisModulesClient;
import com.redis.lettucemod.api.StatefulRedisModulesConnection;
import com.redis.lettucemod.cluster.RedisModulesClusterClient;
import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.CreateOptions;
import com.redis.lettucemod.search.Field;
import com.redis.lettucemod.search.IndexInfo;
import com.redis.lettucemod.search.TagField;
import com.redis.lettucemod.search.TextField;
import com.redis.lettucemod.util.IndexDefinitionParser;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceStrings;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class RedisModulesUtils {
    private static final String FIELD_FIELDS = "fields";
    private static final String FIELD_ATTRIBUTES = "attributes";
    public static final String ERROR_UNKNOWN_INDEX_NAME = "Unknown Index name";

    private RedisModulesUtils() {
    }

    public static Optional<IndexInfo> indexInfo(Supplier<List<Object>> infoList) {
        try {
            return Optional.of(RedisModulesUtils.indexInfo(infoList.get()));
        }
        catch (RedisCommandExecutionException e) {
            if (ERROR_UNKNOWN_INDEX_NAME.equalsIgnoreCase(e.getMessage())) {
                return Optional.empty();
            }
            throw e;
        }
    }

    public static IndexInfo indexInfo(List<Object> infoList) {
        LettuceAssert.isTrue((infoList.size() % 2 == 0 ? 1 : 0) != 0, (String)"List must be a multiple of 2 and contain a sequence of field1, value1, field2, value2, ..., fieldN, valueN");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < infoList.size(); i += 2) {
            map.put((String)infoList.get(i), infoList.get(i + 1));
        }
        IndexInfo indexInfo = new IndexInfo();
        indexInfo.setIndexName(RedisModulesUtils.getString(map.get("index_name")));
        CreateOptions.Builder<String, String> options = CreateOptions.builder();
        RedisModulesUtils.indexOptions((List)map.get("index_options"), options);
        RedisModulesUtils.indexDefinition((List)map.get("index_definition"), options);
        indexInfo.setIndexOptions(options.build());
        if (map.containsKey(FIELD_FIELDS)) {
            indexInfo.setFields(RedisModulesUtils.fieldsFromFields(map.getOrDefault(FIELD_FIELDS, new ArrayList())));
        }
        if (map.containsKey(FIELD_ATTRIBUTES)) {
            indexInfo.setFields(RedisModulesUtils.fieldsFromAttributes(map.getOrDefault(FIELD_ATTRIBUTES, new ArrayList())));
        }
        indexInfo.setNumDocs(RedisModulesUtils.getDouble(map.get("num_docs")));
        indexInfo.setMaxDocId(RedisModulesUtils.getString(map.get("max_doc_id")));
        indexInfo.setNumTerms(RedisModulesUtils.toLong(map, "num_terms"));
        indexInfo.setNumRecords(RedisModulesUtils.toLong(map, "num_records"));
        indexInfo.setInvertedSizeMb(RedisModulesUtils.getDouble(map.get("inverted_sz_mb")));
        indexInfo.setTotalInvertedIndexBlocks(RedisModulesUtils.toLong(map, "total_inverted_index_blocks"));
        indexInfo.setVectorIndexSizeMb(RedisModulesUtils.getDouble(map.get("vector_index_sz_mb")));
        indexInfo.setOffsetVectorsSizeMb(RedisModulesUtils.getDouble(map.get("offset_vectors_sz_mb")));
        indexInfo.setDocTableSizeMb(RedisModulesUtils.getDouble(map.get("doc_table_size_mb")));
        indexInfo.setSortableValuesSizeMb(RedisModulesUtils.getDouble(map.get("sortable_values_size_mb")));
        indexInfo.setKeyTableSizeMb(RedisModulesUtils.getDouble(map.get("key_table_size_mb")));
        indexInfo.setRecordsPerDocAvg(RedisModulesUtils.getDouble(map.get("records_per_doc_avg")));
        indexInfo.setBytesPerRecordAvg(RedisModulesUtils.getDouble(map.get("bytes_per_record_avg")));
        indexInfo.setOffsetsPerTermAvg(RedisModulesUtils.getDouble(map.get("offsets_per_term_avg")));
        indexInfo.setOffsetBitsPerRecordAvg(RedisModulesUtils.getDouble(map.get("offset_bits_per_record_avg")));
        indexInfo.setGcStats((List)map.get("gc_stats"));
        indexInfo.setCursorStats((List)map.get("cursor_stats"));
        return indexInfo;
    }

    private static void indexOptions(List<Object> list, CreateOptions.Builder<String, String> options) {
        for (String string : list) {
            RedisModulesUtils.matchOption(string, SearchCommandKeyword.NOOFFSETS, options::noOffsets);
            RedisModulesUtils.matchOption(string, SearchCommandKeyword.NOHL, options::noHL);
            RedisModulesUtils.matchOption(string, SearchCommandKeyword.NOFIELDS, options::noFields);
            RedisModulesUtils.matchOption(string, SearchCommandKeyword.NOFREQS, options::noFreqs);
            RedisModulesUtils.matchOption(string, SearchCommandKeyword.MAXTEXTFIELDS, options::maxTextFields);
        }
    }

    private static void matchOption(String key, SearchCommandKeyword keyword, Consumer<Boolean> setter) {
        if (key.toUpperCase().equals(keyword.name())) {
            setter.accept(true);
        }
    }

    private static void indexDefinition(List<Object> list, CreateOptions.Builder<String, String> options) {
        new IndexDefinitionParser(list, options).parse();
    }

    private static Long getLong(Object object) {
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        return null;
    }

    static Double getDouble(Object object) {
        if (object instanceof String) {
            return LettuceStrings.toDouble((String)((String)object));
        }
        if (object instanceof Long) {
            return ((Long)object).doubleValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        return null;
    }

    private static String getString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    private static List<Field<String>> fieldsFromAttributes(List<Object> list) {
        ArrayList<Field<String>> fields = new ArrayList<Field<String>>();
        for (Object object : list) {
            List attributes = (List)object;
            Field<String> field = RedisModulesUtils.field((String)attributes.get(5), (String)attributes.get(1));
            field.setAs((String)attributes.get(3));
            if (attributes.size() > 6) {
                RedisModulesUtils.populateField(field, attributes.subList(6, attributes.size()));
            }
            fields.add(field);
        }
        return fields;
    }

    private static void populateField(Field<String> field, List<Object> attributes) {
        if (field.getType() == Field.Type.TAG) {
            LettuceAssert.isTrue((boolean)SearchCommandKeyword.SEPARATOR.name().equals(attributes.remove(0)), (String)"Wrong attribute name");
            TagField tagField = (TagField)field;
            String separator = (String)attributes.remove(0);
            if (!separator.isEmpty()) {
                tagField.setSeparator(separator.charAt(0));
            }
            tagField.setCaseSensitive(attributes.contains(SearchCommandKeyword.CASESENSITIVE.name()));
        } else if (field.getType() == Field.Type.TEXT) {
            LettuceAssert.isTrue((boolean)SearchCommandKeyword.WEIGHT.name().equals(attributes.remove(0)), (String)"Wrong attribute name");
            TextField textField = (TextField)field;
            Object weight = attributes.remove(0);
            textField.setWeight(RedisModulesUtils.getDouble(weight));
            textField.setNoStem(attributes.contains(SearchCommandKeyword.NOSTEM.name()));
        }
        field.setNoIndex(attributes.contains(SearchCommandKeyword.NOINDEX.name()));
        field.setSortable(attributes.contains(SearchCommandKeyword.SORTABLE.name()));
        field.setUnNormalizedForm(attributes.contains(SearchCommandKeyword.UNF.name()));
    }

    private static List<Field<String>> fieldsFromFields(List<Object> list) {
        ArrayList<Field<String>> fields = new ArrayList<Field<String>>();
        for (Object infoObject : list) {
            List info = (List)infoObject;
            Field<String> field = RedisModulesUtils.field((String)info.get(2), (String)info.get(0));
            RedisModulesUtils.populateField(field, info.subList(3, info.size()));
            fields.add(field);
        }
        return fields;
    }

    private static Field<String> field(String type, String name) {
        if (type.toUpperCase().equals(SearchCommandKeyword.GEO.name())) {
            return Field.geo(name).build();
        }
        if (type.toUpperCase().equals(SearchCommandKeyword.NUMERIC.name())) {
            return Field.numeric(name).build();
        }
        if (type.toUpperCase().equals(SearchCommandKeyword.TAG.name())) {
            return Field.tag(name).build();
        }
        if (type.toUpperCase().equals(SearchCommandKeyword.TEXT.name())) {
            return Field.text(name).build();
        }
        if (type.toUpperCase().equals(SearchCommandKeyword.VECTOR.name())) {
            return Field.vector(name).build();
        }
        throw new IllegalArgumentException("Unknown field type: " + type);
    }

    private static Long toLong(Map<String, Object> map, String key) {
        if (!map.containsKey(key)) {
            return null;
        }
        return RedisModulesUtils.getLong(map.get(key));
    }

    public static String escapeTag(String value) {
        return value.replaceAll("([^a-zA-Z0-9])", "\\\\$1");
    }

    public static String toString(InputStream inputStream, Charset charset) {
        return RedisModulesUtils.toString(new InputStreamReader(inputStream, charset));
    }

    public static String toString(InputStreamReader reader) {
        return new BufferedReader(reader).lines().collect(Collectors.joining(System.lineSeparator()));
    }

    public static String toString(InputStream inputStream) {
        return RedisModulesUtils.toString(new InputStreamReader(inputStream));
    }

    public static StatefulRedisModulesConnection<String, String> connection(AbstractRedisClient client) {
        return RedisModulesUtils.connection(client, StringCodec.UTF8);
    }

    public static <K, V> StatefulRedisModulesConnection<K, V> connection(AbstractRedisClient client, RedisCodec<K, V> codec) {
        if (client instanceof RedisModulesClusterClient) {
            return ((RedisModulesClusterClient)client).connect((RedisCodec)codec);
        }
        return ((RedisModulesClient)client).connect((RedisCodec)codec);
    }

    public static StatefulRedisPubSubConnection<String, String> pubSubConnection(AbstractRedisClient client) {
        return RedisModulesUtils.pubSubConnection(client, StringCodec.UTF8);
    }

    public static <K, V> StatefulRedisPubSubConnection<K, V> pubSubConnection(AbstractRedisClient client, RedisCodec<K, V> codec) {
        if (client instanceof RedisModulesClusterClient) {
            return ((RedisModulesClusterClient)client).connectPubSub(codec);
        }
        return ((RedisModulesClient)client).connectPubSub(codec);
    }
}

