/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.Limit;
import com.redis.lettucemod.search.Parameter;
import com.redis.lettucemod.search.RediSearchArgument;
import com.redis.lettucemod.search.SearchCommandArgs;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

public class BaseSearchOptions<K, V>
implements RediSearchArgument<K, V> {
    private boolean verbatim;
    private Optional<Duration> timeout = Optional.empty();
    private Optional<Limit> limit = Optional.empty();
    private List<Parameter<K, V>> params = new ArrayList<Parameter<K, V>>();
    private OptionalInt dialect = OptionalInt.empty();

    protected BaseSearchOptions() {
    }

    protected BaseSearchOptions(Builder<K, V, ?> builder) {
        this.verbatim = ((Builder)builder).verbatim;
        this.timeout = ((Builder)builder).timeout;
        this.limit = ((Builder)builder).limit;
        this.params = ((Builder)builder).params;
        this.dialect = ((Builder)builder).dialect;
    }

    public Optional<Duration> getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Optional<Duration> timeout) {
        this.timeout = timeout;
    }

    public boolean isVerbatim() {
        return this.verbatim;
    }

    public void setVerbatim(boolean verbatim) {
        this.verbatim = verbatim;
    }

    public Optional<Limit> getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = Optional.of(limit);
    }

    public List<Parameter<K, V>> getParams() {
        return this.params;
    }

    public void setParams(List<Parameter<K, V>> params) {
        this.params = params;
    }

    public OptionalInt getDialect() {
        return this.dialect;
    }

    public void setDialect(OptionalInt dialect) {
        this.dialect = dialect;
    }

    @Override
    public void build(SearchCommandArgs<K, V> args) {
        if (this.verbatim) {
            args.add(SearchCommandKeyword.VERBATIM);
        }
        this.timeout.ifPresent(t -> args.add(SearchCommandKeyword.TIMEOUT).add(t.toMillis()));
        this.limit.ifPresent(l -> l.build(args));
        if (!this.params.isEmpty()) {
            args.add(SearchCommandKeyword.PARAMS);
            args.add((long)this.params.size() * 2L);
            this.params.forEach(p -> args.addKey(p.getName()).addValue(p.getValue()));
        }
        this.dialect.ifPresent(d -> args.add(SearchCommandKeyword.DIALECT).add(d));
    }

    public static class Builder<K, V, B extends Builder<K, V, B>> {
        private boolean verbatim;
        private Optional<Duration> timeout = Optional.empty();
        private final List<Parameter<K, V>> params = new ArrayList<Parameter<K, V>>();
        private Optional<Limit> limit = Optional.empty();
        private OptionalInt dialect = OptionalInt.empty();

        protected Builder() {
        }

        public B verbatim() {
            return this.verbatim(true);
        }

        public B verbatim(boolean verbatim) {
            this.verbatim = verbatim;
            return (B)this;
        }

        public B timeout(long millis) {
            return this.timeout(Duration.ofMillis(millis));
        }

        public B timeout(Duration timeout) {
            this.timeout = Optional.of(timeout);
            return (B)this;
        }

        public B param(K name, V value) {
            this.params.add(Parameter.of(name, value));
            return (B)this;
        }

        public B params(Parameter<K, V> ... params) {
            this.params.addAll(Arrays.asList(params));
            return (B)this;
        }

        public B params(Map<K, V> map) {
            map.forEach(this::param);
            return (B)this;
        }

        public B limit(Limit limit) {
            this.limit = Optional.of(limit);
            return (B)this;
        }

        public B limit(long offset, long num) {
            return this.limit(Limit.offset(offset).num(num));
        }

        public B dialect(int version) {
            this.dialect = OptionalInt.of(version);
            return (B)this;
        }
    }
}

