/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.cluster;

import com.redis.lettucemod.RedisModulesAsyncCommandsImpl;
import com.redis.lettucemod.api.async.RedisModulesAsyncCommands;
import com.redis.lettucemod.cluster.api.StatefulRedisModulesClusterConnection;
import com.redis.lettucemod.cluster.api.async.RedisModulesAdvancedClusterAsyncCommands;
import com.redis.lettucemod.gears.Execution;
import com.redis.lettucemod.gears.ExecutionDetails;
import com.redis.lettucemod.gears.ExecutionMode;
import com.redis.lettucemod.gears.Registration;
import com.redis.lettucemod.json.ArrpopOptions;
import com.redis.lettucemod.json.GetOptions;
import com.redis.lettucemod.json.SetMode;
import com.redis.lettucemod.json.Slice;
import com.redis.lettucemod.output.ExecutionResults;
import com.redis.lettucemod.search.AggregateOptions;
import com.redis.lettucemod.search.AggregateResults;
import com.redis.lettucemod.search.AggregateWithCursorResults;
import com.redis.lettucemod.search.CursorOptions;
import com.redis.lettucemod.search.Field;
import com.redis.lettucemod.search.SearchOptions;
import com.redis.lettucemod.search.SearchResults;
import com.redis.lettucemod.search.Suggestion;
import com.redis.lettucemod.search.SuggetOptions;
import com.redis.lettucemod.timeseries.AddOptions;
import com.redis.lettucemod.timeseries.AlterOptions;
import com.redis.lettucemod.timeseries.CreateOptions;
import com.redis.lettucemod.timeseries.CreateRuleOptions;
import com.redis.lettucemod.timeseries.GetResult;
import com.redis.lettucemod.timeseries.IncrbyOptions;
import com.redis.lettucemod.timeseries.KeySample;
import com.redis.lettucemod.timeseries.MGetOptions;
import com.redis.lettucemod.timeseries.MRangeOptions;
import com.redis.lettucemod.timeseries.RangeOptions;
import com.redis.lettucemod.timeseries.RangeResult;
import com.redis.lettucemod.timeseries.Sample;
import com.redis.lettucemod.timeseries.TimeRange;
import io.lettuce.core.KeyValue;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.cluster.MultiNodeExecution;
import io.lettuce.core.cluster.PipelinedRedisFuture;
import io.lettuce.core.cluster.RedisAdvancedClusterAsyncCommandsImpl;
import io.lettuce.core.cluster.SlotHash;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.KeyValueStreamingChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RedisModulesAdvancedClusterAsyncCommandsImpl<K, V>
extends RedisAdvancedClusterAsyncCommandsImpl<K, V>
implements RedisModulesAdvancedClusterAsyncCommands<K, V> {
    private final RedisModulesAsyncCommandsImpl<K, V> delegate;
    private final RedisCodec<K, V> codec;

    public RedisModulesAdvancedClusterAsyncCommandsImpl(StatefulRedisModulesClusterConnection<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
        this.codec = codec;
        this.delegate = new RedisModulesAsyncCommandsImpl<K, V>(connection, codec);
    }

    @Override
    public RedisModulesAdvancedClusterAsyncCommands<K, V> getConnection(String nodeId) {
        return (RedisModulesAdvancedClusterAsyncCommands)super.getConnection(nodeId);
    }

    @Override
    public RedisModulesAdvancedClusterAsyncCommands<K, V> getConnection(String host, int port) {
        return (RedisModulesAdvancedClusterAsyncCommands)super.getConnection(host, port);
    }

    @Override
    public StatefulRedisModulesClusterConnection<K, V> getStatefulConnection() {
        return (StatefulRedisModulesClusterConnection)super.getStatefulConnection();
    }

    @Override
    public RedisFuture<String> rgAbortexecution(String id) {
        return this.delegate.rgAbortexecution(id);
    }

    @Override
    public RedisFuture<List<V>> rgConfigget(K ... keys) {
        return this.delegate.rgConfigget(keys);
    }

    @Override
    public RedisFuture<List<V>> rgConfigset(Map<K, V> map) {
        return this.delegate.rgConfigset(map);
    }

    @Override
    public RedisFuture<String> rgDropexecution(String id) {
        return this.delegate.rgDropexecution(id);
    }

    @Override
    public RedisFuture<List<Execution>> rgDumpexecutions() {
        return this.delegate.rgDumpexecutions();
    }

    @Override
    public RedisFuture<List<Registration>> rgDumpregistrations() {
        return this.delegate.rgDumpregistrations();
    }

    @Override
    public RedisFuture<ExecutionDetails> rgGetexecution(String id) {
        return this.delegate.rgGetexecution(id);
    }

    @Override
    public RedisFuture<ExecutionDetails> rgGetexecution(String id, ExecutionMode mode) {
        return this.delegate.rgGetexecution(id, mode);
    }

    @Override
    public RedisFuture<ExecutionResults> rgGetresults(String id) {
        return this.delegate.rgGetresults(id);
    }

    @Override
    public RedisFuture<ExecutionResults> rgGetresultsblocking(String id) {
        return this.delegate.rgGetresultsblocking(id);
    }

    @Override
    public RedisFuture<ExecutionResults> rgPyexecute(String function, V ... requirements) {
        return this.delegate.rgPyexecute(function, requirements);
    }

    @Override
    public RedisFuture<String> rgPyexecuteUnblocking(String function, V ... requirements) {
        return this.delegate.rgPyexecuteUnblocking(function, requirements);
    }

    @Override
    public RedisFuture<List<Object>> rgTrigger(String trigger, V ... args) {
        return this.delegate.rgTrigger(trigger, args);
    }

    @Override
    public RedisFuture<String> rgUnregister(String id) {
        return this.delegate.rgUnregister(id);
    }

    @Override
    public RedisFuture<String> ftCreate(K index, Field<K> ... fields) {
        return this.ftCreate(index, (com.redis.lettucemod.search.CreateOptions<K, V>)null, fields);
    }

    @Override
    public RedisFuture<String> ftCreate(K index, com.redis.lettucemod.search.CreateOptions<K, V> options, Field<K> ... fields) {
        return MultiNodeExecution.firstOfAsync((Map)this.executeOnUpstream(commands -> ((RedisModulesAsyncCommands)commands).ftCreate(index, options, fields)));
    }

    @Override
    public RedisFuture<String> ftDropindex(K index) {
        return MultiNodeExecution.firstOfAsync((Map)this.executeOnUpstream(commands -> ((RedisModulesAsyncCommands)commands).ftDropindex(index)));
    }

    @Override
    public RedisFuture<String> ftDropindexDeleteDocs(K index) {
        return MultiNodeExecution.firstOfAsync((Map)this.executeOnUpstream(commands -> ((RedisModulesAsyncCommands)commands).ftDropindexDeleteDocs(index)));
    }

    @Override
    public RedisFuture<String> ftAlter(K index, Field<K> field) {
        return MultiNodeExecution.firstOfAsync((Map)this.executeOnUpstream(commands -> ((RedisModulesAsyncCommands)commands).ftAlter(index, field)));
    }

    @Override
    public RedisFuture<List<Object>> ftInfo(K index) {
        return this.delegate.ftInfo(index);
    }

    @Override
    public RedisFuture<String> ftAliasadd(K name, K index) {
        return MultiNodeExecution.firstOfAsync((Map)this.executeOnUpstream(commands -> ((RedisModulesAsyncCommands)commands).ftAliasadd(name, index)));
    }

    @Override
    public RedisFuture<String> ftAliasupdate(K name, K index) {
        return MultiNodeExecution.firstOfAsync((Map)this.executeOnUpstream(commands -> ((RedisModulesAsyncCommands)commands).ftAliasupdate(name, index)));
    }

    @Override
    public RedisFuture<String> ftAliasdel(K name) {
        return MultiNodeExecution.firstOfAsync((Map)this.executeOnUpstream(commands -> ((RedisModulesAsyncCommands)commands).ftAliasdel(name)));
    }

    @Override
    public RedisFuture<List<K>> ftList() {
        return this.delegate.ftList();
    }

    @Override
    public RedisFuture<SearchResults<K, V>> ftSearch(K index, V query) {
        return this.delegate.ftSearch(index, query);
    }

    @Override
    public RedisFuture<SearchResults<K, V>> ftSearch(K index, V query, SearchOptions<K, V> options) {
        return this.delegate.ftSearch(index, query, options);
    }

    @Override
    public RedisFuture<AggregateResults<K>> ftAggregate(K index, V query) {
        return this.delegate.ftAggregate(index, query);
    }

    @Override
    public RedisFuture<AggregateResults<K>> ftAggregate(K index, V query, AggregateOptions<K, V> options) {
        return this.delegate.ftAggregate(index, query, options);
    }

    @Override
    public RedisFuture<AggregateWithCursorResults<K>> ftAggregate(K index, V query, CursorOptions cursor) {
        return this.delegate.ftAggregate(index, query, cursor);
    }

    @Override
    public RedisFuture<AggregateWithCursorResults<K>> ftAggregate(K index, V query, CursorOptions cursor, AggregateOptions<K, V> options) {
        return this.delegate.ftAggregate(index, query, cursor, options);
    }

    @Override
    public RedisFuture<AggregateWithCursorResults<K>> ftCursorRead(K index, long cursor) {
        return this.delegate.ftCursorRead(index, cursor);
    }

    @Override
    public RedisFuture<AggregateWithCursorResults<K>> ftCursorRead(K index, long cursor, long count) {
        return this.delegate.ftCursorRead(index, cursor, count);
    }

    @Override
    public RedisFuture<String> ftCursorDelete(K index, long cursor) {
        return this.delegate.ftCursorDelete(index, cursor);
    }

    @Override
    public RedisFuture<List<V>> ftTagvals(K index, K field) {
        return this.delegate.ftTagvals(index, field);
    }

    @Override
    public RedisFuture<Long> ftSugadd(K key, Suggestion<V> suggestion) {
        return this.delegate.ftSugadd(key, suggestion);
    }

    @Override
    public RedisFuture<Long> ftSugaddIncr(K key, Suggestion<V> suggestion) {
        return this.delegate.ftSugaddIncr(key, suggestion);
    }

    @Override
    public RedisFuture<List<Suggestion<V>>> ftSugget(K key, V prefix) {
        return this.delegate.ftSugget(key, prefix);
    }

    @Override
    public RedisFuture<List<Suggestion<V>>> ftSugget(K key, V prefix, SuggetOptions options) {
        return this.delegate.ftSugget(key, prefix, options);
    }

    @Override
    public RedisFuture<Boolean> ftSugdel(K key, V string) {
        return this.delegate.ftSugdel(key, string);
    }

    @Override
    public RedisFuture<Long> ftSuglen(K key) {
        return this.delegate.ftSuglen(key);
    }

    @Override
    public RedisFuture<Long> ftDictadd(K dict, V ... terms) {
        return MultiNodeExecution.firstOfAsync((Map)this.executeOnUpstream(commands -> ((RedisModulesAsyncCommands)commands).ftDictadd(dict, terms)));
    }

    @Override
    public RedisFuture<Long> ftDictdel(K dict, V ... terms) {
        return MultiNodeExecution.firstOfAsync((Map)this.executeOnUpstream(commands -> ((RedisModulesAsyncCommands)commands).ftDictdel(dict, terms)));
    }

    @Override
    public RedisFuture<List<V>> ftDictdump(K dict) {
        return this.delegate.ftDictdump(dict);
    }

    @Override
    public RedisFuture<String> tsCreate(K key, CreateOptions<K, V> options) {
        return this.delegate.tsCreate(key, options);
    }

    @Override
    public RedisFuture<String> tsAlter(K key, AlterOptions<K, V> options) {
        return this.delegate.tsAlter(key, options);
    }

    @Override
    public RedisFuture<Long> tsAdd(K key, Sample sample) {
        return this.delegate.tsAdd(key, sample);
    }

    @Override
    public RedisFuture<Long> tsAdd(K key, Sample sample, AddOptions<K, V> options) {
        return this.delegate.tsAdd(key, sample, options);
    }

    @Override
    public RedisFuture<List<Long>> tsMadd(KeySample<K> ... samples) {
        return this.delegate.tsMadd(samples);
    }

    @Override
    public RedisFuture<Long> tsDecrby(K key, double value) {
        return this.delegate.tsDecrby(key, value);
    }

    @Override
    public RedisFuture<Long> tsDecrby(K key, double value, IncrbyOptions<K, V> options) {
        return this.delegate.tsDecrby(key, value, options);
    }

    @Override
    public RedisFuture<Long> tsIncrby(K key, double value) {
        return this.delegate.tsIncrby(key, value);
    }

    @Override
    public RedisFuture<Long> tsIncrby(K key, double value, IncrbyOptions<K, V> options) {
        return this.delegate.tsIncrby(key, value, options);
    }

    @Override
    public RedisFuture<String> tsCreaterule(K sourceKey, K destKey, CreateRuleOptions options) {
        return this.delegate.tsCreaterule(sourceKey, destKey, options);
    }

    @Override
    public RedisFuture<String> tsDeleterule(K sourceKey, K destKey) {
        return this.delegate.tsDeleterule(sourceKey, destKey);
    }

    @Override
    public RedisFuture<List<Sample>> tsRange(K key, TimeRange range) {
        return this.delegate.tsRange(key, range);
    }

    @Override
    public RedisFuture<List<Sample>> tsRange(K key, TimeRange range, RangeOptions options) {
        return this.delegate.tsRange(key, range, options);
    }

    @Override
    public RedisFuture<List<Sample>> tsRevrange(K key, TimeRange range) {
        return this.delegate.tsRevrange(key, range);
    }

    @Override
    public RedisFuture<List<Sample>> tsRevrange(K key, TimeRange range, RangeOptions options) {
        return this.delegate.tsRevrange(key, range, options);
    }

    @Override
    public RedisFuture<List<RangeResult<K, V>>> tsMrange(TimeRange range) {
        return this.delegate.tsMrange(range);
    }

    @Override
    public RedisFuture<List<RangeResult<K, V>>> tsMrange(TimeRange range, MRangeOptions<K, V> options) {
        return this.delegate.tsMrange(range, options);
    }

    @Override
    public RedisFuture<List<RangeResult<K, V>>> tsMrevrange(TimeRange range) {
        return this.delegate.tsMrevrange(range);
    }

    @Override
    public RedisFuture<List<RangeResult<K, V>>> tsMrevrange(TimeRange range, MRangeOptions<K, V> options) {
        return this.delegate.tsMrevrange(range, options);
    }

    @Override
    public RedisFuture<Sample> tsGet(K key) {
        return this.delegate.tsGet(key);
    }

    @Override
    public RedisFuture<List<GetResult<K, V>>> tsMget(MGetOptions<K, V> options) {
        return this.delegate.tsMget(options);
    }

    @Override
    public RedisFuture<List<GetResult<K, V>>> tsMget(V ... filters) {
        return this.delegate.tsMget(filters);
    }

    @Override
    public RedisFuture<List<GetResult<K, V>>> tsMgetWithLabels(V ... filters) {
        return this.delegate.tsMgetWithLabels(filters);
    }

    @Override
    public RedisFuture<List<Object>> tsInfo(K key) {
        return this.delegate.tsInfo(key);
    }

    @Override
    public RedisFuture<List<Object>> tsInfoDebug(K key) {
        return this.delegate.tsInfoDebug(key);
    }

    @Override
    public RedisFuture<List<V>> tsQueryIndex(V ... filters) {
        return this.delegate.tsQueryIndex(filters);
    }

    @Override
    public RedisFuture<Long> tsDel(K key, TimeRange timeRange) {
        return this.delegate.tsDel(key, timeRange);
    }

    @Override
    public RedisFuture<Long> jsonDel(K key) {
        return this.delegate.jsonDel(key);
    }

    @Override
    public RedisFuture<Long> jsonDel(K key, String path) {
        return this.delegate.jsonDel(key, path);
    }

    @Override
    public RedisFuture<V> jsonGet(K key, K ... paths) {
        return this.delegate.jsonGet(key, paths);
    }

    @Override
    public RedisFuture<V> jsonGet(K key, GetOptions options, K ... paths) {
        return this.delegate.jsonGet(key, options, paths);
    }

    @Override
    public RedisFuture<List<KeyValue<K, V>>> jsonMget(String path, K ... keys) {
        return this.jsonMget(path, (Iterable<K>)Arrays.asList(keys));
    }

    @Override
    public RedisFuture<Long> jsonMget(KeyValueStreamingChannel<K, V> channel, String path, K ... keys) {
        return this.jsonMget(channel, path, (Iterable<K>)Arrays.asList(keys));
    }

    public RedisFuture<List<KeyValue<K, V>>> jsonMget(String path, Iterable<K> keys) {
        Map partitioned = SlotHash.partition(this.codec, keys);
        if (partitioned.size() < 2) {
            return this.delegate.jsonMget(path, keys);
        }
        Map slots = SlotHash.getSlots((Map)partitioned);
        HashMap executions = new HashMap();
        for (Map.Entry entry : partitioned.entrySet()) {
            RedisFuture<List<KeyValue<K, V>>> mget = this.delegate.jsonMget(path, (Iterable)entry.getValue());
            executions.put((Integer)entry.getKey(), mget);
        }
        return new PipelinedRedisFuture(executions, objectPipelinedRedisFuture -> {
            ArrayList<KeyValue> result = new ArrayList<KeyValue>();
            for (Object opKey : keys) {
                int slot = (Integer)slots.get(opKey);
                int position = ((List)partitioned.get(slot)).indexOf(opKey);
                RedisFuture listRedisFuture = (RedisFuture)executions.get(slot);
                result.add((KeyValue)MultiNodeExecution.execute(() -> (KeyValue)((List)listRedisFuture.get()).get(position)));
            }
            return result;
        });
    }

    public RedisFuture<Long> jsonMget(KeyValueStreamingChannel<K, V> channel, String path, Iterable<K> keys) {
        Map partitioned = SlotHash.partition(this.codec, keys);
        if (partitioned.size() < 2) {
            return this.delegate.jsonMget(channel, path, keys);
        }
        HashMap<Integer, RedisFuture<Long>> executions = new HashMap<Integer, RedisFuture<Long>>();
        for (Map.Entry entry : partitioned.entrySet()) {
            RedisFuture<Long> del = this.delegate.jsonMget(channel, path, (Iterable)entry.getValue());
            executions.put((Integer)entry.getKey(), del);
        }
        return MultiNodeExecution.aggregateAsync(executions);
    }

    @Override
    public RedisFuture<String> jsonSet(K key, String path, V json) {
        return this.delegate.jsonSet(key, path, json);
    }

    @Override
    public RedisFuture<String> jsonSet(K key, String path, V json, SetMode mode) {
        return this.delegate.jsonSet(key, path, json, mode);
    }

    @Override
    public RedisFuture<String> jsonMerge(K key, String path, V json) {
        return this.delegate.jsonMerge(key, path, json);
    }

    @Override
    public RedisFuture<String> jsonType(K key) {
        return this.delegate.jsonType(key);
    }

    @Override
    public RedisFuture<String> jsonType(K key, String path) {
        return this.delegate.jsonType(key, path);
    }

    @Override
    public RedisFuture<V> jsonNumincrby(K key, String path, double number) {
        return this.delegate.jsonNumincrby(key, path, number);
    }

    @Override
    public RedisFuture<V> jsonNummultby(K key, String path, double number) {
        return this.delegate.jsonNummultby(key, path, number);
    }

    @Override
    public RedisFuture<Long> jsonStrappend(K key, V json) {
        return this.delegate.jsonStrappend(key, json);
    }

    @Override
    public RedisFuture<Long> jsonStrappend(K key, String path, V json) {
        return this.delegate.jsonStrappend(key, path, json);
    }

    @Override
    public RedisFuture<Long> jsonStrlen(K key, String path) {
        return this.delegate.jsonStrlen(key, path);
    }

    @Override
    public RedisFuture<Long> jsonArrappend(K key, String path, V ... jsons) {
        return this.delegate.jsonArrappend(key, path, jsons);
    }

    @Override
    public RedisFuture<Long> jsonArrindex(K key, String path, V scalar) {
        return this.delegate.jsonArrindex(key, path, scalar);
    }

    @Override
    public RedisFuture<Long> jsonArrindex(K key, String path, V scalar, Slice slice) {
        return this.delegate.jsonArrindex(key, path, scalar, slice);
    }

    @Override
    public RedisFuture<Long> jsonArrinsert(K key, String path, long index, V ... jsons) {
        return this.delegate.jsonArrinsert(key, path, index, jsons);
    }

    @Override
    public RedisFuture<Long> jsonArrlen(K key) {
        return this.delegate.jsonArrlen(key);
    }

    @Override
    public RedisFuture<Long> jsonArrlen(K key, String path) {
        return this.delegate.jsonArrlen(key, path);
    }

    @Override
    public RedisFuture<V> jsonArrpop(K key) {
        return this.delegate.jsonArrpop(key);
    }

    @Override
    public RedisFuture<V> jsonArrpop(K key, ArrpopOptions<K> options) {
        return this.delegate.jsonArrpop(key, options);
    }

    @Override
    public RedisFuture<Long> jsonArrtrim(K key, String path, long start, long stop) {
        return this.delegate.jsonArrtrim(key, path, start, stop);
    }

    @Override
    public RedisFuture<List<K>> jsonObjkeys(K key) {
        return this.delegate.jsonObjkeys(key);
    }

    @Override
    public RedisFuture<List<K>> jsonObjkeys(K key, String path) {
        return this.delegate.jsonObjkeys(key, path);
    }

    @Override
    public RedisFuture<Long> jsonObjlen(K key) {
        return this.delegate.jsonObjlen(key);
    }

    @Override
    public RedisFuture<Long> jsonObjlen(K key, String path) {
        return this.delegate.jsonObjlen(key, path);
    }
}

