/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.collections;

import com.google.common.primitives.Primitives;
import com.mysema.codegen.ECJEvaluatorFactory;
import com.mysema.codegen.Evaluator;
import com.mysema.codegen.EvaluatorFactory;
import com.mysema.codegen.JDKEvaluatorFactory;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.Types;
import com.mysema.codegen.support.ClassUtils;
import com.querydsl.collections.CollQueryFunctions;
import com.querydsl.collections.CollQuerySerializer;
import com.querydsl.collections.CollQueryTemplates;
import com.querydsl.core.JoinExpression;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.support.CollectionAnyVisitor;
import com.querydsl.core.support.Context;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.ParamNotSetException;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Visitor;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.tools.JavaCompiler;

public class DefaultEvaluatorFactory {
    private final EvaluatorFactory factory;
    private final CollQueryTemplates templates;
    private final CollectionAnyVisitor collectionAnyVisitor = new CollectionAnyVisitor();

    public DefaultEvaluatorFactory(CollQueryTemplates templates) {
        this(templates, Thread.currentThread().getContextClassLoader());
    }

    public DefaultEvaluatorFactory(CollQueryTemplates templates, EvaluatorFactory factory) {
        this.templates = templates;
        this.factory = factory;
    }

    protected DefaultEvaluatorFactory(CollQueryTemplates templates, URLClassLoader classLoader, JavaCompiler compiler) {
        this.templates = templates;
        this.factory = new JDKEvaluatorFactory(classLoader, compiler);
    }

    protected DefaultEvaluatorFactory(CollQueryTemplates templates, ClassLoader classLoader) {
        this.templates = templates;
        this.factory = classLoader instanceof URLClassLoader ? new JDKEvaluatorFactory((URLClassLoader)classLoader) : new ECJEvaluatorFactory(classLoader);
    }

    public <T> Evaluator<T> create(QueryMetadata metadata, List<? extends Expression<?>> sources, Expression<T> projection) {
        int i;
        CollQuerySerializer serializer = new CollQuerySerializer(this.templates);
        serializer.append("return ");
        if (projection instanceof FactoryExpression) {
            serializer.append("(");
            serializer.append(ClassUtils.getName((Class)projection.getType()));
            serializer.append(")(");
            serializer.handle(projection);
            serializer.append(")");
        } else {
            serializer.handle(projection);
        }
        serializer.append(";");
        Map constantToLabel = serializer.getConstantToLabel();
        Map<String, Object> constants = this.getConstants(metadata, constantToLabel);
        Class[] types = new Class[sources.size()];
        String[] names = new String[sources.size()];
        for (i = 0; i < sources.size(); ++i) {
            types[i] = sources.get(i).getType();
            names[i] = sources.get(i).toString();
        }
        for (i = 0; i < types.length; ++i) {
            if (!Primitives.isWrapperType((Class)types[i])) continue;
            types[i] = Primitives.unwrap((Class)types[i]);
        }
        return this.factory.createEvaluator(serializer.toString(), projection.getType(), names, types, constants);
    }

    public <T> Evaluator<List<T>> createEvaluator(QueryMetadata metadata, Expression<? extends T> source, Predicate filter) {
        String typeName = ClassUtils.getName((Class)source.getType());
        CollQuerySerializer ser = new CollQuerySerializer(this.templates);
        ser.append("java.util.List<" + typeName + "> rv = new java.util.ArrayList<" + typeName + ">();\n");
        ser.append("for (" + typeName + " " + source + " : " + source + "_) {\n");
        ser.append("    try {\n");
        ((CollQuerySerializer)((CollQuerySerializer)ser.append("        if (")).handle((Expression)filter)).append(") {\n");
        ser.append("            rv.add(" + source + ");\n");
        ser.append("        }\n");
        ser.append("    } catch (NullPointerException npe) { }\n");
        ser.append("}\n");
        ser.append("return rv;");
        Map constantToLabel = ser.getConstantToLabel();
        Map<String, Object> constants = this.getConstants(metadata, constantToLabel);
        ClassType sourceType = new ClassType(TypeCategory.SIMPLE, source.getType(), new Type[0]);
        ClassType sourceListType = new ClassType(TypeCategory.SIMPLE, Iterable.class, new Type[]{sourceType});
        return this.factory.createEvaluator(ser.toString(), sourceListType, new String[]{source + "_"}, new Type[]{sourceListType}, new Class[]{Iterable.class}, constants);
    }

    public Evaluator<List<Object[]>> createEvaluator(QueryMetadata metadata, List<JoinExpression> joins, @Nullable Predicate filter) {
        ArrayList<String> sourceNames = new ArrayList<String>();
        ArrayList<SimpleType> sourceTypes = new ArrayList<SimpleType>();
        ArrayList<Class<Iterable>> sourceClasses = new ArrayList<Class<Iterable>>();
        StringBuilder vars = new StringBuilder();
        CollQuerySerializer ser = new CollQuerySerializer(this.templates);
        ser.append("java.util.List<Object[]> rv = new java.util.ArrayList<Object[]>();\n");
        ArrayList<String> anyJoinMatchers = new ArrayList<String>();
        block4: for (JoinExpression join : joins) {
            Expression target = join.getTarget();
            String typeName = ClassUtils.getName((Class)target.getType());
            if (vars.length() > 0) {
                vars.append(",");
            }
            switch (join.getType()) {
                case DEFAULT: {
                    ser.append("for (" + typeName + " " + target + " : " + target + "_) {\n");
                    vars.append(target);
                    sourceNames.add(target + "_");
                    sourceTypes.add(new SimpleType((Type)Types.ITERABLE, new Type[]{new ClassType(TypeCategory.SIMPLE, target.getType(), new Type[0])}));
                    sourceClasses.add(Iterable.class);
                    continue block4;
                }
                case INNERJOIN: 
                case LEFTJOIN: {
                    Operation alias = (Operation)join.getTarget();
                    boolean colAnyJoin = join.getCondition() != null && join.getCondition().toString().equals("any");
                    boolean leftJoin = join.getType() == JoinType.LEFTJOIN;
                    String matcher = null;
                    if (colAnyJoin) {
                        matcher = alias.getArg(1).toString() + "_matched";
                        ser.append("boolean " + matcher + " = false;\n");
                        anyJoinMatchers.add(matcher);
                    }
                    ser.append("for (" + typeName + " " + alias.getArg(1) + " : ");
                    if (leftJoin) {
                        ser.append(CollQueryFunctions.class.getName() + ".leftJoin(");
                    }
                    if (colAnyJoin) {
                        Context context = new Context();
                        Expression replacement = (Expression)alias.getArg(0).accept((Visitor)this.collectionAnyVisitor, (Object)context);
                        ser.handle(replacement);
                    } else {
                        ser.handle(alias.getArg(0));
                    }
                    if (alias.getArg(0).getType().equals(Map.class)) {
                        ser.append(".values()");
                    }
                    if (leftJoin) {
                        ser.append(")");
                    }
                    ser.append(") {\n");
                    if (matcher != null) {
                        ser.append("if (!" + matcher + ") {\n");
                    }
                    vars.append(alias.getArg(1));
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Illegal join expression " + join);
        }
        if (filter != null) {
            ser.append("try {\n");
            ser.append("if (");
            ((CollQuerySerializer)ser.handle((Expression)filter)).append(") {\n");
            for (String matcher : anyJoinMatchers) {
                ser.append("    " + matcher + " = true;\n");
            }
            ser.append("    rv.add(new Object[]{" + vars + "});\n");
            ser.append("}\n");
            ser.append("} catch (NullPointerException npe) { }\n");
        } else {
            ser.append("rv.add(new Object[]{" + vars + "});\n");
        }
        int amount = joins.size() + anyJoinMatchers.size();
        for (int i = 0; i < amount; ++i) {
            ser.append("}\n");
        }
        ser.append("return rv;");
        Map constantToLabel = ser.getConstantToLabel();
        Map<String, Object> constants = this.getConstants(metadata, constantToLabel);
        ClassType projectionType = new ClassType(TypeCategory.LIST, List.class, new Type[]{Types.OBJECTS});
        return this.factory.createEvaluator(ser.toString(), projectionType, sourceNames.toArray(new String[sourceNames.size()]), sourceTypes.toArray(new Type[sourceTypes.size()]), sourceClasses.toArray(new Class[sourceClasses.size()]), constants);
    }

    private Map<String, Object> getConstants(QueryMetadata metadata, Map<Object, String> constantToLabel) {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        for (Map.Entry<Object, String> entry : constantToLabel.entrySet()) {
            if (entry.getKey() instanceof ParamExpression) {
                Object value = metadata.getParams().get(entry.getKey());
                if (value == null) {
                    throw new ParamNotSetException((ParamExpression)entry.getKey());
                }
                constants.put(entry.getValue(), value);
                continue;
            }
            constants.put(entry.getValue(), entry.getKey());
        }
        return constants;
    }
}

