/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.collections;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import com.querydsl.collections.CollQueryFunctions;
import com.querydsl.collections.CollQueryTemplates;
import com.querydsl.core.QueryException;
import com.querydsl.core.support.SerializerBase;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathType;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.Template;
import com.querydsl.core.types.Templates;
import com.querydsl.core.types.Visitor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CollQuerySerializer
extends SerializerBase<CollQuerySerializer> {
    private static final Set<Class<?>> WRAPPER_TYPES = ImmutableSet.copyOf((Collection)Primitives.allWrapperTypes());
    private static final Map<Operator, String> OPERATOR_SYMBOLS = Maps.newIdentityHashMap();
    private static final Map<Class<?>, String> CAST_SUFFIXES = Maps.newHashMap();

    public CollQuerySerializer(CollQueryTemplates templates) {
        super((Templates)templates);
    }

    public Void visit(Path<?> path, Void context) {
        PathType pathType = path.getMetadata().getPathType();
        if (pathType == PathType.PROPERTY) {
            Path parent = path.getMetadata().getParent();
            String property = path.getMetadata().getName();
            Class parentType = parent.getType();
            try {
                Method m = this.getAccessor(parentType, property);
                if (m != null && Modifier.isPublic(m.getModifiers())) {
                    this.handle((Expression)parent);
                    ((CollQuerySerializer)((CollQuerySerializer)this.append(".")).append(m.getName())).append("()");
                }
                Field f = this.getField(parentType, property);
                if (f != null && Modifier.isPublic(f.getModifiers())) {
                    this.handle((Expression)parent);
                    ((CollQuerySerializer)this.append(".")).append(property);
                }
                this.append(CollQueryFunctions.class.getName() + ".<");
                ((CollQuerySerializer)this.append(path.getType().getName())).append(">get(");
                this.handle((Expression)parent);
                this.append(", \"" + property + "\")");
            }
            catch (Exception e) {
                throw new QueryException((Throwable)e);
            }
        } else if (pathType == PathType.DELEGATE) {
            this.append("(");
            ((CollQuerySerializer)((CollQuerySerializer)this.append("(")).append(path.getType().getName())).append(")");
            path.getMetadata().getParent().accept((Visitor)this, (Object)context);
            this.append(")");
        } else {
            ArrayList<Object> args = new ArrayList<Object>(2);
            if (path.getMetadata().getParent() != null) {
                args.add(path.getMetadata().getParent());
            }
            args.add(path.getMetadata().getElement());
            Template template = this.getTemplate((Operator)pathType);
            for (Template.Element element : template.getElements()) {
                Object rv = element.convert(args);
                if (rv instanceof Expression) {
                    ((Expression)rv).accept((Visitor)this, (Object)context);
                    continue;
                }
                if (element.isString()) {
                    this.append(rv.toString());
                    continue;
                }
                this.visitConstant(rv);
            }
        }
        return null;
    }

    private Method getAccessor(Class<?> owner, String property) {
        try {
            PropertyDescriptor[] descriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(owner);
            for (PropertyDescriptor pd : descriptors = beanInfo.getPropertyDescriptors()) {
                if (!pd.getName().equals(property)) continue;
                return pd.getReadMethod();
            }
            return null;
        }
        catch (IntrospectionException e) {
            return null;
        }
    }

    private Field getField(Class<?> owner, String field) {
        try {
            return owner.getField(field);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public Void visit(SubQueryExpression<?> expr, Void context) {
        throw new IllegalArgumentException("Not supported");
    }

    private void visitCast(Operator operator, Expression<?> source, Class<?> targetType) {
        if (Number.class.isAssignableFrom(source.getType()) && !Constant.class.isInstance(source)) {
            ((CollQuerySerializer)((CollQuerySerializer)this.append("new ")).append(source.getType().getSimpleName())).append("(");
            this.handle(source);
            this.append(")");
        } else {
            this.handle(source);
        }
        if (!CAST_SUFFIXES.containsKey(targetType)) {
            throw new IllegalArgumentException("Unsupported cast type " + targetType.getName());
        }
        this.append(CAST_SUFFIXES.get(targetType));
    }

    protected void visitOperation(Class<?> type, Operator operator, List<? extends Expression<?>> args) {
        if (Ops.aggOps.contains(operator)) {
            throw new UnsupportedOperationException("Aggregation operators are only supported as single expressions");
        }
        if (args.size() == 2 && OPERATOR_SYMBOLS.containsKey(operator) && CollQuerySerializer.isPrimitive(args.get(0).getType()) && CollQuerySerializer.isPrimitive(args.get(1).getType())) {
            this.handle(args.get(0));
            this.append(OPERATOR_SYMBOLS.get(operator));
            this.handle(args.get(1));
            if (args.get(1) instanceof Constant) {
                this.append(CAST_SUFFIXES.get(args.get(1).getType()));
            }
            return;
        }
        if (operator == Ops.STRING_CAST) {
            this.visitCast(operator, args.get(0), String.class);
        } else if (operator == Ops.NUMCAST) {
            Constant rightArg = (Constant)args.get(1);
            this.visitCast(operator, args.get(0), (Class)rightArg.getConstant());
        } else {
            super.visitOperation(type, operator, args);
        }
    }

    private static boolean isPrimitive(Class<?> type) {
        return type.isPrimitive() || WRAPPER_TYPES.contains(type);
    }

    public Void visit(FactoryExpression<?> expr, Void context) {
        this.visitConstant(expr);
        this.append(".newInstance(");
        this.handle(", ", expr.getArgs());
        this.append(")");
        return null;
    }

    static {
        OPERATOR_SYMBOLS.put((Operator)Ops.EQ, " == ");
        OPERATOR_SYMBOLS.put((Operator)Ops.NE, " != ");
        OPERATOR_SYMBOLS.put((Operator)Ops.GT, " > ");
        OPERATOR_SYMBOLS.put((Operator)Ops.LT, " < ");
        OPERATOR_SYMBOLS.put((Operator)Ops.GOE, " >= ");
        OPERATOR_SYMBOLS.put((Operator)Ops.LOE, " <= ");
        OPERATOR_SYMBOLS.put((Operator)Ops.ADD, " + ");
        OPERATOR_SYMBOLS.put((Operator)Ops.SUB, " - ");
        OPERATOR_SYMBOLS.put((Operator)Ops.MULT, " * ");
        OPERATOR_SYMBOLS.put((Operator)Ops.DIV, " / ");
        CAST_SUFFIXES.put(Boolean.class, ".booleanValue()");
        CAST_SUFFIXES.put(Byte.class, ".byteValue()");
        CAST_SUFFIXES.put(Character.class, ".charValue()");
        CAST_SUFFIXES.put(Double.class, ".doubleValue()");
        CAST_SUFFIXES.put(Float.class, ".floatValue()");
        CAST_SUFFIXES.put(Integer.class, ".intValue()");
        CAST_SUFFIXES.put(Long.class, ".longValue()");
        CAST_SUFFIXES.put(Short.class, ".shortValue()");
        CAST_SUFFIXES.put(String.class, ".toString()");
    }
}

