/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.xray.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GroupInsightsConfiguration {
    private Boolean insightsEnabled;
    @Nullable
    private Boolean notificationsEnabled;

    private GroupInsightsConfiguration() {
    }

    public Boolean insightsEnabled() {
        return this.insightsEnabled;
    }

    public Optional<Boolean> notificationsEnabled() {
        return Optional.ofNullable(this.notificationsEnabled);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GroupInsightsConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private Boolean insightsEnabled;
        @Nullable
        private Boolean notificationsEnabled;

        public Builder() {
        }

        public Builder(GroupInsightsConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.insightsEnabled = defaults.insightsEnabled;
            this.notificationsEnabled = defaults.notificationsEnabled;
        }

        @CustomType.Setter
        public Builder insightsEnabled(Boolean insightsEnabled) {
            this.insightsEnabled = Objects.requireNonNull(insightsEnabled);
            return this;
        }

        @CustomType.Setter
        public Builder notificationsEnabled(@Nullable Boolean notificationsEnabled) {
            this.notificationsEnabled = notificationsEnabled;
            return this;
        }

        public GroupInsightsConfiguration build() {
            GroupInsightsConfiguration o = new GroupInsightsConfiguration();
            o.insightsEnabled = this.insightsEnabled;
            o.notificationsEnabled = this.notificationsEnabled;
            return o;
        }
    }
}

