/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.wafv2.outputs;

import com.pulumi.aws.wafv2.outputs.RuleGroupRuleAction;
import com.pulumi.aws.wafv2.outputs.RuleGroupRuleCaptchaConfig;
import com.pulumi.aws.wafv2.outputs.RuleGroupRuleRuleLabel;
import com.pulumi.aws.wafv2.outputs.RuleGroupRuleStatement;
import com.pulumi.aws.wafv2.outputs.RuleGroupRuleVisibilityConfig;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class RuleGroupRule {
    private RuleGroupRuleAction action;
    @Nullable
    private RuleGroupRuleCaptchaConfig captchaConfig;
    private String name;
    private Integer priority;
    @Nullable
    private List<RuleGroupRuleRuleLabel> ruleLabels;
    private RuleGroupRuleStatement statement;
    private RuleGroupRuleVisibilityConfig visibilityConfig;

    private RuleGroupRule() {
    }

    public RuleGroupRuleAction action() {
        return this.action;
    }

    public Optional<RuleGroupRuleCaptchaConfig> captchaConfig() {
        return Optional.ofNullable(this.captchaConfig);
    }

    public String name() {
        return this.name;
    }

    public Integer priority() {
        return this.priority;
    }

    public List<RuleGroupRuleRuleLabel> ruleLabels() {
        return this.ruleLabels == null ? List.of() : this.ruleLabels;
    }

    public RuleGroupRuleStatement statement() {
        return this.statement;
    }

    public RuleGroupRuleVisibilityConfig visibilityConfig() {
        return this.visibilityConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RuleGroupRule defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private RuleGroupRuleAction action;
        @Nullable
        private RuleGroupRuleCaptchaConfig captchaConfig;
        private String name;
        private Integer priority;
        @Nullable
        private List<RuleGroupRuleRuleLabel> ruleLabels;
        private RuleGroupRuleStatement statement;
        private RuleGroupRuleVisibilityConfig visibilityConfig;

        public Builder() {
        }

        public Builder(RuleGroupRule defaults) {
            Objects.requireNonNull(defaults);
            this.action = defaults.action;
            this.captchaConfig = defaults.captchaConfig;
            this.name = defaults.name;
            this.priority = defaults.priority;
            this.ruleLabels = defaults.ruleLabels;
            this.statement = defaults.statement;
            this.visibilityConfig = defaults.visibilityConfig;
        }

        @CustomType.Setter
        public Builder action(RuleGroupRuleAction action) {
            this.action = Objects.requireNonNull(action);
            return this;
        }

        @CustomType.Setter
        public Builder captchaConfig(@Nullable RuleGroupRuleCaptchaConfig captchaConfig) {
            this.captchaConfig = captchaConfig;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @CustomType.Setter
        public Builder priority(Integer priority) {
            this.priority = Objects.requireNonNull(priority);
            return this;
        }

        @CustomType.Setter
        public Builder ruleLabels(@Nullable List<RuleGroupRuleRuleLabel> ruleLabels) {
            this.ruleLabels = ruleLabels;
            return this;
        }

        public Builder ruleLabels(RuleGroupRuleRuleLabel ... ruleLabels) {
            return this.ruleLabels(List.of(ruleLabels));
        }

        @CustomType.Setter
        public Builder statement(RuleGroupRuleStatement statement) {
            this.statement = Objects.requireNonNull(statement);
            return this;
        }

        @CustomType.Setter
        public Builder visibilityConfig(RuleGroupRuleVisibilityConfig visibilityConfig) {
            this.visibilityConfig = Objects.requireNonNull(visibilityConfig);
            return this;
        }

        public RuleGroupRule build() {
            RuleGroupRule o = new RuleGroupRule();
            o.action = this.action;
            o.captchaConfig = this.captchaConfig;
            o.name = this.name;
            o.priority = this.priority;
            o.ruleLabels = this.ruleLabels;
            o.statement = this.statement;
            o.visibilityConfig = this.visibilityConfig;
            return o;
        }
    }
}

