/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.transfer.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ConnectorAs2Config {
    private String compression;
    private String encryptionAlgorithm;
    private String localProfileId;
    private String mdnResponse;
    @Nullable
    private String mdnSigningAlgorithm;
    @Nullable
    private String messageSubject;
    private String partnerProfileId;
    private String signingAlgorithm;

    private ConnectorAs2Config() {
    }

    public String compression() {
        return this.compression;
    }

    public String encryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String localProfileId() {
        return this.localProfileId;
    }

    public String mdnResponse() {
        return this.mdnResponse;
    }

    public Optional<String> mdnSigningAlgorithm() {
        return Optional.ofNullable(this.mdnSigningAlgorithm);
    }

    public Optional<String> messageSubject() {
        return Optional.ofNullable(this.messageSubject);
    }

    public String partnerProfileId() {
        return this.partnerProfileId;
    }

    public String signingAlgorithm() {
        return this.signingAlgorithm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConnectorAs2Config defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String compression;
        private String encryptionAlgorithm;
        private String localProfileId;
        private String mdnResponse;
        @Nullable
        private String mdnSigningAlgorithm;
        @Nullable
        private String messageSubject;
        private String partnerProfileId;
        private String signingAlgorithm;

        public Builder() {
        }

        public Builder(ConnectorAs2Config defaults) {
            Objects.requireNonNull(defaults);
            this.compression = defaults.compression;
            this.encryptionAlgorithm = defaults.encryptionAlgorithm;
            this.localProfileId = defaults.localProfileId;
            this.mdnResponse = defaults.mdnResponse;
            this.mdnSigningAlgorithm = defaults.mdnSigningAlgorithm;
            this.messageSubject = defaults.messageSubject;
            this.partnerProfileId = defaults.partnerProfileId;
            this.signingAlgorithm = defaults.signingAlgorithm;
        }

        @CustomType.Setter
        public Builder compression(String compression) {
            this.compression = Objects.requireNonNull(compression);
            return this;
        }

        @CustomType.Setter
        public Builder encryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = Objects.requireNonNull(encryptionAlgorithm);
            return this;
        }

        @CustomType.Setter
        public Builder localProfileId(String localProfileId) {
            this.localProfileId = Objects.requireNonNull(localProfileId);
            return this;
        }

        @CustomType.Setter
        public Builder mdnResponse(String mdnResponse) {
            this.mdnResponse = Objects.requireNonNull(mdnResponse);
            return this;
        }

        @CustomType.Setter
        public Builder mdnSigningAlgorithm(@Nullable String mdnSigningAlgorithm) {
            this.mdnSigningAlgorithm = mdnSigningAlgorithm;
            return this;
        }

        @CustomType.Setter
        public Builder messageSubject(@Nullable String messageSubject) {
            this.messageSubject = messageSubject;
            return this;
        }

        @CustomType.Setter
        public Builder partnerProfileId(String partnerProfileId) {
            this.partnerProfileId = Objects.requireNonNull(partnerProfileId);
            return this;
        }

        @CustomType.Setter
        public Builder signingAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = Objects.requireNonNull(signingAlgorithm);
            return this;
        }

        public ConnectorAs2Config build() {
            ConnectorAs2Config o = new ConnectorAs2Config();
            o.compression = this.compression;
            o.encryptionAlgorithm = this.encryptionAlgorithm;
            o.localProfileId = this.localProfileId;
            o.mdnResponse = this.mdnResponse;
            o.mdnSigningAlgorithm = this.mdnSigningAlgorithm;
            o.messageSubject = this.messageSubject;
            o.partnerProfileId = this.partnerProfileId;
            o.signingAlgorithm = this.signingAlgorithm;
            return o;
        }
    }
}

