/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.synthetics.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CanaryVpcConfig {
    @Nullable
    private List<String> securityGroupIds;
    @Nullable
    private List<String> subnetIds;
    @Nullable
    private String vpcId;

    private CanaryVpcConfig() {
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds == null ? List.of() : this.securityGroupIds;
    }

    public List<String> subnetIds() {
        return this.subnetIds == null ? List.of() : this.subnetIds;
    }

    public Optional<String> vpcId() {
        return Optional.ofNullable(this.vpcId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CanaryVpcConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<String> securityGroupIds;
        @Nullable
        private List<String> subnetIds;
        @Nullable
        private String vpcId;

        public Builder() {
        }

        public Builder(CanaryVpcConfig defaults) {
            Objects.requireNonNull(defaults);
            this.securityGroupIds = defaults.securityGroupIds;
            this.subnetIds = defaults.subnetIds;
            this.vpcId = defaults.vpcId;
        }

        @CustomType.Setter
        public Builder securityGroupIds(@Nullable List<String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        public Builder securityGroupIds(String ... securityGroupIds) {
            return this.securityGroupIds(List.of(securityGroupIds));
        }

        @CustomType.Setter
        public Builder subnetIds(@Nullable List<String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        public Builder subnetIds(String ... subnetIds) {
            return this.subnetIds(List.of(subnetIds));
        }

        @CustomType.Setter
        public Builder vpcId(@Nullable String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public CanaryVpcConfig build() {
            CanaryVpcConfig o = new CanaryVpcConfig();
            o.securityGroupIds = this.securityGroupIds;
            o.subnetIds = this.subnetIds;
            o.vpcId = this.vpcId;
            return o;
        }
    }
}

